/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import java.util.Locale;
import java.util.Objects;
import org.molgenis.bootstrap.populate.UsersGroupsAuthoritiesPopulator;
import org.molgenis.core.framework.db.WebAppDatabasePopulatorService;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.i18n.model.LanguageFactory;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebAppDatabasePopulatorServiceImpl
implements WebAppDatabasePopulatorService {
    private final DataService dataService;
    private final UsersGroupsAuthoritiesPopulator usersGroupsAuthoritiesPopulator;
    private final LanguageFactory languageFactory;

    @Autowired
    public WebAppDatabasePopulatorServiceImpl(DataService dataService, UsersGroupsAuthoritiesPopulator usersGroupsAuthoritiesPopulator, LanguageFactory languageFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.usersGroupsAuthoritiesPopulator = Objects.requireNonNull(usersGroupsAuthoritiesPopulator);
        this.languageFactory = Objects.requireNonNull(languageFactory);
    }

    @Transactional
    @RunAsSystem
    public void populateDatabase() {
        this.usersGroupsAuthoritiesPopulator.populate();
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("en", "English", true));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("nl", new Locale("nl").getDisplayName(new Locale("nl")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("pt", new Locale("pt").getDisplayName(new Locale("pt")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("es", new Locale("es").getDisplayName(new Locale("es")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("de", new Locale("de").getDisplayName(new Locale("de")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("it", new Locale("it").getDisplayName(new Locale("it")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("fr", new Locale("fr").getDisplayName(new Locale("fr")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("xx", "My language", false));
    }

    @Transactional
    @RunAsSystem
    public boolean isDatabasePopulated() {
        return this.dataService.count("sys_sec_User") > 0L;
    }
}

