/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import com.google.api.client.util.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.molgenis.bootstrap.populate.SystemEntityRegistry;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.security.auth.Group;
import org.molgenis.data.security.auth.GroupAuthority;
import org.molgenis.data.security.auth.GroupAuthorityFactory;
import org.molgenis.data.security.auth.GroupFactory;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserAuthority;
import org.molgenis.data.security.auth.UserAuthorityFactory;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebAppSystemEntityRegistry
implements SystemEntityRegistry {
    private static final String DATA_EXPLORER_SETTINGS = "sys_set_dataexplorer";
    private static final List<String> DATA_MANAGER_ENTITY_READ_AUTHORITIES = Arrays.asList("sys_FreemarkerTemplate", "bbmri_nl_data_category_types", "bbmri_nl_age_types", "bbmri_nl_collection_types", "bbmri_nl_countries", "bbmri_nl_disease_types", "bbmri_nl_exp_data_types", "bbmri_nl_material_types", "bbmri_nl_sample_size_types", "bbmri_nl_sex_types", "bbmri_nl_staff_size_types", "sys_set_dataexplorer");
    private static final List<String> DATA_MANAGER_ENTITY_WRITE_AUTHORITIES = Arrays.asList("bbmri_nl_biobanks", "bbmri_nl_juristic_persons", "bbmri_nl_persons", "bbmri_nl_publications", "bbmri_nl_sample_collections");
    private static final List<String> DATA_MANAGER_PLUGIN_READ_AUTHORITIES = Arrays.asList("background", "redirect", "importwizard");
    private static final List<String> DATA_MANAGER_PLUGIN_WRITE_AUTHORITIES = Arrays.asList("dataexplorer", "scheduledjobs");
    private static final List<String> ALL_USERS_ENTITY_READ_AUTHORITIES = Arrays.asList("sys_FreemarkerTemplate", "sys_Language", "sys_set_dataexplorer");
    private static final List<String> ALL_USERS_PLUGIN_READ_AUTHORITIES = Arrays.asList("home", "redirect");
    private static final List<String> ALL_USERS_PLUGIN_WRITE_AUTHORITIES = Collections.singletonList("useraccount");
    private static final List<String> ANONYMOUS_USER_PLUGIN_READ_AUTHORITIES = Arrays.asList("home", "redirect", "feedback", "dataexplorer");
    private static final List<String> ANONYMOUS_USER_ENTITY_READ_AUTHORITIES = Arrays.asList("sys_FreemarkerTemplate", "bbmri_nl_age_types", "sys_md_EntityType", "sys_md_Attribute", "sys_md_Package", "bbmri_nl_biobanks", "bbmri_nl_collection_types", "bbmri_nl_countries", "bbmri_nl_data_category_types", "bbmri_nl_disease_types", "bbmri_nl_exp_data_types", "bbmri_nl_juristic_persons", "bbmri_nl_material_types", "sys_Language", "bbmri_nl_persons", "bbmri_nl_publications", "bbmri_nl_sample_collections", "bbmri_nl_sample_size_types", "bbmri_nl_sex_types", "bbmri_nl_staff_size_types", "sys_set_dataexplorer", "sys_genomebrowser_GenomeBrowserAttributes", "sys_genomebrowser_GenomeBrowserSettings");
    private final DataService dataService;
    private final UserAuthorityFactory userAuthorityFactory;
    private final GroupAuthorityFactory groupAuthorityFactory;
    private final GroupFactory groupFactory;

    @Autowired
    public WebAppSystemEntityRegistry(DataService dataService, UserAuthorityFactory userAuthorityFactory, GroupAuthorityFactory groupAuthorityFactory, GroupFactory groupFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.groupAuthorityFactory = Objects.requireNonNull(groupAuthorityFactory);
        this.groupFactory = Objects.requireNonNull(groupFactory);
    }

    public Collection<Entity> getEntities() {
        Group dataManagerGroup = this.createDataManagerGroup();
        Group allUsersGroup = this.getAllUsersGroup();
        User anonymousUser = this.getAnonymousUser();
        List groupAuthorities = this.createGroupAuthorities(dataManagerGroup, allUsersGroup);
        List userAuthorities = this.createUserAuthorities(anonymousUser);
        ArrayList entities = Lists.newArrayList();
        entities.add(dataManagerGroup);
        entities.addAll(groupAuthorities);
        entities.addAll(userAuthorities);
        return entities;
    }

    private Group createDataManagerGroup() {
        Group dataManagerGroup = (Group)this.groupFactory.create();
        dataManagerGroup.setName("Data Managers");
        return dataManagerGroup;
    }

    private Group getAllUsersGroup() {
        return (Group)this.dataService.findOne("sys_sec_Group", new QueryImpl().eq("name", (Object)"All Users"), Group.class);
    }

    private User getAnonymousUser() {
        return (User)this.dataService.findOne("sys_sec_User", new QueryImpl().eq("username", (Object)"anonymous"), User.class);
    }

    private List<UserAuthority> createUserAuthorities(User anonymousUser) {
        ArrayList userAuthorities = Lists.newArrayList();
        ANONYMOUS_USER_ENTITY_READ_AUTHORITIES.stream().map(entity -> this.createUserAuthority(anonymousUser, SecurityUtils.AUTHORITY_ENTITY_READ_PREFIX + entity)).forEach(userAuthorities::add);
        ANONYMOUS_USER_PLUGIN_READ_AUTHORITIES.stream().map(plugin -> this.createUserAuthority(anonymousUser, SecurityUtils.AUTHORITY_PLUGIN_READ_PREFIX + plugin)).forEach(userAuthorities::add);
        return userAuthorities;
    }

    private List<GroupAuthority> createGroupAuthorities(Group dataManagerGroup, Group allUsersGroup) {
        ArrayList groupAuthorities = Lists.newArrayList();
        DATA_MANAGER_ENTITY_READ_AUTHORITIES.stream().map(entity -> this.createGroupAuthority(dataManagerGroup, SecurityUtils.AUTHORITY_ENTITY_READ_PREFIX + entity)).forEach(groupAuthorities::add);
        DATA_MANAGER_ENTITY_WRITE_AUTHORITIES.stream().map(entity -> this.createGroupAuthority(dataManagerGroup, SecurityUtils.AUTHORITY_ENTITY_WRITE_PREFIX + entity)).forEach(groupAuthorities::add);
        DATA_MANAGER_PLUGIN_READ_AUTHORITIES.stream().map(plugin -> this.createGroupAuthority(dataManagerGroup, SecurityUtils.AUTHORITY_PLUGIN_READ_PREFIX + plugin)).forEach(groupAuthorities::add);
        DATA_MANAGER_PLUGIN_WRITE_AUTHORITIES.stream().map(plugin -> this.createGroupAuthority(dataManagerGroup, SecurityUtils.AUTHORITY_PLUGIN_WRITE_PREFIX + plugin)).forEach(groupAuthorities::add);
        ALL_USERS_ENTITY_READ_AUTHORITIES.stream().map(entity -> this.createGroupAuthority(allUsersGroup, SecurityUtils.AUTHORITY_ENTITY_READ_PREFIX + entity)).forEach(groupAuthorities::add);
        ALL_USERS_PLUGIN_READ_AUTHORITIES.stream().map(plugin -> this.createGroupAuthority(allUsersGroup, SecurityUtils.AUTHORITY_PLUGIN_READ_PREFIX + plugin)).forEach(groupAuthorities::add);
        ALL_USERS_PLUGIN_WRITE_AUTHORITIES.stream().map(plugin -> this.createGroupAuthority(allUsersGroup, SecurityUtils.AUTHORITY_PLUGIN_WRITE_PREFIX + plugin)).forEach(groupAuthorities::add);
        return groupAuthorities;
    }

    private GroupAuthority createGroupAuthority(Group group, String role) {
        GroupAuthority groupAuthority = (GroupAuthority)this.groupAuthorityFactory.create();
        groupAuthority.setGroup(group);
        groupAuthority.setRole(role);
        return groupAuthority;
    }

    private UserAuthority createUserAuthority(User user, String role) {
        UserAuthority userAuthority = (UserAuthority)this.userAuthorityFactory.create();
        userAuthority.setUser(user);
        userAuthority.setRole(role);
        return userAuthority;
    }
}

