/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import java.util.List;
import java.util.Objects;
import org.molgenis.promise.mapper.PromiseMapper;
import org.molgenis.promise.mapper.PromiseMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;
import org.springframework.stereotype.Component;

@Component
public class PromiseBootstrapper
implements ApplicationListener<ContextRefreshedEvent>,
PriorityOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(PromiseBootstrapper.class);
    private final PromiseMapperFactory promiseMapperFactory;
    private final List<PromiseMapper> promiseMapper;

    public PromiseBootstrapper(PromiseMapperFactory promiseMapperFactory, List<PromiseMapper> promiseMapper) {
        this.promiseMapperFactory = Objects.requireNonNull(promiseMapperFactory);
        this.promiseMapper = Objects.requireNonNull(promiseMapper);
    }

    private void bootstrap() {
        LOG.info("Bootstrapping ProMISe mappers...");
        this.promiseMapper.forEach(arg_0 -> ((PromiseMapperFactory)this.promiseMapperFactory).registerMapper(arg_0));
        LOG.info("Bootstrapping ProMISe mappers completed");
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.bootstrap();
    }

    public int getOrder() {
        return -2147483647;
    }
}

