### Name: findMultiplePeaks
### Title: Cluster multiple mass peaks based on correlation and mass
### Aliases: findMultiplePeaks


### ** Examples

## load the example data provided with this package                         
data(traits2)   
data(peaks2)    
data(genotypes)     
data(markers)                                         
                                             
##OR: load your own data                     
#traits2      <- loadData("traits2.csv")
#peaks2       <- loadData("peaks2.csv")
#genotypes    <- loadData("genotypes.csv")
#markers      <- loadData("markers.csv")
                                             
##calculate the two part qtl
qtlProfiles   <- qtlMapTwoPart(genotypes=genotypes, traits=traits2, spike=4)
  
##set the qtl threshold
qtlThres      <- 3.79

##OR: estimate the threshold yourself
#qtlThres     <- qtlThreshold(genotypes, traits, spike=4)
  
##calculate zero order correlation
corrZeroOrder <- qtlCorrZeroOrder(markers, qtlProfiles, qtlThres)

##find multiple peaks
multiplePeaks <- findMultiplePeaks(corrZeroOrder, peaks2)

##show summary
multiplePeaks



