### Name: createCytoFiles
### Title: Write Cytoscape visualization files
### Aliases: createCytoFiles


### ** Examples

##NOTE: this method can be used on any correlation matrix.
#Here we use MetaNetwork methods.

## load the example data provided with this package                        
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers        <- loadData("markers.csv")
#genotypes      <- loadData("genotypes.csv")
#traits         <- loadData("traits.csv")  
                                             
##calculate the two part qtl
qtlProfiles     <- qtlMapTwoPart(genotypes=genotypes, traits=traits, spike=4)
  
##set the qtl threshold
qtlThres        <- 3.79

##OR: estimate the threshold yourself
#qtlThres       <- qtlThreshold(genotypes, traits, spike=4)  
  
##calculate zero order correlation
corrZeroOrder   <- qtlCorrZeroOrder(markers, qtlProfiles, qtlThres)

##calculate second order correlation
corrSecondOrder <- qtlCorrSecondOrder( corrZeroOrder ) 

##set the correlation threshold
corrThres       <- 0.14

##OR: estimate qtlCorrThreshold yourself
#corrThres      <- qtlCorThreshold(markers, genotypes, traits, spike=4, qtlThres=qtlThres)  

##create cytoscape files "mynetwork.sif" and "mynetwork.eda"
createCytoFiles(corrSecondOrder, "mynetwork", simThres = corrThres)

cat("cytofiles mynetwork.sif and mynetwork.eda created\n")



