### Name: qtlCorrThreshold
### Title: Estimate correlation threshold
### Aliases: qtlCorrThreshold


### ** Examples

## load the example data provided with this package                        
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers    <- loadData("markers.csv")
#genotypes  <- loadData("genotypes.csv")
#traits     <- loadData("traits.csv")  
                                             
##set the qtl threshold
qtlThres    <- 3.79

##OR: estimate the threshold yourself
#qtlThres   <- qtlThreshold(genotypes, traits, spike=4)

##estimate qtlCorrThreshold with low number of permutations (advised: 10000)
cat("warning: simulating correlations takes a few minutes")
flush.console()
corrThres   <- qtlCorrThreshold(markers, genotypes, traits, spike=4, 
                                qtlThres=qtlThres, n.permutations=10) 

##show threshold
corrThres



