### Name: qtlCorrSecondOrder
### Title: Calculate the second-order correlation
### Aliases: qtlCorrSecondOrder


### ** Examples

## load the example data provided with this package                         
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers        <- loadData("markers.csv")
#genotypes      <- loadData("genotypes.csv")
#traits         <- loadData("traits.csv")  
                                             
##calculate the two part qtl
qtlProfiles     <- qtlMapTwoPart(genotypes=genotypes, traits=traits, spike=4)
  
##set the qtl threshold
qtlThres        <- 3.79

##OR: estimate the threshold yourself
#qtlThres       <- qtlThreshold(genotypes, traits, spike=4)
  
##calculate zero order correlation
corrZeroOrder   <- qtlCorrZeroOrder(markers, qtlProfiles, qtlThres)

##calculate the second order correlation
corrSecondOrder <- qtlCorrSecondOrder(corrZeroOrder=corrZeroOrder)

##view the correlations
corrSecondOrder[1:5,1:5]



