### Name: qtlCorrZeroOrder
### Title: Calculate the zero-order correlation
### Aliases: qtlCorrZeroOrder


### ** Examples

## load the example data provided with this package                         
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers     <- loadData("markers.csv")
#genotypes   <- loadData("genotypes.csv")
#traits      <- loadData("traits.csv")  
                                             
##calculate the two part qtl
qtlProfiles  <- qtlMapTwoPart(genotypes=genotypes, traits=traits, spike=4)
  
##set the qtl threshold
qtlThres     <- 3.79

##OR: estimate the threshold yourself
#qtlThres    <- qtlThreshold(genotypes, traits, spike=4)
  
##calculate zero order correlation
qtlZeroOrder <- qtlCorrZeroOrder(markers, qtlProfiles, qtlThres)

##show the correlations
qtlZeroOrder[1:5,1:5]



