### Name: qtlPlot
### Title: Plot QTL profiles
### Aliases: qtlPlot


### ** Examples

## load the example data provided with this package                     
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers    <- loadData("markers.csv")
#genotypes  <- loadData("genotypes.csv")
#traits     <- loadData("traits.csv")  
                                             
##calculate the two part qtl
qtlProfiles <- qtlMapTwoPart(genotypes=genotypes, traits=traits, spike=4)

##set the qtl threshold
qtlThres    <- 3.79

##OR: estimate the threshold yourself
#qtlThres   <- qtlThreshold(genotypes, traits, spike=4)
                                                                                                                       
##plot the qtlProfiles
qtlPlot(markers, qtlProfiles, qtlThres)



