### Name: qtlSupportInterval
### Title: Estimate QTL support interval
### Aliases: qtlSupportInterval


### ** Examples

## load the example data provided with this package                          
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers    <- loadData("markers.csv")
#genotypes  <- loadData("genotypes.csv")
#traits     <- loadData("traits.csv")  
                                             
##calculate the two part qtl for only the first trait
qtlProfiles <- qtlMapTwoPart(genotypes=genotypes, traits=traits[1,], spike=4)

##set the qtl threshold
qtlThres    <- 3.79

##OR: estimate the threshold yourself
#qtlThres   <- qtlThreshold(genotypes, traits, spike=4)

##calculate qtl confidence interval for the first qtl profile
qtlSuppInt  <- qtlSupportInterval(markers, qtlProfiles[1,], qtlThres=qtlThres, 
                                  interval.dropoff = 1.5)    
                                  
##show the interval
qtlSuppInt                                                             



