### Name: qtlFDR
### Title: Estimate QTL thresholds for false discovery rate (FDR)
### Aliases: qtlFDR


### ** Examples

## load the example data provided with this package                         
data(markers)   
data(genotypes)
data(traits)                                                       
                                             
##OR: load your own data                     
#markers        <- loadData("markers.csv")
#genotypes      <- loadData("genotypes.csv")
#traits         <- loadData("traits.csv")  
                                             
##calculate the two part qtl
qtlProfiles     <- qtlMapTwoPart(genotypes=genotypes, traits=traits, spike=4)
  
##set the qtl threshold
qtlThres        <- 3.79

##OR: estimate the threshold yourself
#qtlThres       <- qtlThreshold(genotypes, traits, spike=4)

##estimate FDR
qtlFDR          <- qtlFDR(qtlProfiles, fdrThres=0.05, qtlThres=qtlThres)

##show FDR for both fdrThres of 0.05 and qtlThres of qtlThres
qtlFDR



