### Name: MetaNetwork
### Title: genetic study of metabolites and network reconstruction
### Aliases: MetaNetwork


### ** Examples

## load the example data provided with this package
data(genotypes)
data(traits)
data(markers)

#set qtlThres
qtlThres    <- 3.79

#run metanetwork with predefined thresholds
MetaNetwork (markers=markers, genotypes=genotypes, traits=traits, spike=4, 
             qtlThres=qtlThres)

##OR: load data from csv
#genotypes <- loadData("genotypes.csv")
#traits    <- loadData("traits.csv")
#markers   <- loadData("markers.csv")
#MetaNetwork (markers=markers, genotypes=genotypes, traits=traits2, 
#             qtlThres=qtlThres, spike=4) 
             
##OR: let MetaNetwork estimate qtlThres and identify multiple peaks
#data(genotypes)
#data(traits2)
#data(markers)
#data(peaks2)
#MetaNetwork (markers=markers, genotypes=genotypes, traits=traits2, 
#             peaks=peaks2, spike=4)                           
  
##show part of the qtlProfiles
qtlProfiles[1:5,1:5]

##show part of the qtl summary
qtlSumm[1:5,]

##show part of the zero order correlation
corrZeroOrder[1:5,1:5]

##show part of the second order correlation
corrSecondOrder[1:5,1:5]

##plot the qtlProfiles
qtlPlot(markers, qtlProfiles, qtlThres)  

##load network.sif and network.eda into Cytoscape 



