# Package: MetaNetwork. A computational tool for genetic study of metabolism
# Function name: qtlThreshold
# Author: Jingyuan Fu <j.fu@rug.nl>
# Version: 1.0 
# Date: 6 Nov. 2006

qtlThreshold <- function( genotypes, traits, spike, n.simulations=1000, alpha=0.05) 
{
    spikeP  <-  function( x ) 
    {
        length( which( x <= spike ) )
    }
    
    sdP2    <-  function( x ) 
    {
       sd( x[x>spike],na.rm=T )
    }
    
    mP2     <-  function( x ) 
    {
        mean( x[x>spike], na.rm=T )
    }
        
    n1  <-  apply( traits, 1, spikeP )
    sd2 <-  apply( traits, 1, sdP2 )
    m2  <-  apply( traits, 1, mP2 )
    
      
        
    simulations <- NULL
    for( i in 1:n.simulations ) 
    {
        values  <-  sample( c( rnorm( ncol(traits)-ceiling(median(n1)), median(m2), 
                             median(sd2)), rep(spike, ceiling(median(n1))) ) ) 
        result  <-  qtlMapTwoPart( genotypes=genotypes, traits=values, 
                                   spike=spike)
        simulations   <-  c( simulations, max(abs(result)) )
    }
    thres <- sort( simulations )[(1-alpha)*n.simulations]
    thres
}
