# Package: MetaNetwork. A computational tool for genetic study of metabolism
# Function name: qtlMapTwoPart
# Author: Jingyuan Fu <j.fu@rug.nl>
# Version: 1.0 
# Date: 6 Nov. 2006     

qtlMapTwoPart <- function( genotypes, traits, spike, filename=NULL) 
{
    sep=","
    n.marker <- nrow( genotypes )
    if( is.vector(traits) ) 
    {
        traits   <-  t( as.matrix(traits) )
    }
    n.traits     <-  nrow(traits)
        
    if( ! is.null( rownames(traits) ) ) 
    {
        name.traits <- rownames( traits )
    } 
    else 
    {
        name.traits <- paste( "trait", 1:n.traits, sep="" )
    }
    if( ! is.null( rownames(genotypes) ) ) 
    { 
        name.marker <- rownames(genotypes)
    } 
    else 
    {
        name.marker <- paste( "M", 1:n.marker, sep="" )
    }
    
    if( any( colnames(genotypes) != colnames(traits) ) )
    {
        stop( "Error: mis-matached order of individuals between",
              " genotypes and traits" )
    }
        
    if( ! is.null(filename) ) 
    {
        cat( "", rownames(genotypes), file=filename, sep=sep, append=F )
        cat( "\n", file=filename, sep="", append=T )
    }
    
    lod <- NULL
    for( i in 1:n.traits ) 
    {
        qtl.p <- NULL
        for( j in 1:n.marker ) 
        {
            z                   <-  traits[i,]
            z[traits[i,]<=spike] <-  0
            z[traits[i,]>spike]  <-  1
            za                  <-  z[which(genotypes[j,]==1)]
            zb                  <-  z[which(genotypes[j,]==2)]
            p1                  <-  wilcox.test(za, zb)$p.value
            if( is.na(p1) ) 
            {
                p1  <-  1
            }
            if( p1 == 0 ) 
            {   ## due to the problem of wilcox.test, when p<2.2e-16, p=0
                p1 <- 2.2e-16  
            }
            if( length( which(za==1) ) / length(za) > 
                length( which(zb==1) ) / length(zb) ) 
            { 
                sign.p1 <- -1 
            } 
            else 
            {
                sign.p1 <- 1
            }                                     
            
            y           <-  traits[i,][traits[i,]>spike]
            y.genotypes <-  genotypes[j,][traits[i,]>spike]
            y.temp      <-  unique(y.genotypes)
           
            
            if( length( y.temp[ ! is.na(y.temp) ] ) > 1 ) #there is missing data
            {
                model   <-  lm( y~y.genotypes )
                p2      <-  anova( model )[[5]][1]
            } 
            else 
            {
                p2  <-  1
            }
            if( is.na(p2) ) 
            {
                p2  <-  1
            }
            
            if( model$coefficients[2] < 0 ) 
            { 
                sign.p2 <- -1 
            } 
            else 
            {
                sign.p2 <- 1
            }
            if( mean(traits[i,genotypes[j,]==1], na.rm=T ) > 
                mean(traits[i,genotypes[j,]==2], na.rm=T ) ) 
            {
                qtl.p   <-  c( qtl.p, log10(p1*p2) )
            } 
            else 
            {
                qtl.p   <-  c( qtl.p, -1*log10(p1*p2) )
            }
            #qtl.p<-c(qtl.p, -log10(p1)*sign.p1-log10(p2)*sign.p2)
        }
        if( ! is.null(filename) ) 
        {
            cat( name.traits[i], qtl.p, file=filename, sep=sep, append=T )
            cat( "\n", file=filename, sep="", append=T )
        }
        lod <-  rbind( lod, qtl.p )
    }
    dimnames( lod ) <-  list( name.traits, name.marker )
    lod
}
