# Package: MetaNetwork. A computational tool for genetic study of metabolism
# Function name: FDR
# Author: Jingyuan Fu <j.fu@rug.nl>
# Version: 1.0 
# Date: 6 Nov. 2006

library( qvalue )
                      
qtlFDR <- function( qtlProfiles, fdrThres=0.05, qtlThres=NULL ) 
{
    #transform into pvalues that can be accepted by qvalue
    pValues  <- -1 * as.vector( abs(qtlProfiles) ) 
    pValues  <- 10^pValues 
    pValues  <- as.vector( pValues ) 
    pThres   <- 10^(-1*qtlThres)
    
    qValues  <- qvalue( pValues )
    
    result   <-  NULL
    if( ! is.null( fdrThres ) ) 
    {
        pThres.thres <- 
            max( qValues$pvalue[ qValues$qvalue < fdrThres ] )
        result  <- rbind( result, 
                       c( fdrThres, pThres.thres, -1*log10( pThres.thres )) )
    }              
    if ( ! is.null( pThres ) ) 
    {
        maxQValue  <-  
            max( qValues$qvalue[ qValues$pvalue < pThres ] )
        result  <- rbind( result, 
                       c(maxQValue, pThres, -1*log10(pThres)) )
    }
    colnames( result ) <- c( "qValue(fdr)", "pValue", "-log10P(qtlThres)" )
    result
}
