# Package: MetaNetwork. A computational tool for genetic study of metabolism
# Function name: qtlCorrSecondOrder
# Author: Jingyuan Fu <j.fu@rug.nl>
# Version: 1.0 
# Date: 6 Nov. 2006
                      
qtlCorrSecondOrder <- function( corrZeroOrder, topCorNo=20, filename=NULL ) 
{       
    if( ! is.null( filename ) ) 
    {
        cat( "", rownames(corrZeroOrder), file=filename, append=F, sep="," )
        cat( "\n", file=filename, append=T )
    }
    
    secondCor <- matrix( 0, nrow=nrow(corrZeroOrder), ncol=ncol(corrZeroOrder) )
    dimNo     <- nrow(corrZeroOrder)
    n         <- 1:dimNo
    
    for( i in 2:nrow(corrZeroOrder) ) 
    {
        for( j in 1:(i-1) ) 
        {
            rxy <- 1
            if ( dimNo > topCorNo ) 
            {
                avgCor <- apply( abs(corrZeroOrder[c(i,j),]), 2, mean )
                n      <- order( avgCor, decreasing=T )[1:topCorNo]        
            }
            m <- 0
            
            for( x in 2:length(n) ) 
            {
                k <- n[x]
                for( y in 1:(x-1) ) 
                {
                    p <- n[y]
                    m <- m + 1
                    if( ! is.element(k, c(i, j)) & ! is.element(p, c(i, j)) 
                        & corrZeroOrder[i,k] != 1 & corrZeroOrder[j,k] != 1 
                        & corrZeroOrder[p,k] != 1 ) 
                    {
                        rxyk <- ( corrZeroOrder[i,j] - corrZeroOrder[i, k] * corrZeroOrder[j, k]) /
                                sqrt((1-corrZeroOrder[i, k]^2)*(1-corrZeroOrder[j,k]^2))
                        rxpk <- ( corrZeroOrder[i, p]-corrZeroOrder[i,k]*corrZeroOrder[p,k]) /
                                sqrt((1-corrZeroOrder[i, k]^2)*(1-corrZeroOrder[p,k]^2))
                        rypk <- ( corrZeroOrder[j,p] -corrZeroOrder[j,k]*corrZeroOrder[p,k]) /
                                sqrt((1-corrZeroOrder[j,k]^2)*(1-corrZeroOrder[p,k]^2))
                        if( abs(rxyk) < 1 & abs(rxpk)<1 & abs(rypk) < 1 ) 
                        {
                            rxykp <- (rxyk-rxpk*rypk) / 
                                        sqrt( (1-rxpk^2)*(1-rypk^2) )
                            if( abs(rxy) > abs(rxykp) ) 
                            {
                                rxy <- rxykp
                            }
                        }
                    }
                }
            }
            secondCor[i,j] <- secondCor[j,i] <- rxy
        }  
    }
    
    #set names
    dimnames( secondCor ) <- dimnames( corrZeroOrder )
    if( ! is.null( filename ) )
    {
        for( i in 1:nrow( secondCor ) )
        {
            cat( rownames(secondCor)[i], secondCor[i,], file=filename,
                 append=T, sep="," )
            cat( "\n", file=filename, append=T )
        }
    }
    
    #return
    secondCor 
}
