# Package: MetaNetwork. A computational tool for genetic study of metabolism
# Function name: qtlCorrFindMultiplePeaks
# Author: Jingyuan Fu <j.fu@rug.nl>
# Version: 1.0 
# Date: 7 Jan. 2006

findMultiplePeaks <- function( corrZeroOrder, peaks, corrThres=0.95, filename=NULL) 
{
    # clustering helper function
    grouping <- function( pairPeaks, starts )
    {
        anyLink <- NULL
        for( i in 1:nrow(pairPeaks) )
        { 
            anyLink <- c( anyLink, any(is.element(pairPeaks[i,], starts)) )
        }
        #return
        anyLink
    }
    
    # find relationships
    isotope       <- c( 1, 2 )
    diffCharged   <- c( 0.33, 0.5, 2, 3 )
    multiplePeaks <- NULL
    name          <- rownames(corrZeroOrder)
    
    for( i in 2:nrow(corrZeroOrder) ) 
    {
        for( j in 1:(i-1) ) 
        {
            m1           <- peaks[which(rownames(peaks)==name[i]),1]
            m2           <- peaks[which(rownames(peaks)==name[j]),1]
            massRatio    <- round( m1/m2, digit=2 )
            massDiff     <- m1-m2
            relationship <- ""
            
            if( corrZeroOrder[i,j] > corrThres ) 
            {
                if( is.element(massRatio, diffCharged) )
                { 
                    relationship<-"diffCharged"
                }
                if( is.element( abs(massDiff), isotope) ) 
                {
                    relationship<-"isotope"
                }
                if( relationship != "" ) 
                {
                    multiplePeaks <- rbind(multiplePeaks, data.frame(
                                    peak1        = name[i], 
                                    mass_charge1 = m1, 
                                    peak2        = name[j],                                     
                                    mass_charge2 = m2, 
                                    corrCoef     = corrZeroOrder[i,j],
                                    massDiff     = massDiff, 
                                    massRatio    = massRatio, 
                                    relationship = relationship))
                }
            }
        }
    }
       
    pairPeaks <- as.matrix(multiplePeaks[,1:2])
    clusterNo <- rep(0, nrow(pairPeaks))
    j         <- 0
    
    #put related peaks in clusters (clusterNo == 0 means unclustered)
    while( any(clusterNo==0) ) 
    {
        j          <- j+1
        n          <- which(clusterNo==0)[1]
        tempMember <- pairPeaks[n, 1:2]
        anyLink    <- grouping( pairPeaks, tempMember ) #helper function
        m          <- which(anyLink)
        
        while( length(m)>length(n) )
        {
            tempMember <- unique( as.vector(pairPeaks[m,]) )
            n          <- m
            anyLink    <- grouping( pairPeaks, tempMember )
            m          <- which(anyLink)
        }
        clusterNo[n] <- j
    }
    multiplePeaks <- cbind( cluster=clusterNo, multiplePeaks )
    multiplePeaks <- multiplePeaks[order(multiplePeaks[,1]),]
    
    #write peaks to filename
    if( !is.null(filename) ) 
    {
        write.table( multiplePeaks, file=filename,sep=",", row.names=F )
    }
    
    #return
    multiplePeaks
}   
