# Package: MetaNetwork. A computational tool for genetic study of metabolism
# Function name: createCytoFiles 
# Author: Jingyuan Fu <j.fu@rug.nl>
# Version: 1.0 
# Date: 6 Nov. 2006

createCytoFiles <- function( corrMatrix, filename, simThres, hideNodes=T) 
{
    #option generalize this function using arguments below
    disThres <- NULL
    relationship <- "cc"
    name <- rownames( corrMatrix )
    if( is.null( name ) ) 
    {
        name    <-  paste( "node", 1:nrow(corrMatrix), sep="" )
    }
    
    sif.file    <-  paste( filename, ".sif", sep="" )
    eda.file    <-  paste( filename, ".eda", sep="" )
    if( is.null(simThres) & is.null(disThres) ) 
    { 
        #stop( "no similarityThreshold/distanceThreshold for network edges" )
        stop( "no similarityThreshold for network edges" )
    }
    cat( "", file=sif.file )
    cat( "InteractionStrength", "\n", sep="", file=eda.file )
    for( i in 2:nrow(corrMatrix) ) 
    {
        for( j in 1:(i-1) ) 
        {
            if( ! is.null(simThres) ) 
            {
                if( abs( corrMatrix[i,j] ) > simThres ) 
                {
                    cat( name[i], relationship, name[j], "\n", sep=" ", 
                         file=sif.file, append=T )
                    cat( name[i], paste( "(", relationship, ")", sep="" ), 
                         name[j], "=", corrMatrix[i,j], "\n", sep=" ", 
                         file=eda.file, append=T )
                } 
                else if( hideNodes == F ) 
                {
                    cat( name[i], "\n", sep=" ", file=sif.file, append=T )
                }
            } 
            else if( !is.null(disThres) ) 
            {
                if( abs(corrMatrix[i,j]) < disThres ) 
                {
                    cat( name[i], relationship, name[j], "\n", sep=" ", 
                         file=sif.file, append=T )
                    cat( name[i], paste( "(", relationship, ")", sep="" ), 
                         name[j], "=", corrMatrix[i,j], " ", sep="\t", 
                         file=eda.file, append=T )
                } 
                else if( hideNodes == F ) 
                {
                    cat( name[i], "\n", sep=" ", file=sif.file, append=T )
                }
            }
        }
    }           
}
