const CC = Components.classes;
const CI = Components.interfaces;

function log(message, opt_toConsole) {
  message = '[readyStateExtension] ' + message;
  if (!!opt_toConsole) {
    CC['@mozilla.org/consoleservice;1'].
        getService(CI['nsIConsoleService']).
        logStringMessage(message);
  }
  window.dump(message + '\n');
}

var ReadyState = {
  onLoad: function() {
    this.initialized = true;
    var appcontent = document.getElementById("appcontent");   // browser
    appcontent.addEventListener("load", this.onPageLoad, true);
  },

  onPageLoad: function(aEvent, repeat) {
    try {
      var xdoc = aEvent.originalTarget; // doc is document that triggered "onload" event
      var doc = xdoc.wrappedJSObject;
      if (doc == null) doc = xdoc;

      log('doc loaded: ' + doc.location.href);

      doc.defaultView.setTimeout(function() {
        log('after load');
        doc.readyState = 'complete';
      }, 0);

    } catch (e) {
      log(e);
    }
  },
};


try {
  var appinfo = CC['@mozilla.org/xre/app-info;1'].
      getService(CI['nsIXULAppInfo']);

  var versionchecker = CC['@mozilla.org/xpcom/version-comparator;1'].
      getService(CI['nsIVersionComparator']);

  if (versionchecker.compare(appinfo.version, '3.6') < 0) {
    log('Running ' + appinfo.version + '; Installing readyState patch');
    window.addEventListener('load', function(e) {
      ReadyState.onLoad(e);
    }, false);
  }
} catch (ex) {
  // We could use Components.utils.reportError, but that wouldn't show up in the
  // error console unless javascript.options.showInConsole was set to true,
  // which would be no use if a SeleniumRC test starts failing explicitly
  // because of this (again).
  log(ex);
}
