<#setting number_format="#"/>
<#include "GeneratorHelper.ftl">
<#include "MysqlHelper.ftl">
<#--#####################################################################
One table per concrete class
One table per inheritance root.
If the root is not abstract, a extra table is added called IName...with
as only column(s) the primary key of IName.

Note:
There are two alternative strategies: "one table per class" and "one table per hierarchy".
advantage of this strategy:
* easy to understand (than table per hierarchy)
* easy to query (than table per class).
* easier to query subclasses
* good performance as not as many joins/updates needed as in "table per class" (max 2)
* easier to define tuple/table constraints over properties of class AND subclass
drawback of this strategy:
* more difficult change classes ("add/change/remove property" affects many tables).
* foreign keys cannot distinguish between classes (as they can in  "table per class").
* bit harder to query a class and its subclasses (than one table per hierarchy).
#####################################################################-->
##Created by: CreateTableGen.class_per_table.mysql.ftl
##Date: ${date}
<#--#####################################################################-->
<#--                                                                   ##-->
<#--         START OF THE OUTPUT                                       ##-->
<#--                                                                   ##-->
<#--#####################################################################-->
###############DROP TABLES#################
<#list entities?reverse as entity>
<#-- Generate a table for each concrete class (so, not abstract) -->
<#if !entity.isAbstract()>
##${name(entity)}<#if entity.hasAncestor()> extends ${name(entity.getAncestor())}</#if><#if entity.hasImplements()> implements <#list entity.getImplements() as i>${name(i)}<#if i_has_next>,</#if></#list></#if>
DROP TABLE IF EXISTS ${SqlName(entity)};
</#if>
</#list>

###############CREATE TABLES###############
<#--entities is a sorted list of entities, based on xref dependencies-->
<#list entities as entity>
<#-- Generate a table for each concrete class (so, not abstract) -->
<#if !entity.isAbstract()>
##${name(entity)}<#if entity.hasAncestor()> extends ${name(entity.getAncestor())}</#if><#if entity.hasImplements()> implements <#list entity.getImplements() as i>${name(i)}<#if i_has_next>,</#if></#list></#if>
CREATE TABLE ${SqlName(entity)} (
<#list dbFields(entity) as f>
	<#if f_index != 0>, </#if><@compress single_line=true>
	${SqlName(f)} ${mysql_type(model,f)}
	<#if !f.nillable> NOT </#if>NULL
	<#if f.getDefaultValue()?exists && f.getDefaultValue() != "" && f.type != "text" && f.type != "blob" && f.type != "hyperlink"> DEFAULT <#if f.type == "bool" || f.type == "int">${f.getDefaultValue()}<#else>"${f.getDefaultValue()}"</#if></#if>
	<#if f.auto && f.type == "int"> AUTO_INCREMENT</#if></@compress>
<#if f.type == "xref">
	, FOREIGN KEY (${SqlName(f)}) REFERENCES ${SqlName(model.getEntity(f.XRefEntity).getRootAncestor() )} (${SqlName(f.XRefField)}) ON DELETE RESTRICT
</#if>
<#if f.auto && f.type == "int" && entity.hasAncestor()>
	##id generated by root class table '${name(entity.getRootAncestor())}' using trigger '${name(entity)}_inserttrigger'
</#if>
</#list>
<#list entity.getAllKeys() as key>
<#if key_index == 0>
	, PRIMARY KEY(${csv(key.fields)})
<#else>
	, UNIQUE(${csv(key.fields)})
</#if>
</#list>
<#list entity.getAllIndices() as i>
	, INDEX ${SqlName(i)} (${csv(i.fields)})
</#list>
) ENGINE=InnoDB;
<#--need innodb to support transactions. Do not change! If you need MyISAM, we can make this an generator option-->
<#--http://www.mysql.org/doc/refman/5.1/en/multiple-tablespaces.html for one file per table innodb-->
</#if>
</#list>

############CREATE TRIGGERS######
DELIMITER |
<#list entities as entity>
<#-- add trigger for automatic id in subclassess-->
	<#if entity.hasAncestor()>
	<#assign interface_table = SqlName(entity.getRootAncestor() )>
	<#assign autoid_colum = SqlName( entity.getAllKeys()?first.fields?first.name )>
	<#assign type_colum = typefield() >
## table ${name(entity)}  uses AUTO_INCREMENT from ${interface_table}.${autoid_colum}
DROP TRIGGER IF EXISTS ${SqlName(entity)}_inserttrigger|
CREATE TRIGGER ${SqlName(entity)}_inserttrigger BEFORE INSERT ON ${SqlName(entity)}
FOR EACH ROW
BEGIN
   DECLARE my_last_id INT;
   INSERT INTO ${interface_table} (${type_colum}) values ('${SqlName(entity)}');
   SELECT MAX(${autoid_colum}) INTO my_last_id FROM _iteminterface;
   SET NEW.${autoid_colum} = my_last_id;
END|

DROP TRIGGER IF EXISTS ${SqlName(entity)}_deletetrigger|
CREATE TRIGGER ${SqlName(entity)}_deletetrigger AFTER DELETE ON ${SqlName(entity)}
FOR EACH ROW
BEGIN
   DELETE FROM ${interface_table} WHERE ${autoid_colum} = OLD.${autoid_colum};
END|
## end trigger

	</#if>
</#list>
DELIMITER ; 

###############CREATE VIEWS###############
<#list entities as entity>
	<#if  !entity.isAbstract()>
DROP VIEW IF EXISTS view_${SqlName(entity)}s;
CREATE VIEW view_${SqlName(entity)}s AS SELECT * FROM ${SqlName(entity)};	
	</#if>
</#list>
