	DROP TABLE MolgenisRole IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisRole (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, __Type VARCHAR(1024) NOT NULL	
		, name VARCHAR(255) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE MolgenisGroup IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisGroup (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Institute IF EXISTS CASCADE;
	CREATE CACHED TABLE Institute (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Address VARCHAR(1024)	
		, Phone VARCHAR(255)	
		, Email VARCHAR(255)	
		, Fax VARCHAR(255)	
		, tollFreePhone VARCHAR(255)	
		, City VARCHAR(255)	
		, Country VARCHAR(255)	
		, name VARCHAR(255) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE Ontology IF EXISTS CASCADE;
	CREATE CACHED TABLE Ontology (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, ontologyAccession VARCHAR(255)	
		, ontologyURI VARCHAR(256)	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE PersonRole IF EXISTS CASCADE;
	CREATE CACHED TABLE PersonRole (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Person IF EXISTS CASCADE;
	CREATE CACHED TABLE Person (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Address VARCHAR(1024)	
		, Phone VARCHAR(255)	
		, Email VARCHAR(255)	
		, Fax VARCHAR(255)	
		, tollFreePhone VARCHAR(255)	
		, City VARCHAR(255)	
		, Country VARCHAR(255)	
		, FirstName VARCHAR(255)	
		, MidInitials VARCHAR(255)	
		, LastName VARCHAR(255)	
		, Title VARCHAR(255)	
		, Affiliation INT	
		, Department VARCHAR(255)	
		, Roles INT	
		, PRIMARY KEY(id)
		, UNIQUE(FirstName,MidInitials,LastName)
	);
	DROP TABLE MolgenisUser IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisUser (
		password_ VARCHAR(255) DEFAULT 'secret' NOT NULL	
		, activationCode VARCHAR(255)	
		, active INTEGER DEFAULT false NOT NULL	
		, superuser INTEGER DEFAULT false NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE MolgenisRoleGroupLink IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisRoleGroupLink (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, group_ INT NOT NULL	
		, role_ INT NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(group_,role_)
	);
	DROP TABLE OntologyTerm IF EXISTS CASCADE;
	CREATE CACHED TABLE OntologyTerm (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, __Type VARCHAR(1024) NOT NULL	
		, ontology INT	
		, termAccession VARCHAR(255)	
		, definition VARCHAR(255)	
		, termPath VARCHAR(1024)	
		, PRIMARY KEY(id)
		, UNIQUE(ontology,termAccession)
		, UNIQUE(ontology,name)
	);
	DROP TABLE MolgenisFile IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisFile (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, __Type VARCHAR(1024) NOT NULL	
		, Extension VARCHAR(8) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE RuntimeProperty IF EXISTS CASCADE;
	CREATE CACHED TABLE RuntimeProperty (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, Value VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE UseCase IF EXISTS CASCADE;
	CREATE CACHED TABLE UseCase (
		UseCaseId INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, UseCaseName VARCHAR(255) NOT NULL	
		, SearchType VARCHAR(255) NOT NULL	
		, PRIMARY KEY(UseCaseId)
		, UNIQUE(UseCaseName)
	);
	DROP TABLE MolgenisEntity IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisEntity (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(255) NOT NULL	
		, type_ VARCHAR(255) NOT NULL	
		, className VARCHAR(255) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(className)
		, UNIQUE(name,type_)
	);
	DROP TABLE MolgenisPermission IF EXISTS CASCADE;
	CREATE CACHED TABLE MolgenisPermission (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, role_ INT NOT NULL	
		, entity INT NOT NULL	
		, permission VARCHAR(1024) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(role_,entity,permission)
	);
	DROP TABLE Investigation IF EXISTS CASCADE;
	CREATE CACHED TABLE Investigation (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, description VARCHAR(1024)	
		, startDate DATETIME	
		, endDate DATETIME	
		, accession VARCHAR(256)	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE Species IF EXISTS CASCADE;
	CREATE CACHED TABLE Species (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE AlternateId IF EXISTS CASCADE;
	CREATE CACHED TABLE AlternateId (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE ObservationElement IF EXISTS CASCADE;
	CREATE CACHED TABLE ObservationElement (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, description VARCHAR(1024)	
		, Investigation INT	
		, __Type VARCHAR(1024) NOT NULL	
		, label VARCHAR(255)	
		, PRIMARY KEY(id)
		, UNIQUE(name,Investigation)
		, UNIQUE(name)
	);
	DROP TABLE ObservationTarget IF EXISTS CASCADE;
	CREATE CACHED TABLE ObservationTarget (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE ObservableFeature IF EXISTS CASCADE;
	CREATE CACHED TABLE ObservableFeature (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Category IF EXISTS CASCADE;
	CREATE CACHED TABLE Category (
		code_string VARCHAR(255) NOT NULL	
		, description VARCHAR(1024) NOT NULL	
		, isMissing INTEGER DEFAULT false NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Individual IF EXISTS CASCADE;
	CREATE CACHED TABLE Individual (
		Mother INT	
		, Father INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Location IF EXISTS CASCADE;
	CREATE CACHED TABLE Location (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Chromosome IF EXISTS CASCADE;
	CREATE CACHED TABLE Chromosome (
		orderNr INT NOT NULL	
		, isAutosomal INTEGER NOT NULL	
		, bpLength INT	
		, Species INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE NMRBin IF EXISTS CASCADE;
	CREATE CACHED TABLE NMRBin (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Clone IF EXISTS CASCADE;
	CREATE CACHED TABLE Clone (
		Chromosome INT	
		, cM DOUBLE	
		, bpStart BIGINT	
		, bpEnd BIGINT	
		, Seq VARCHAR(1024)	
		, Symbol VARCHAR(255)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE DerivedTrait IF EXISTS CASCADE;
	CREATE CACHED TABLE DerivedTrait (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE EnvironmentalFactor IF EXISTS CASCADE;
	CREATE CACHED TABLE EnvironmentalFactor (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Gene IF EXISTS CASCADE;
	CREATE CACHED TABLE Gene (
		Chromosome INT	
		, cM DOUBLE	
		, bpStart BIGINT	
		, bpEnd BIGINT	
		, Seq VARCHAR(1024)	
		, Symbol VARCHAR(255)	
		, Orientation VARCHAR(1024)	
		, Control INTEGER	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Transcript IF EXISTS CASCADE;
	CREATE CACHED TABLE Transcript (
		Gene INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Protein IF EXISTS CASCADE;
	CREATE CACHED TABLE Protein (
		Gene INT	
		, Transcript INT	
		, AminoSequence VARCHAR(1024)	
		, Mass DOUBLE	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Metabolite IF EXISTS CASCADE;
	CREATE CACHED TABLE Metabolite (
		Formula VARCHAR(128)	
		, Mass DOUBLE	
		, Structure VARCHAR(1024)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Marker IF EXISTS CASCADE;
	CREATE CACHED TABLE Marker (
		Chromosome INT	
		, cM DOUBLE	
		, bpStart BIGINT	
		, bpEnd BIGINT	
		, Seq VARCHAR(1024)	
		, Symbol VARCHAR(255)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Polymorphism IF EXISTS CASCADE;
	CREATE CACHED TABLE Polymorphism (
		Base VARCHAR(1024) NOT NULL	
		, Value VARCHAR(255)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE SNP IF EXISTS CASCADE;
	CREATE CACHED TABLE SNP (
		Status VARCHAR(255)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE ProbeSet IF EXISTS CASCADE;
	CREATE CACHED TABLE ProbeSet (
		Chromosome INT	
		, cM DOUBLE	
		, bpStart BIGINT	
		, bpEnd BIGINT	
		, Seq VARCHAR(1024)	
		, Symbol VARCHAR(255)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Probe IF EXISTS CASCADE;
	CREATE CACHED TABLE Probe (
		Chromosome INT	
		, cM DOUBLE	
		, bpStart BIGINT	
		, bpEnd BIGINT	
		, Seq VARCHAR(1024)	
		, Symbol VARCHAR(255)	
		, Mismatch INTEGER DEFAULT false NOT NULL	
		, ProbeSet INT	
		, ReportsFor INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Spot IF EXISTS CASCADE;
	CREATE CACHED TABLE Spot (
		x INT NOT NULL	
		, y INT NOT NULL	
		, GridX INT	
		, GridY INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(x,y,GridX,GridY)
	);
	DROP TABLE MassPeak IF EXISTS CASCADE;
	CREATE CACHED TABLE MassPeak (
		MZ DOUBLE	
		, RetentionTime DOUBLE	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE InvestigationFile IF EXISTS CASCADE;
	CREATE CACHED TABLE InvestigationFile (
		description VARCHAR(1024)	
		, Investigation INT NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Tissue IF EXISTS CASCADE;
	CREATE CACHED TABLE Tissue (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE SampleLabel IF EXISTS CASCADE;
	CREATE CACHED TABLE SampleLabel (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Publication IF EXISTS CASCADE;
	CREATE CACHED TABLE Publication (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, PubmedID INT	
		, DOI INT	
		, authorList VARCHAR(1024)	
		, Title VARCHAR(255) NOT NULL	
		, Status INT	
		, Year VARCHAR(255)	
		, Journal VARCHAR(255)	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE DataFile IF EXISTS CASCADE;
	CREATE CACHED TABLE DataFile (
		uri VARCHAR(255) NOT NULL	
		, format INT NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Measurement IF EXISTS CASCADE;
	CREATE CACHED TABLE Measurement (
		unit INT	
		, dataType VARCHAR(1024) DEFAULT 'string' NOT NULL	
		, temporal INTEGER DEFAULT false NOT NULL	
		, description VARCHAR(1024)	
		, targettypeAllowedForRelation INT	
		, panelLabelAllowedForRelation VARCHAR(255)	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Panel IF EXISTS CASCADE;
	CREATE CACHED TABLE Panel (
		Species INT	
		, PanelType INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Protocol IF EXISTS CASCADE;
	CREATE CACHED TABLE Protocol (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, description VARCHAR	
		, Investigation INT	
		, __Type VARCHAR(1024) NOT NULL	
		, ProtocolType INT	
		, TargetFilter VARCHAR(255)	
		, Contact INT	
		, PRIMARY KEY(id)
		, UNIQUE(name,Investigation)
	);
	DROP TABLE Workflow IF EXISTS CASCADE;
	CREATE CACHED TABLE Workflow (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE Data IF EXISTS CASCADE;
	CREATE CACHED TABLE Data (
		FeatureType VARCHAR(1024) NOT NULL	
		, TargetType VARCHAR(1024) NOT NULL	
		, ValueType VARCHAR(1024) NOT NULL	
		, Storage VARCHAR(1024) DEFAULT 'Binary' NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE BinaryDataMatrix IF EXISTS CASCADE;
	CREATE CACHED TABLE BinaryDataMatrix (
		Data INT NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE CSVDataMatrix IF EXISTS CASCADE;
	CREATE CACHED TABLE CSVDataMatrix (
		Data INT NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE OriginalFile IF EXISTS CASCADE;
	CREATE CACHED TABLE OriginalFile (
		Data INT NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE ProtocolApplication IF EXISTS CASCADE;
	CREATE CACHED TABLE ProtocolApplication (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, description VARCHAR(1024)	
		, Investigation INT	
		, __Type VARCHAR(1024) NOT NULL	
		, time DATETIME NOT NULL	
		, protocol INT	
		, PRIMARY KEY(id)
		, UNIQUE(name,Investigation)
	);
	DROP TABLE ProtocolDocument IF EXISTS CASCADE;
	CREATE CACHED TABLE ProtocolDocument (
		protocol INT NOT NULL	
		, document VARCHAR(1024) NOT NULL	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE WorkflowElement IF EXISTS CASCADE;
	CREATE CACHED TABLE WorkflowElement (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, Workflow INT NOT NULL	
		, protocol INT NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE WorkflowElementParameter IF EXISTS CASCADE;
	CREATE CACHED TABLE WorkflowElementParameter (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, WorkflowElement INT NOT NULL	
		, Parameter INT NOT NULL	
		, Value VARCHAR(255) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(WorkflowElement,Parameter)
	);
	DROP TABLE Sample IF EXISTS CASCADE;
	CREATE CACHED TABLE Sample (
		Individual INT	
		, Tissue INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE PairedSample IF EXISTS CASCADE;
	CREATE CACHED TABLE PairedSample (
		Subject1 INT NOT NULL	
		, Label1 INT	
		, Subject2 INT NOT NULL	
		, Label2 INT	
		, id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE DecimalDataElement IF EXISTS CASCADE;
	CREATE CACHED TABLE DecimalDataElement (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Investigation INT	
		, protocolApplication INT	
		, Feature INT NOT NULL	
		, Target INT NOT NULL	
		, Data INT NOT NULL	
		, FeatureIndex INT NOT NULL	
		, TargetIndex INT NOT NULL	
		, Value DOUBLE	
		, PRIMARY KEY(id)
		, UNIQUE(FeatureIndex,TargetIndex,Data)
	);
	DROP TABLE TextDataElement IF EXISTS CASCADE;
	CREATE CACHED TABLE TextDataElement (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Investigation INT	
		, protocolApplication INT	
		, Feature INT NOT NULL	
		, Target INT NOT NULL	
		, Data INT NOT NULL	
		, FeatureIndex INT NOT NULL	
		, TargetIndex INT NOT NULL	
		, Value VARCHAR(127)	
		, PRIMARY KEY(id)
		, UNIQUE(FeatureIndex,TargetIndex,Data)
	);
	DROP TABLE ObservedValue IF EXISTS CASCADE;
	CREATE CACHED TABLE ObservedValue (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Investigation INT	
		, protocolApplication INT	
		, Feature INT NOT NULL	
		, Target INT NOT NULL	
		, ontologyReference INT	
		, value VARCHAR(255)	
		, relation INT	
		, time DATETIME	
		, endtime DATETIME	
		, PRIMARY KEY(id)
	);
	DROP TABLE ParameterSet IF EXISTS CASCADE;
	CREATE CACHED TABLE ParameterSet (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE ParameterName IF EXISTS CASCADE;
	CREATE CACHED TABLE ParameterName (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, ParameterSet INT NOT NULL	
		, Description VARCHAR(1024)	
		, PRIMARY KEY(id)
		, UNIQUE(name,ParameterSet)
	);
	DROP TABLE ParameterValue IF EXISTS CASCADE;
	CREATE CACHED TABLE ParameterValue (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, ParameterName INT NOT NULL	
		, Value VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name,ParameterName)
	);
	DROP TABLE DataSet IF EXISTS CASCADE;
	CREATE CACHED TABLE DataSet (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE Analysis IF EXISTS CASCADE;
	CREATE CACHED TABLE Analysis (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, Description VARCHAR(1024)	
		, ParameterSet INT NOT NULL	
		, DataSet INT NOT NULL	
		, TargetFunctionName VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name)
	);
	DROP TABLE Job IF EXISTS CASCADE;
	CREATE CACHED TABLE Job (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, OutputDataName VARCHAR(127) NOT NULL	
		, Timestamp VARCHAR(255) NOT NULL	
		, Analysis INT NOT NULL	
		, ComputeResource VARCHAR(1024) DEFAULT 'local' NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(OutputDataName)
	);
	DROP TABLE Subjob IF EXISTS CASCADE;
	CREATE CACHED TABLE Subjob (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Job INT NOT NULL	
		, StatusCode INT NOT NULL	
		, StatusText VARCHAR(127) NOT NULL	
		, StatusProgress INT	
		, Nr INT NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE DataName IF EXISTS CASCADE;
	CREATE CACHED TABLE DataName (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, DataSet INT NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name,DataSet)
	);
	DROP TABLE DataValue IF EXISTS CASCADE;
	CREATE CACHED TABLE DataValue (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, name VARCHAR(127) NOT NULL	
		, DataName INT NOT NULL	
		, Value INT NOT NULL	
		, PRIMARY KEY(id)
		, UNIQUE(name,DataName)
	);
	DROP TABLE SelectedParameter IF EXISTS CASCADE;
	CREATE CACHED TABLE SelectedParameter (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Job INT NOT NULL	
		, ParameterName VARCHAR(127) NOT NULL	
		, ParameterValue VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE SelectedData IF EXISTS CASCADE;
	CREATE CACHED TABLE SelectedData (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Job INT NOT NULL	
		, DataName VARCHAR(127) NOT NULL	
		, DataValue VARCHAR(127) NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE RScript IF EXISTS CASCADE;
	CREATE CACHED TABLE RScript (
		id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PRIMARY KEY(id)
	);
	DROP TABLE Investigation_contacts IF EXISTS CASCADE;
	CREATE CACHED TABLE Investigation_contacts (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, contacts INT NOT NULL	
		, Investigation INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(contacts,Investigation)
	);
	DROP TABLE ObservationElement_ontolo12449 IF EXISTS CASCADE;
	CREATE CACHED TABLE ObservationElement_ontolo12449 (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, ontologyReference INT NOT NULL	
		, InvestigationElement INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(ontologyReference,InvestigationElement)
	);
	DROP TABLE ObservationElement_AlternateId IF EXISTS CASCADE;
	CREATE CACHED TABLE ObservationElement_AlternateId (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, AlternateId INT NOT NULL	
		, ObservationElement INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(AlternateId,ObservationElement)
	);
	DROP TABLE Measurement_categories IF EXISTS CASCADE;
	CREATE CACHED TABLE Measurement_categories (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, categories INT NOT NULL	
		, Measurement INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(categories,Measurement)
	);
	DROP TABLE Panel_Individuals IF EXISTS CASCADE;
	CREATE CACHED TABLE Panel_Individuals (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Individuals INT NOT NULL	
		, Panel INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(Individuals,Panel)
	);
	DROP TABLE Panel_FounderPanels IF EXISTS CASCADE;
	CREATE CACHED TABLE Panel_FounderPanels (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, FounderPanels INT NOT NULL	
		, Panel INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(FounderPanels,Panel)
	);
	DROP TABLE Protocol_ontologyReference IF EXISTS CASCADE;
	CREATE CACHED TABLE Protocol_ontologyReference (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, ontologyReference INT NOT NULL	
		, InvestigationElement INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(ontologyReference,InvestigationElement)
	);
	DROP TABLE Protocol_Features IF EXISTS CASCADE;
	CREATE CACHED TABLE Protocol_Features (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Features INT NOT NULL	
		, Protocol INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(Features,Protocol)
	);
	DROP TABLE Protocol_subprotocols IF EXISTS CASCADE;
	CREATE CACHED TABLE Protocol_subprotocols (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, subprotocols INT NOT NULL	
		, Protocol INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(subprotocols,Protocol)
	);
	DROP TABLE ProtocolApplication_ontol11768 IF EXISTS CASCADE;
	CREATE CACHED TABLE ProtocolApplication_ontol11768 (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, ontologyReference INT NOT NULL	
		, InvestigationElement INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(ontologyReference,InvestigationElement)
	);
	DROP TABLE ProtocolApplication_Performer IF EXISTS CASCADE;
	CREATE CACHED TABLE ProtocolApplication_Performer (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Performer INT NOT NULL	
		, ProtocolApplication INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(Performer,ProtocolApplication)
	);
	DROP TABLE WorkflowElement_PreviousSteps IF EXISTS CASCADE;
	CREATE CACHED TABLE WorkflowElement_PreviousSteps (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, PreviousSteps INT NOT NULL	
		, WorkflowElement INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(PreviousSteps,WorkflowElement)
	);
	DROP TABLE Marker_ReportsFor IF EXISTS CASCADE;
	CREATE CACHED TABLE Marker_ReportsFor (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, ReportsFor INT NOT NULL	
		, Marker INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(ReportsFor,Marker)
	);
	DROP TABLE SNP_Polymorphism IF EXISTS CASCADE;
	CREATE CACHED TABLE SNP_Polymorphism (
		autoid INT GENERATED BY DEFAULT AS IDENTITY NOT NULL	
		, Polymorphism INT NOT NULL	
		, SNP INT NOT NULL	
		, PRIMARY KEY(autoid)
		, UNIQUE(Polymorphism,SNP)
	);
		ALTER TABLE MolgenisGroup ADD FOREIGN KEY (id) REFERENCES MolgenisRole (id) ON DELETE CASCADE;
		ALTER TABLE PersonRole ADD FOREIGN KEY (id) REFERENCES OntologyTerm (id) ON DELETE CASCADE;
		ALTER TABLE Person ADD FOREIGN KEY (Affiliation) REFERENCES Institute (id) ON DELETE RESTRICT;
		ALTER TABLE Person ADD FOREIGN KEY (Roles) REFERENCES PersonRole (id) ON DELETE RESTRICT;
		ALTER TABLE Person ADD FOREIGN KEY (id) REFERENCES MolgenisRole (id) ON DELETE CASCADE;
		ALTER TABLE MolgenisUser ADD FOREIGN KEY (id) REFERENCES Person (id) ON DELETE CASCADE;
		ALTER TABLE MolgenisRoleGroupLink ADD FOREIGN KEY (group_) REFERENCES MolgenisGroup (id) ON DELETE RESTRICT;
		ALTER TABLE MolgenisRoleGroupLink ADD FOREIGN KEY (role_) REFERENCES MolgenisRole (id) ON DELETE RESTRICT;
		ALTER TABLE OntologyTerm ADD FOREIGN KEY (ontology) REFERENCES Ontology (id) ON DELETE RESTRICT;
		ALTER TABLE MolgenisPermission ADD FOREIGN KEY (role_) REFERENCES MolgenisRole (id) ON DELETE RESTRICT;
		ALTER TABLE MolgenisPermission ADD FOREIGN KEY (entity) REFERENCES MolgenisEntity (id) ON DELETE RESTRICT;
		ALTER TABLE Species ADD FOREIGN KEY (id) REFERENCES OntologyTerm (id) ON DELETE CASCADE;
		ALTER TABLE AlternateId ADD FOREIGN KEY (id) REFERENCES OntologyTerm (id) ON DELETE CASCADE;
		ALTER TABLE ObservationElement ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE ObservationTarget ADD FOREIGN KEY (id) REFERENCES ObservationElement (id) ON DELETE CASCADE;
		ALTER TABLE ObservableFeature ADD FOREIGN KEY (id) REFERENCES ObservationElement (id) ON DELETE CASCADE;
		ALTER TABLE Category ADD FOREIGN KEY (id) REFERENCES ObservationElement (id) ON DELETE CASCADE;
		ALTER TABLE Individual ADD FOREIGN KEY (Mother) REFERENCES Individual (id) ON DELETE RESTRICT;
		ALTER TABLE Individual ADD FOREIGN KEY (Father) REFERENCES Individual (id) ON DELETE RESTRICT;
		ALTER TABLE Individual ADD FOREIGN KEY (id) REFERENCES ObservationTarget (id) ON DELETE CASCADE;
		ALTER TABLE Location ADD FOREIGN KEY (id) REFERENCES ObservationTarget (id) ON DELETE CASCADE;
		ALTER TABLE Chromosome ADD FOREIGN KEY (Species) REFERENCES Species (id) ON DELETE RESTRICT;
		ALTER TABLE Chromosome ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE NMRBin ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Clone ADD FOREIGN KEY (Chromosome) REFERENCES Chromosome (id) ON DELETE RESTRICT;
		ALTER TABLE Clone ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE DerivedTrait ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE EnvironmentalFactor ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Gene ADD FOREIGN KEY (Chromosome) REFERENCES Chromosome (id) ON DELETE RESTRICT;
		ALTER TABLE Gene ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Transcript ADD FOREIGN KEY (Gene) REFERENCES Gene (id) ON DELETE RESTRICT;
		ALTER TABLE Transcript ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Protein ADD FOREIGN KEY (Gene) REFERENCES Gene (id) ON DELETE RESTRICT;
		ALTER TABLE Protein ADD FOREIGN KEY (Transcript) REFERENCES Transcript (id) ON DELETE RESTRICT;
		ALTER TABLE Protein ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Metabolite ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Marker ADD FOREIGN KEY (Chromosome) REFERENCES Chromosome (id) ON DELETE RESTRICT;
		ALTER TABLE Marker ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Polymorphism ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE SNP ADD FOREIGN KEY (id) REFERENCES Marker (id) ON DELETE CASCADE;
		ALTER TABLE ProbeSet ADD FOREIGN KEY (Chromosome) REFERENCES Chromosome (id) ON DELETE RESTRICT;
		ALTER TABLE ProbeSet ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Probe ADD FOREIGN KEY (Chromosome) REFERENCES Chromosome (id) ON DELETE RESTRICT;
		ALTER TABLE Probe ADD FOREIGN KEY (ProbeSet) REFERENCES ProbeSet (id) ON DELETE RESTRICT;
		ALTER TABLE Probe ADD FOREIGN KEY (ReportsFor) REFERENCES Gene (id) ON DELETE RESTRICT;
		ALTER TABLE Probe ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Spot ADD FOREIGN KEY (id) REFERENCES Probe (id) ON DELETE CASCADE;
		ALTER TABLE MassPeak ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE InvestigationFile ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE InvestigationFile ADD FOREIGN KEY (id) REFERENCES MolgenisFile (id) ON DELETE CASCADE;
		ALTER TABLE Tissue ADD FOREIGN KEY (id) REFERENCES OntologyTerm (id) ON DELETE CASCADE;
		ALTER TABLE SampleLabel ADD FOREIGN KEY (id) REFERENCES OntologyTerm (id) ON DELETE CASCADE;
		ALTER TABLE Publication ADD FOREIGN KEY (PubmedID) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE Publication ADD FOREIGN KEY (DOI) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE Publication ADD FOREIGN KEY (Status) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE DataFile ADD FOREIGN KEY (format) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE DataFile ADD FOREIGN KEY (id) REFERENCES ObservationTarget (id) ON DELETE CASCADE;
		ALTER TABLE Measurement ADD FOREIGN KEY (unit) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE Measurement ADD FOREIGN KEY (targettypeAllowedForRelation) REFERENCES MolgenisEntity (id) ON DELETE RESTRICT;
		ALTER TABLE Measurement ADD FOREIGN KEY (id) REFERENCES ObservableFeature (id) ON DELETE CASCADE;
		ALTER TABLE Panel ADD FOREIGN KEY (Species) REFERENCES Species (id) ON DELETE RESTRICT;
		ALTER TABLE Panel ADD FOREIGN KEY (PanelType) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE Panel ADD FOREIGN KEY (id) REFERENCES ObservationTarget (id) ON DELETE CASCADE;
		ALTER TABLE Protocol ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol ADD FOREIGN KEY (ProtocolType) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol ADD FOREIGN KEY (Contact) REFERENCES Person (id) ON DELETE RESTRICT;
		ALTER TABLE Workflow ADD FOREIGN KEY (id) REFERENCES Protocol (id) ON DELETE CASCADE;
		ALTER TABLE Data ADD FOREIGN KEY (id) REFERENCES ProtocolApplication (id) ON DELETE CASCADE;
		ALTER TABLE BinaryDataMatrix ADD FOREIGN KEY (Data) REFERENCES Data (id) ON DELETE RESTRICT;
		ALTER TABLE BinaryDataMatrix ADD FOREIGN KEY (id) REFERENCES MolgenisFile (id) ON DELETE CASCADE;
		ALTER TABLE CSVDataMatrix ADD FOREIGN KEY (Data) REFERENCES Data (id) ON DELETE RESTRICT;
		ALTER TABLE CSVDataMatrix ADD FOREIGN KEY (id) REFERENCES MolgenisFile (id) ON DELETE CASCADE;
		ALTER TABLE OriginalFile ADD FOREIGN KEY (Data) REFERENCES Data (id) ON DELETE RESTRICT;
		ALTER TABLE OriginalFile ADD FOREIGN KEY (id) REFERENCES MolgenisFile (id) ON DELETE CASCADE;
		ALTER TABLE ProtocolApplication ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolApplication ADD FOREIGN KEY (protocol) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolDocument ADD FOREIGN KEY (protocol) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolDocument ADD FOREIGN KEY (id) REFERENCES MolgenisFile (id) ON DELETE CASCADE;
		ALTER TABLE WorkflowElement ADD FOREIGN KEY (Workflow) REFERENCES Workflow (id) ON DELETE RESTRICT;
		ALTER TABLE WorkflowElement ADD FOREIGN KEY (protocol) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE WorkflowElementParameter ADD FOREIGN KEY (WorkflowElement) REFERENCES WorkflowElement (id) ON DELETE RESTRICT;
		ALTER TABLE WorkflowElementParameter ADD FOREIGN KEY (Parameter) REFERENCES ObservableFeature (id) ON DELETE RESTRICT;
		ALTER TABLE Sample ADD FOREIGN KEY (Individual) REFERENCES Individual (id) ON DELETE RESTRICT;
		ALTER TABLE Sample ADD FOREIGN KEY (Tissue) REFERENCES Tissue (id) ON DELETE RESTRICT;
		ALTER TABLE Sample ADD FOREIGN KEY (id) REFERENCES ObservationTarget (id) ON DELETE CASCADE;
		ALTER TABLE PairedSample ADD FOREIGN KEY (Subject1) REFERENCES Individual (id) ON DELETE RESTRICT;
		ALTER TABLE PairedSample ADD FOREIGN KEY (Label1) REFERENCES SampleLabel (id) ON DELETE RESTRICT;
		ALTER TABLE PairedSample ADD FOREIGN KEY (Subject2) REFERENCES Individual (id) ON DELETE RESTRICT;
		ALTER TABLE PairedSample ADD FOREIGN KEY (Label2) REFERENCES SampleLabel (id) ON DELETE RESTRICT;
		ALTER TABLE PairedSample ADD FOREIGN KEY (id) REFERENCES ObservationTarget (id) ON DELETE CASCADE;
		ALTER TABLE DecimalDataElement ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE DecimalDataElement ADD FOREIGN KEY (protocolApplication) REFERENCES ProtocolApplication (id) ON DELETE RESTRICT;
		ALTER TABLE DecimalDataElement ADD FOREIGN KEY (Feature) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE DecimalDataElement ADD FOREIGN KEY (Target) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE DecimalDataElement ADD FOREIGN KEY (Data) REFERENCES Data (id) ON DELETE RESTRICT;
		ALTER TABLE TextDataElement ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE TextDataElement ADD FOREIGN KEY (protocolApplication) REFERENCES ProtocolApplication (id) ON DELETE RESTRICT;
		ALTER TABLE TextDataElement ADD FOREIGN KEY (Feature) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE TextDataElement ADD FOREIGN KEY (Target) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE TextDataElement ADD FOREIGN KEY (Data) REFERENCES Data (id) ON DELETE RESTRICT;
		ALTER TABLE ObservedValue ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE ObservedValue ADD FOREIGN KEY (protocolApplication) REFERENCES ProtocolApplication (id) ON DELETE RESTRICT;
		ALTER TABLE ObservedValue ADD FOREIGN KEY (Feature) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE ObservedValue ADD FOREIGN KEY (Target) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE ObservedValue ADD FOREIGN KEY (ontologyReference) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE ObservedValue ADD FOREIGN KEY (relation) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE ParameterName ADD FOREIGN KEY (ParameterSet) REFERENCES ParameterSet (id) ON DELETE RESTRICT;
		ALTER TABLE ParameterValue ADD FOREIGN KEY (ParameterName) REFERENCES ParameterName (id) ON DELETE RESTRICT;
		ALTER TABLE Analysis ADD FOREIGN KEY (ParameterSet) REFERENCES ParameterSet (id) ON DELETE RESTRICT;
		ALTER TABLE Analysis ADD FOREIGN KEY (DataSet) REFERENCES DataSet (id) ON DELETE RESTRICT;
		ALTER TABLE Job ADD FOREIGN KEY (Analysis) REFERENCES Analysis (id) ON DELETE RESTRICT;
		ALTER TABLE Subjob ADD FOREIGN KEY (Job) REFERENCES Job (id) ON DELETE RESTRICT;
		ALTER TABLE DataName ADD FOREIGN KEY (DataSet) REFERENCES DataSet (id) ON DELETE RESTRICT;
		ALTER TABLE DataValue ADD FOREIGN KEY (DataName) REFERENCES DataName (id) ON DELETE RESTRICT;
		ALTER TABLE DataValue ADD FOREIGN KEY (Value) REFERENCES Data (id) ON DELETE RESTRICT;
		ALTER TABLE SelectedParameter ADD FOREIGN KEY (Job) REFERENCES Job (id) ON DELETE RESTRICT;
		ALTER TABLE SelectedData ADD FOREIGN KEY (Job) REFERENCES Job (id) ON DELETE RESTRICT;
		ALTER TABLE RScript ADD FOREIGN KEY (id) REFERENCES InvestigationFile (id) ON DELETE CASCADE;
		ALTER TABLE Investigation_contacts ADD FOREIGN KEY (contacts) REFERENCES Person (id) ON DELETE RESTRICT;
		ALTER TABLE Investigation_contacts ADD FOREIGN KEY (Investigation) REFERENCES Investigation (id) ON DELETE RESTRICT;
		ALTER TABLE ObservationElement_ontolo12449 ADD FOREIGN KEY (ontologyReference) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE ObservationElement_ontolo12449 ADD FOREIGN KEY (InvestigationElement) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE ObservationElement_AlternateId ADD FOREIGN KEY (AlternateId) REFERENCES AlternateId (id) ON DELETE RESTRICT;
		ALTER TABLE ObservationElement_AlternateId ADD FOREIGN KEY (ObservationElement) REFERENCES ObservationElement (id) ON DELETE RESTRICT;
		ALTER TABLE Measurement_categories ADD FOREIGN KEY (categories) REFERENCES Category (id) ON DELETE RESTRICT;
		ALTER TABLE Measurement_categories ADD FOREIGN KEY (Measurement) REFERENCES Measurement (id) ON DELETE RESTRICT;
		ALTER TABLE Panel_Individuals ADD FOREIGN KEY (Individuals) REFERENCES Individual (id) ON DELETE RESTRICT;
		ALTER TABLE Panel_Individuals ADD FOREIGN KEY (Panel) REFERENCES Panel (id) ON DELETE RESTRICT;
		ALTER TABLE Panel_FounderPanels ADD FOREIGN KEY (FounderPanels) REFERENCES Panel (id) ON DELETE RESTRICT;
		ALTER TABLE Panel_FounderPanels ADD FOREIGN KEY (Panel) REFERENCES Panel (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol_ontologyReference ADD FOREIGN KEY (ontologyReference) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol_ontologyReference ADD FOREIGN KEY (InvestigationElement) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol_Features ADD FOREIGN KEY (Features) REFERENCES ObservableFeature (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol_Features ADD FOREIGN KEY (Protocol) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol_subprotocols ADD FOREIGN KEY (subprotocols) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE Protocol_subprotocols ADD FOREIGN KEY (Protocol) REFERENCES Protocol (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolApplication_ontol11768 ADD FOREIGN KEY (ontologyReference) REFERENCES OntologyTerm (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolApplication_ontol11768 ADD FOREIGN KEY (InvestigationElement) REFERENCES ProtocolApplication (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolApplication_Performer ADD FOREIGN KEY (Performer) REFERENCES Person (id) ON DELETE RESTRICT;
		ALTER TABLE ProtocolApplication_Performer ADD FOREIGN KEY (ProtocolApplication) REFERENCES ProtocolApplication (id) ON DELETE RESTRICT;
		ALTER TABLE WorkflowElement_PreviousSteps ADD FOREIGN KEY (PreviousSteps) REFERENCES WorkflowElement (id) ON DELETE RESTRICT;
		ALTER TABLE WorkflowElement_PreviousSteps ADD FOREIGN KEY (WorkflowElement) REFERENCES WorkflowElement (id) ON DELETE RESTRICT;
		ALTER TABLE Marker_ReportsFor ADD FOREIGN KEY (ReportsFor) REFERENCES Marker (id) ON DELETE RESTRICT;
		ALTER TABLE Marker_ReportsFor ADD FOREIGN KEY (Marker) REFERENCES Marker (id) ON DELETE RESTRICT;
		ALTER TABLE SNP_Polymorphism ADD FOREIGN KEY (Polymorphism) REFERENCES Polymorphism (id) ON DELETE RESTRICT;
		ALTER TABLE SNP_Polymorphism ADD FOREIGN KEY (SNP) REFERENCES SNP (id) ON DELETE RESTRICT;
