/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.java2d.FigTextRenderer;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigRenderer;
import jfig.objects.Point;
import jfig.utils.LP2;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigText
extends FigBaseobject {
    private static char[] recode_table = new char[65536];
    int textCursorIndex;
    boolean showCursorFlag;
    String str;
    String recoded;
    FigRenderer renderer;
    Polygon border;
    FigCompound _TeX;
    double ascent;
    double descent;
    double width;
    double left;
    double right;
    double theta;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createTextRenderer(this);
        this.needsRebuild = false;
    }

    public boolean isShowCursor() {
        return this.showCursorFlag;
    }

    public int getTextCursorIndex() {
        return this.textCursorIndex;
    }

    public void rebuild() {
        this.update_bbox();
        this.needsRebuild = true;
    }

    public boolean isTeXMode() {
        boolean bl = false;
        if ((this.attribs.fig_font_flags & 2) != 0 && SetupManager.getBoolean("jfig.showTeXStrings", false)) {
            bl = true;
        }
        return bl;
    }

    public String getSymbolRecodedString() {
        this.recoded = this.str;
        if (this.attribs.fig_font == 32) {
            this.recoded = FigText.symbol_recode(this.str);
        }
        return this.recoded;
    }

    public void update_bbox() {
        try {
            if (this.isTeXMode()) {
                this._TeX = this.buildTeXModeBoxes();
                this.bbox = this._TeX.getBbox();
                this.width = this.bbox.getXr() - this.bbox.getXl();
                this.ascent = this.bbox.getYt();
                this.descent = this.bbox.getYb();
                this.theta = -this.attribs.fig_angle;
                if (this.attribs.textAlign == 1) {
                    this.left = 0.0;
                    this.right = this.width;
                } else if (this.attribs.textAlign == 3) {
                    this.left = -this.width;
                    this.right = 0.0;
                } else if (this.attribs.textAlign == 2) {
                    this.left = -this.width / (double)2;
                    this.right = this.width / (double)2;
                }
                this._TeX.move(this.x + this.left, this.y);
                if (this.theta != 0.0) {
                    this._TeX.rotate(new Point(this.x, this.y), this.theta);
                }
            } else {
                this._TeX = null;
                this.recoded = this.getSymbolRecodedString();
                double[] dArray = FigTextRenderer.getLRWAD(this.recoded, this.attribs);
                this.left = dArray[0];
                this.right = dArray[1];
                this.width = dArray[2];
                this.ascent = dArray[3];
                this.descent = dArray[4];
                this.theta = -this.attribs.fig_angle;
                if (this.attribs.textAlign == 1) {
                    this.left = 0.0;
                    this.right = this.width;
                } else if (this.attribs.textAlign == 3) {
                    this.left = -this.width;
                    this.right = 0.0;
                } else if (this.attribs.textAlign == 2) {
                    this.left = -this.width / (double)2;
                    this.right = this.width / (double)2;
                }
            }
            double d = Math.cos(this.theta);
            double d2 = Math.sin(this.theta);
            double d3 = this.x + this.left * d - this.ascent * d2;
            double d4 = this.y + this.left * d2 + this.ascent * d;
            double d5 = this.x + this.left * d - this.descent * d2;
            double d6 = this.y + this.left * d2 + this.descent * d;
            double d7 = this.x + this.right * d - this.descent * d2;
            double d8 = this.y + this.right * d2 + this.descent * d;
            double d9 = this.x + this.right * d - this.ascent * d2;
            double d10 = this.y + this.right * d2 + this.ascent * d;
            this.bbox = new FigBbox(this.min(d3, d5, d7, d9), this.min(d4, d6, d8, d10), this.max(d3, d5, d7, d9), this.max(d4, d6, d8, d10));
            this.border = new Polygon();
            this.border.addPoint((int)d3, (int)d4);
            this.border.addPoint((int)d5, (int)d6);
            this.border.addPoint((int)d7, (int)d8);
            this.border.addPoint((int)d9, (int)d10);
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigText.update_bbox: internal error: " + throwable);
            throwable.printStackTrace();
        }
    }

    private final int min(double d, double d2, double d3, double d4) {
        return (int)Math.min(Math.min(d, d2), Math.min(d3, d4));
    }

    private final int max(double d, double d2, double d3, double d4) {
        return (int)Math.max(Math.max(d, d2), Math.max(d3, d4));
    }

    public double[] getLRWAD() {
        return new double[]{this.left, this.right, this.width, this.ascent, this.descent};
    }

    public FigCompound buildTeXModeBoxes() {
        LP2 lP2 = new LP2();
        lP2.setFontIndex(this.attribs.fig_font);
        lP2.setFontPtSize(this.attribs.fontSize);
        lP2.setColorIndex(this.attribs.fig_line_color);
        lP2.setEnableDisplayBoxes(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.displayBoxes", false));
        lP2.setEnableDumpTokens(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.dumpTokens", false));
        lP2.setUseWords(SetupManager.getBoolean("jfig.utils.SimpleLatexParser.useWords", true));
        lP2.setFontMode(SetupManager.getInteger("jfig.utils.SimpleLatexParser.fontMode", 2));
        lP2.parse(this.str);
        FigCompound figCompound = new FigCompound();
        lP2.convertToFig(figCompound);
        figCompound.update_bbox();
        return figCompound;
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this._TeX != null) {
            if (this.showPoints) {
                this._TeX.showPoints();
            } else if (this.selected) {
                this._TeX.select();
            } else {
                this._TeX.deselect();
            }
            if (this.visible) {
                this._TeX.paint(graphics, figTrafo2D);
            }
        } else {
            if (this.needsRebuild) {
                this.createRenderer();
            }
            this.renderer.paint(graphics, figTrafo2D);
        }
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        Graphics graphics2 = graphics.create();
        this.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public void showCursor(boolean bl) {
        this.showCursorFlag = bl;
    }

    public int setTextCursorFromPosition(Point point, FigCanvas figCanvas) {
        try {
            double d = this.x + this.left * Math.cos(this.theta);
            double d2 = this.y + this.left * Math.sin(this.theta);
            double d3 = point.x - d;
            double d4 = point.y - d2;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            this.textCursorIndex = 0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            boolean bl = false;
            int n = 1;
            int n2 = this.str.length() + 1;
            while (n < n2) {
                String string = this.str.substring(0, n);
                double d9 = FigTextRenderer.getStringWidth(string, this.attribs);
                d6 = d7;
                d7 = d9;
                d8 = 0.5 * (d6 + d7);
                if (d5 >= d6 && d5 <= d7) {
                    bl = true;
                    if (d5 <= d8) {
                        this.textCursorIndex = n - 1;
                        break;
                    }
                    this.textCursorIndex = n;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.textCursorIndex = this.str.length();
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigText.setTextCursorFromPosition: '" + this.str + '\'' + this.textCursorIndex + ' ' + point);
            throwable.printStackTrace();
        }
        return this.textCursorIndex;
    }

    public void moveCursorTo(int n) {
        this.textCursorIndex = n;
        this.needsRebuild = true;
    }

    public void move(double d, double d2) {
        this.x += d;
        this.y += d2;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public FigObject copy() {
        FigText figText = new FigText(new Point(this.x, this.y), this.str, this.attribs.getClone());
        return figText;
    }

    public boolean canRotate(double d) {
        return true;
    }

    public void rotate(Point point, double d) {
        if (this.debug) {
            this.message("-#- FigText.rotate: " + point + ' ' + d);
        }
        this.x -= point.x;
        this.y -= point.y;
        double d2 = this.x * Math.cos(d) - this.y * Math.sin(d);
        double d3 = this.x * Math.sin(d) + this.y * Math.cos(d);
        this.x = (double)((int)d2) + point.x;
        this.y = (double)((int)d3) + point.y;
        this.attribs.fig_angle += -d;
        if (this.attribs.fig_angle >= Math.PI * 2) {
            this.attribs.fig_angle -= Math.PI * 2;
        }
        if (this.attribs.fig_angle <= 0.0) {
            this.attribs.fig_angle += Math.PI * 2;
        }
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void scale(Point point, double d, double d2) {
        if (SetupManager.getBoolean("jfig.scaleFontSize", true)) {
            this.attribs.fontSize = (int)((double)this.attribs.fontSize * Math.abs(d));
        }
        super.scale(point, d, d2);
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void mirrorX(double d, double d2) {
        double d3 = (double)2 * d - this.x;
        double d4 = this.y;
        if (this.attribs.textAlign == 1) {
            this.attribs.textAlign = 3;
        } else if (this.attribs.textAlign == 3) {
            this.attribs.textAlign = 1;
        }
        this.move(d3 - this.x, 0.0);
    }

    public void mirrorY(double d, double d2) {
        double d3 = this.x;
        double d4 = (double)2 * d2 - this.y;
        this.move(0.0, d4 - this.y);
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void update(FigAttribs figAttribs) {
        this.attribs.update(figAttribs);
        this.update_bbox();
        this.needsRebuild = true;
    }

    public double minDistance(Point point, double d) {
        double d2 = Math.abs(point.x - this.x) + Math.abs(point.y - this.y);
        double d3 = this.bbox.minDistance(point);
        if (!this.bbox.isInside(point)) {
            return Math.min(d2, d3);
        }
        if (this.border == null) {
            this.update_bbox();
        }
        if (this.border.contains(point.x, point.y)) {
            d3 = d <= 0.0 ? d2 : 0.9 * d;
        }
        return Math.min(d2, d3);
    }

    public double minDistanceEuclid(Point point, double d) {
        return this.minDistance(point, d);
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.x, this.y)};
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray == null || pointArray.length < 1) {
            return;
        }
        this.x = pointArray[0].x;
        this.y = pointArray[0].y;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public String getText() {
        return this.str;
    }

    public void setText(String string) {
        this.str = string != null ? string : " ";
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void setFont(int n) {
        this.attribs.fig_font = n;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void setFontSize(int n) {
        this.attribs.fontSize = n;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void setTextAlignment(int n) {
        this.attribs.textAlign = n;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void setColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
        this.needsRebuild = true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (this.debug) {
            this.message(this.toString() + ".keyPressed: " + keyEvent);
        }
        if (keyEvent.isActionKey()) {
            if (n == 37) {
                --this.textCursorIndex;
                if (this.textCursorIndex < 0) {
                    this.textCursorIndex = 0;
                }
            } else if (n == 39) {
                ++this.textCursorIndex;
                if (this.textCursorIndex >= this.str.length()) {
                    this.textCursorIndex = this.str.length();
                }
            } else if (n != 38) {
                // empty if block
            }
        }
        if (c == '\b' || c == '\u007f' || c == '\b' || c == (char)-1 || c == '\uff08') {
            if (this.str.length() > 0) {
                if (this.str.length() > this.textCursorIndex) {
                    this.str = this.str.substring(0, this.textCursorIndex) + this.str.substring(this.textCursorIndex + 1, this.str.length());
                } else {
                    this.str = this.str.substring(0, this.textCursorIndex - 1);
                    --this.textCursorIndex;
                }
            }
        } else {
            if (c < ' ') {
                if (this.debug) {
                    this.message("Ignoring control char: '" + c);
                }
                return;
            }
            if (c > '\u00ff') {
                char c2 = c;
            } else {
                int n2;
                if (keyEvent.isAltDown()) {
                    if (c == 'a') {
                        n2 = 228;
                    } else if (c == 'A') {
                        n2 = 196;
                    } else if (c == 'o') {
                        n2 = 246;
                    } else if (c == 'O') {
                        n2 = 214;
                    } else if (c == 'u') {
                        n2 = 252;
                    } else if (c == 'U') {
                        n2 = 220;
                    } else if (c == 's') {
                        n2 = 223;
                    } else {
                        this.message("FigText: ignored <ALT> modifier for key:" + c);
                        n2 = c;
                    }
                } else {
                    n2 = c;
                }
                this.str = this.str.substring(0, this.textCursorIndex) + (char)n2 + this.str.substring(this.textCursorIndex, this.str.length());
                ++this.textCursorIndex;
            }
        }
        this.update_bbox();
        this.needsRebuild = true;
    }

    public static String symbol_recode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(recode_table[string.charAt(n)]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    public String toString() {
        String string = "FigText at " + this.x + ',' + this.y + " layer " + this.attribs.currentLayer + " text: '" + this.str + "' ";
        return string;
    }

    private final /* synthetic */ void this() {
        this.textCursorIndex = 0;
        this.showCursorFlag = false;
    }

    public FigText() {
        this(new Point(0.0, 0.0), "", new FigAttribs());
    }

    public FigText(Point point, String string, FigAttribs figAttribs) {
        this.this();
        this.x = point.x;
        this.y = point.y;
        this.str = string;
        this.attribs = figAttribs;
        this.update_bbox();
        this.needsRebuild = true;
    }

    static {
        char c = '\u0000';
        while (c < (char)-1) {
            FigText.recode_table[c] = c;
            c = (char)(c + '\u0001');
        }
        FigText.recode_table[97] = 945;
        FigText.recode_table[98] = 946;
        FigText.recode_table[99] = 967;
        FigText.recode_table[100] = 948;
        FigText.recode_table[101] = 949;
        FigText.recode_table[102] = 966;
        FigText.recode_table[103] = 947;
        FigText.recode_table[104] = 951;
        FigText.recode_table[105] = 953;
        FigText.recode_table[106] = 981;
        FigText.recode_table[107] = 954;
        FigText.recode_table[108] = 955;
        FigText.recode_table[109] = 956;
        FigText.recode_table[110] = 957;
        FigText.recode_table[111] = 959;
        FigText.recode_table[112] = 960;
        FigText.recode_table[113] = 952;
        FigText.recode_table[114] = 961;
        FigText.recode_table[115] = 963;
        FigText.recode_table[116] = 964;
        FigText.recode_table[117] = 965;
        FigText.recode_table[118] = 982;
        FigText.recode_table[119] = 969;
        FigText.recode_table[120] = 958;
        FigText.recode_table[121] = 968;
        FigText.recode_table[122] = 950;
        FigText.recode_table[65] = 913;
        FigText.recode_table[66] = 914;
        FigText.recode_table[67] = 935;
        FigText.recode_table[68] = 916;
        FigText.recode_table[69] = 917;
        FigText.recode_table[70] = 934;
        FigText.recode_table[71] = 915;
        FigText.recode_table[72] = 919;
        FigText.recode_table[73] = 921;
        FigText.recode_table[74] = 977;
        FigText.recode_table[75] = 922;
        FigText.recode_table[76] = 923;
        FigText.recode_table[77] = 924;
        FigText.recode_table[78] = 925;
        FigText.recode_table[79] = 927;
        FigText.recode_table[80] = 928;
        FigText.recode_table[81] = 920;
        FigText.recode_table[82] = 929;
        FigText.recode_table[83] = 931;
        FigText.recode_table[84] = 932;
        FigText.recode_table[85] = 933;
        FigText.recode_table[86] = 962;
        FigText.recode_table[87] = 937;
        FigText.recode_table[88] = 926;
        FigText.recode_table[89] = 936;
        FigText.recode_table[90] = 918;
        FigText.recode_table[161] = 978;
        FigText.recode_table[162] = 39;
        FigText.recode_table[163] = 8804;
        FigText.recode_table[164] = 8725;
        FigText.recode_table[165] = 8734;
        FigText.recode_table[166] = 102;
        FigText.recode_table[167] = 10088;
        FigText.recode_table[168] = 10069;
        FigText.recode_table[169] = 10084;
        FigText.recode_table[170] = 10085;
        FigText.recode_table[171] = 8596;
        FigText.recode_table[172] = 8592;
        FigText.recode_table[173] = 8593;
        FigText.recode_table[174] = 8594;
        FigText.recode_table[175] = 8595;
        FigText.recode_table[176] = 8728;
        FigText.recode_table[177] = 177;
        FigText.recode_table[178] = 34;
        FigText.recode_table[179] = 8805;
        FigText.recode_table[180] = 10005;
        FigText.recode_table[181] = 8733;
        FigText.recode_table[182] = 8706;
        FigText.recode_table[183] = 8729;
        FigText.recode_table[184] = 37;
        FigText.recode_table[185] = 8800;
        FigText.recode_table[186] = 8801;
        FigText.recode_table[187] = 8776;
        FigText.recode_table[188] = 8943;
        FigText.recode_table[189] = 8739;
        FigText.recode_table[190] = 8722;
        FigText.recode_table[191] = 8629;
        FigText.recode_table[192] = 8501;
        FigText.recode_table[193] = 8465;
        FigText.recode_table[194] = 8476;
        FigText.recode_table[195] = 8472;
        FigText.recode_table[196] = 8855;
        FigText.recode_table[197] = 8853;
        FigText.recode_table[198] = 8709;
        FigText.recode_table[199] = 8745;
        FigText.recode_table[200] = 8746;
        FigText.recode_table[201] = 8835;
        FigText.recode_table[202] = 8839;
        FigText.recode_table[203] = 8836;
        FigText.recode_table[204] = 8834;
        FigText.recode_table[205] = 8838;
        FigText.recode_table[206] = 8712;
        FigText.recode_table[207] = 8713;
        FigText.recode_table[208] = 8736;
        FigText.recode_table[209] = 8711;
        FigText.recode_table[210] = 174;
        FigText.recode_table[211] = 169;
        FigText.recode_table[212] = 8482;
        FigText.recode_table[213] = 8719;
        FigText.recode_table[214] = 8730;
        FigText.recode_table[215] = 8901;
        FigText.recode_table[216] = 173;
        FigText.recode_table[217] = 8743;
        FigText.recode_table[218] = 8744;
        FigText.recode_table[219] = 8660;
        FigText.recode_table[220] = 8656;
        FigText.recode_table[221] = 8657;
        FigText.recode_table[222] = 8658;
        FigText.recode_table[223] = 8659;
        FigText.recode_table[224] = 8900;
        FigText.recode_table[225] = 8900;
        FigText.recode_table[229] = 8721;
        FigText.recode_table[242] = 8747;
        FigText.recode_table[255] = 8364;
        FigText.recode_table[92] = 8756;
        FigText.recode_table[64] = 8773;
        FigText.recode_table[36] = 8707;
        FigText.recode_table[34] = 8704;
        FigText.recode_table[39] = 8717;
        FigText.recode_table[94] = 8869;
        FigText.recode_table[96] = 8722;
    }
}

