/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigPolyline;
import jfig.objects.Point;
import jfig.utils.SetupManager;

public class FigSpline
extends FigPolyline {
    public static final int INITIAL_ARRAY_SIZE = 1000;
    public static final double DEFAULT_STEPSIZE = 100.0;
    static Point[] pp = new Point[1000];
    static int ii = 0;
    static double[][] stack = new double[20][8];
    static int stack_p = 0;
    Point[] wcp_spline;

    public void createRenderer() {
        this.buildSpline();
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createSplineRenderer(this);
        this.needsRebuild = false;
    }

    final int round(double d) {
        return (int)(d + 0.5);
    }

    public Point[] getSplinePoints() {
        return this.wcp_spline;
    }

    private final void build_openPP() {
        ii = 0;
        double d = this.wcp[0].x;
        double d2 = this.wcp[0].y;
        double d3 = this.wcp[1].x;
        double d4 = this.wcp[1].y;
        double d5 = 0.5 * (d + d3);
        double d6 = 0.5 * (d2 + d4);
        double d7 = 0.5 * (d5 + d3);
        double d8 = 0.5 * (d6 + d4);
        this.append_pp(d, d2);
        int n = 2;
        while (n < this.wcp.length) {
            d = d3;
            d2 = d4;
            d3 = this.wcp[n].x;
            d4 = this.wcp[n].y;
            double d9 = 0.5 * (d + d3);
            double d10 = 0.5 * (d2 + d4);
            double d11 = 0.5 * (d + d9);
            double d12 = 0.5 * (d2 + d10);
            this.quadratic_spline(d5, d6, d7, d8, d11, d12, d9, d10);
            d5 = d9;
            d6 = d10;
            d7 = 0.5 * (d5 + d3);
            d8 = 0.5 * (d6 + d4);
            ++n;
        }
        this.append_pp(d5, d6);
        this.append_pp(d3, d4);
    }

    private final void build_closedPP() {
        double d;
        double d2;
        double d3;
        double d4;
        ii = 0;
        if (this.debug) {
            this.message("FigSpline: build_closedPP() started...");
        }
        Point[] pointArray = new Point[this.wcp.length + 1];
        int n = 0;
        while (n < this.wcp.length) {
            pointArray[n] = this.wcp[n];
            ++n;
        }
        pointArray[this.wcp.length] = this.wcp[0];
        double d5 = pointArray[0].x;
        double d6 = pointArray[0].y;
        double d7 = pointArray[1].x;
        double d8 = pointArray[1].y;
        double d9 = 0.5 * (d5 + d7);
        double d10 = 0.5 * (d6 + d8);
        double d11 = 0.25 * (d5 + (double)3 * d7);
        double d12 = 0.25 * (d6 + (double)3 * d8);
        n = 2;
        while (n < pointArray.length) {
            d5 = d7;
            d6 = d8;
            d7 = pointArray[n].x;
            d8 = pointArray[n].y;
            d4 = 0.5 * (d5 + d7);
            d3 = 0.5 * (d6 + d8);
            d2 = 0.5 * (d5 + d4);
            d = 0.5 * (d6 + d3);
            this.quadratic_spline(d9, d10, d11, d12, d2, d, d4, d3);
            d9 = d4;
            d10 = d3;
            d11 = 0.5 * (d9 + d7);
            d12 = 0.5 * (d10 + d8);
            ++n;
        }
        d5 = d7;
        d6 = d8;
        d7 = pointArray[1].x;
        d8 = pointArray[1].y;
        d4 = 0.5 * (d5 + d7);
        d3 = 0.5 * (d6 + d8);
        d2 = 0.5 * (d5 + d4);
        d = 0.5 * (d6 + d3);
        this.quadratic_spline(d9, d10, d11, d12, d2, d, d4, d3);
        this.append_pp(d4, d3);
        pointArray = null;
    }

    private final void quadratic_spline(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = SetupManager.getDouble("jfig.objects.FigSpline.stepsize", 100.0);
        this.clear_stack();
        this.push(d, d2, d3, d4, d5, d6, d7, d8);
        while (this.pop()) {
            double d10 = stack[stack_p][0];
            double d11 = stack[stack_p][1];
            double d12 = stack[stack_p][2];
            double d13 = stack[stack_p][3];
            double d14 = stack[stack_p][4];
            double d15 = stack[stack_p][5];
            double d16 = stack[stack_p][6];
            double d17 = stack[stack_p][7];
            double d18 = 0.5 * (d12 + d14);
            double d19 = 0.5 * (d13 + d15);
            if (Math.abs(d10 - d18) < d9 && Math.abs(d11 - d19) < d9 && Math.abs(d18 - d16) < d9 && Math.abs(d19 - d17) < d9) {
                this.append_pp(d10, d11);
                this.append_pp(d18, d19);
                continue;
            }
            this.push(d18, d19, 0.5 * (d18 + d14), 0.5 * (d19 + d15), 0.5 * (d14 + d16), 0.5 * (d15 + d17), d16, d17);
            this.push(d10, d11, 0.5 * (d10 + d12), 0.5 * (d11 + d13), 0.5 * (d12 + d18), 0.5 * (d13 + d19), d18, d19);
        }
    }

    private final void clear_stack() {
        stack_p = 0;
    }

    private final void push(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        FigSpline.stack[FigSpline.stack_p][0] = d;
        FigSpline.stack[FigSpline.stack_p][1] = d2;
        FigSpline.stack[FigSpline.stack_p][2] = d3;
        FigSpline.stack[FigSpline.stack_p][3] = d4;
        FigSpline.stack[FigSpline.stack_p][4] = d5;
        FigSpline.stack[FigSpline.stack_p][5] = d6;
        FigSpline.stack[FigSpline.stack_p][6] = d7;
        FigSpline.stack[FigSpline.stack_p][7] = d8;
        ++stack_p;
    }

    private final boolean pop() {
        if (stack_p == 0) {
            return false;
        }
        --stack_p;
        return true;
    }

    private final void append_pp(double d, double d2) {
        try {
            if (ii >= pp.length) {
                int n = pp.length;
                Point[] pointArray = new Point[2 * n];
                int n2 = 0;
                while (n2 < n) {
                    pointArray[n2] = pp[n2];
                    ++n2;
                }
                pp = pointArray;
            }
            FigSpline.pp[FigSpline.ii++] = new Point(d, d2);
        }
        catch (Exception exception) {
            System.err.println("-E- in FigSpline.append_pp: " + exception);
        }
    }

    public String toString() {
        String string = "FigSpline with " + this.wcp.length + " control points: ";
        int n = 0;
        while (n < this.wcp.length) {
            string = string + "( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ";
            ++n;
        }
        if (this.wcp_spline != null) {
            string = string + "\n#interpolated points: " + this.wcp_spline.length;
        }
        return string;
    }

    public void rebuild() {
        this.createRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void buildSpline() {
        block10: {
            if (this.wcp.length > 2) {
                block9: {
                    block8: {
                        Point[] pointArray = pp;
                        // MONITORENTER : pp
                        if (!this.is_closed) break block8;
                        this.build_closedPP();
                        break block9;
                    }
                    this.build_openPP();
                }
                this.wcp_spline = new Point[ii];
                int n = 0;
                while (true) {
                    if (n >= ii) {
                        // MONITOREXIT : pointArray
                        break block10;
                    }
                    this.wcp_spline[n] = pp[n];
                    ++n;
                }
            }
            if (this.wcp.length == 2) {
                this.wcp_spline = new Point[2];
                this.wcp_spline[0] = this.wcp[0];
                this.wcp_spline[1] = this.wcp[1];
            } else {
                this.wcp_spline = new Point[]{this.wcp[0]};
            }
        }
        this.update_bbox();
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigSpline.copy()...");
        }
        FigSpline figSpline = new FigSpline(this.wcp[0].x, this.wcp[0].y, this.is_closed, this.attribs.getClone());
        figSpline.setPoints(this.getPoints());
        return figSpline;
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    public FigSpline(double d, double d2, boolean bl, FigAttribs figAttribs) {
        super(d, d2, bl, figAttribs);
        this.min_num_points = bl ? 3 : 2;
    }
}

