/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigRenderer;
import jfig.objects.Point;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigPolyline
implements FigObject {
    protected Point[] wcp;
    protected int min_i;
    protected int min_num_points;
    protected boolean is_closed;
    protected FigAttribs attribs;
    protected FigBbox bbox;
    protected FigRenderer renderer;
    protected ObjectPainter painter;
    protected String comment;
    protected boolean debug;
    protected boolean syncRedrawFlag;
    protected boolean selected;
    protected boolean showPoints;
    protected boolean visible;
    protected boolean needsRebuild;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createPolylineRenderer(this);
        this.needsRebuild = false;
    }

    public void rebuild() {
        this.update_bbox();
        this.createRenderer();
    }

    public boolean isClosed() {
        return this.is_closed;
    }

    public void setIsClosed(boolean bl) {
        boolean bl2 = bl ^ this.is_closed;
        this.is_closed = bl;
        if (bl2) {
            this.needsRebuild = true;
        }
    }

    public void appendPoint(Point point) {
        if (this.debug) {
            this.message("FigPolyline.appendPoint: " + point);
        }
        if (point.x == this.wcp[this.wcp.length - 1].x && point.y == this.wcp[this.wcp.length - 1].y) {
            return;
        }
        Point[] pointArray = new Point[this.wcp.length + 1];
        int n = 0;
        while (n < this.wcp.length) {
            pointArray[n] = this.wcp[n];
            ++n;
        }
        pointArray[this.wcp.length] = new Point(point.x, point.y);
        this.wcp = pointArray;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void update_bbox() {
        if (this.bbox == null) {
            this.bbox = new FigBbox(0.0, 0.0, 0.0, 0.0);
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        int n = 0;
        while (n < this.wcp.length) {
            if (this.wcp[n].x > d2) {
                d2 = this.wcp[n].x;
            }
            if (this.wcp[n].x < d) {
                d = this.wcp[n].x;
            }
            if (this.wcp[n].y > d4) {
                d4 = this.wcp[n].y;
            }
            if (this.wcp[n].y < d3) {
                d3 = this.wcp[n].y;
            }
            ++n;
        }
        this.bbox.set(d, d3, d2, d4);
    }

    public void setLayer(int n) {
        this.attribs.currentLayer = n;
    }

    public void setArrowMode(int n) {
        this.attribs.arrowMode = n;
        this.needsRebuild = true;
    }

    public void setForwardArrow(int n, double d, double d2, double d3) {
        this.attribs.arrow_f_Width = d * 96.0;
        this.attribs.arrow_f_Length = d2 * 96.0;
        this.attribs.arrow_f_Thickness = d3 * 30.0;
        this.needsRebuild = true;
    }

    public void setBackwardArrow(int n, double d, double d2, double d3) {
        this.attribs.arrow_b_Width = d * 96.0;
        this.attribs.arrow_b_Length = d2 * 96.0;
        this.attribs.arrow_b_Thickness = d3 * 30.0;
        this.needsRebuild = true;
    }

    public void setLineColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
        this.needsRebuild = true;
    }

    public void setLineWidth(int n) {
        this.attribs.setFigLineWidth(n);
        this.needsRebuild = true;
    }

    public void setLineStyle(int n) {
        this.attribs.lineStyle = n;
        this.needsRebuild = true;
    }

    public void setFillColor(Color color) {
        int n;
        this.attribs.fig_fill_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.fillColor = color;
        this.needsRebuild = true;
    }

    public void setFillStyle(int n) {
        if (n < 0) {
            this.attribs.fillStyle = 1;
        } else if (n < 41) {
            this.attribs.fillStyle = 2;
            this.attribs.fig_area_fill = n;
        } else if (n <= 56) {
            this.attribs.fillStyle = 3;
            this.attribs.fig_area_fill = n;
        } else {
            this.message("setFillStyle: value out of range: " + n);
        }
        this.needsRebuild = true;
    }

    public double minDistance(Point point, double d) {
        double d2 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length) {
            double d3;
            double d4 = Math.abs(this.wcp[n].x - point.x);
            if (d4 + (d3 = Math.abs(this.wcp[n].y - point.y)) < d2) {
                d2 = d4 + d3;
            }
            ++n;
        }
        return d2;
    }

    public double minDistanceEuclid(Point point, double d) {
        double d2 = 5;
        double d3 = this.getMinPerpendicularDistance(point);
        return d3 + d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FigPolyline with " + this.wcp.length + "points: ");
        int n = 0;
        while (n < this.wcp.length) {
            stringBuffer.append("( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void move(double d, double d2) {
        if (this.debug) {
            this.message("Polyline.move( " + d + ", " + d2 + ") ");
        }
        int n = 0;
        while (n < this.wcp.length) {
            this.wcp[n].x += d;
            this.wcp[n].y += d2;
            ++n;
        }
        this.update_bbox();
        this.needsRebuild = true;
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigPolyline.copy()...");
        }
        FigPolyline figPolyline = new FigPolyline();
        figPolyline.setPoints(this.getPoints());
        figPolyline.is_closed = this.is_closed;
        figPolyline.setAttributes(this.attribs.getClone());
        return figPolyline;
    }

    public boolean canRotate(double d) {
        return true;
    }

    public void update(FigAttribs figAttribs) {
        if (this.debug) {
            this.message("FigPolyline.update()...");
        }
        this.attribs.update(figAttribs);
        this.needsRebuild = true;
    }

    public void mirrorX(double d, double d2) {
        int n = 0;
        while (n < this.wcp.length) {
            this.wcp[n].x = (double)2 * d - this.wcp[n].x;
            ++n;
        }
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void mirrorY(double d, double d2) {
        int n = 0;
        while (n < this.wcp.length) {
            this.wcp[n].y = (double)2 * d2 - this.wcp[n].y;
            ++n;
        }
        this.update_bbox();
        this.needsRebuild = true;
    }

    public boolean supportsPointOps() {
        return true;
    }

    public Point[] getPoints() {
        return this.wcp;
    }

    public void setPoints(Point[] pointArray) {
        Point[] pointArray2 = new Point[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            pointArray2[n] = new Point(pointArray[n].x, pointArray[n].y);
            ++n;
        }
        this.wcp = pointArray2;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void insertPoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigPolyline.insertPoint()...");
        }
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (n2 < this.wcp.length) {
            if (point2.x == this.wcp[n2].x && point2.y == this.wcp[n2].y) {
                n = n2;
            }
            if (point.x == this.wcp[n2].x && point.y == this.wcp[n2].y) {
                bl = true;
            }
            ++n2;
        }
        if (n == -1) {
            this.message("FigPolyline.insertPoint(): Point wprev " + point2.toString() + "is not a Point on this polyline!");
            return;
        }
        if (bl) {
            this.message("FigPolyline.insertPoint(): Point wp " + point.toString() + "is already a Point on this polyline!");
            return;
        }
        Point[] pointArray = new Point[this.wcp.length + 1];
        int n3 = 0;
        while (n3 <= n) {
            pointArray[n3] = this.wcp[n3];
            ++n3;
        }
        pointArray[n + 1] = new Point(point.x, point.y);
        n3 = n + 2;
        while (n3 < pointArray.length) {
            pointArray[n3] = this.wcp[n3 - 1];
            ++n3;
        }
        this.wcp = pointArray;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public Point deletePoint(Point point) {
        if (this.debug) {
            this.message("FigPolyline.deletePoint()...");
        }
        if (this.wcp.length <= this.min_num_points) {
            return null;
        }
        int n = 200;
        int n2 = this.indexOfNearestNeighbor(point, n);
        if (n2 == -1) {
            this.message("FigPolyline.delete(): Point wp " + point.toString() + "is not a Point on this polyline!");
            return null;
        }
        Point point2 = n2 > 0 ? this.wcp[n2 - 1] : this.wcp[0];
        Point[] pointArray = new Point[this.wcp.length - 1];
        int n3 = 0;
        while (n3 < n2) {
            pointArray[n3] = this.wcp[n3];
            ++n3;
        }
        n3 = n2;
        while (n3 < pointArray.length) {
            pointArray[n3] = this.wcp[n3 + 1];
            ++n3;
        }
        this.wcp = pointArray;
        this.update_bbox();
        this.needsRebuild = true;
        return point2;
    }

    public int indexOfNearestNeighbor(Point point, double d) {
        int n = -1;
        double d2 = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.wcp.length) {
            double d3 = Math.abs(point.x - this.wcp[n2].x) + Math.abs(point.y - this.wcp[n2].y);
            if (d3 < d2) {
                d2 = d3;
                n = n2;
            }
            ++n2;
        }
        if (d2 > d) {
            return -1;
        }
        return n;
    }

    public void movePoint(Point point, Point point2) {
        int n;
        int n2;
        if (this.debug) {
            this.message("FigPolyline.movePoint()...");
        }
        if ((n2 = this.indexOfNearestNeighbor(point, n = 200)) == -1) {
            if (this.debug) {
                this.message("FigPolyline.movePoint(): Point wp " + point.toString() + "is not a Point on this polyline!");
            }
            if (this.debug) {
                String string = "the points are: ";
                int n3 = 0;
                while (n3 < this.wcp.length) {
                    string = string + '(' + this.wcp[n3].x + ',' + this.wcp[n3].y + ") ";
                    ++n3;
                }
                this.message(string);
            }
            return;
        }
        this.wcp[n2].x = point2.x;
        this.wcp[n2].y = point2.y;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public Point[] getMovePointNeighbors(Point point) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length) {
            double d2 = Math.abs(point.x - this.wcp[n].x) + Math.abs(point.y - this.wcp[n].y);
            if (d2 < d) {
                d = d2;
                this.min_i = n;
            }
            ++n;
        }
        Point[] pointArray = new Point[]{this.min_i > 0 ? this.wcp[this.min_i - 1] : (this.is_closed ? this.wcp[this.wcp.length - 1] : null), this.min_i < this.wcp.length - 1 ? this.wcp[this.min_i + 1] : (this.is_closed ? this.wcp[0] : null)};
        return pointArray;
    }

    public Point[] getNeighborPoints(Point point) {
        double d;
        double d2 = Double.MAX_VALUE;
        Point point2 = this.wcp[0];
        int n = 0;
        while (n < this.wcp.length - 1) {
            d = this.getSegmentDistance(this.wcp[n], this.wcp[n + 1], point);
            if (this.debug) {
                this.printCost(n, d, d2);
            }
            if (d <= d2) {
                d2 = d;
                this.min_i = n;
                point2 = this.nearerPoint(this.wcp[n], this.wcp[n + 1], point);
            }
            ++n;
        }
        if (this.is_closed) {
            d = this.getSegmentDistance(this.wcp[this.wcp.length - 1], this.wcp[0], point);
            if (this.debug) {
                this.printCost(this.wcp.length, d, d2);
            }
            if (d <= d2) {
                d2 = d;
                this.min_i = this.wcp.length - 1;
                point2 = this.nearerPoint(this.wcp[this.wcp.length - 1], this.wcp[0], point);
            }
        }
        Point[] pointArray = new Point[]{this.wcp[this.min_i], this.min_i < this.wcp.length - 1 ? this.wcp[this.min_i + 1] : this.wcp[0], point2};
        return pointArray;
    }

    protected double getSegmentDistance(Point point, Point point2, Point point3) {
        double d = point3.x - point.x;
        double d2 = point3.y - point.y;
        double d3 = point3.x - point2.x;
        double d4 = point3.y - point2.y;
        double d5 = point2.x - point.x;
        double d6 = point2.y - point.y;
        double d7 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        return d7 /= d5 * d5 + d6 * d6;
    }

    protected Point nearerPoint(Point point, Point point2, Point point3) {
        double d;
        double d2 = Math.abs(point.x - point3.x) + Math.abs(point.y - point3.y);
        if (d2 < (d = Math.abs(point2.x - point3.x) + Math.abs(point2.y - point3.y))) {
            return point;
        }
        return point2;
    }

    protected void printCost(int n, double d, double d2) {
        if (this.debug) {
            this.message("FigPolyline.getNeighborPoints(): segment " + n + " cost: " + d + " min_cost: " + d2);
        }
    }

    public double calc_dist(Point point) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length - 1) {
            double d2 = point.x - this.wcp[n].x;
            double d3 = point.y - this.wcp[n].y;
            double d4 = point.x - this.wcp[n + 1].x;
            double d5 = point.y - this.wcp[n + 1].y;
            double d6 = d2 * d2 + d3 * d3 + d4 * d4 + d5 * d5;
            if (this.debug) {
                this.message("FigPolyline.dist(): segment " + n + " cost: " + d6 + " min_cost: " + d);
            }
            if (d6 <= d) {
                d = d6;
                this.min_i = n;
            }
            ++n;
        }
        return d;
    }

    public double getMinPerpendicularDistance(Point point) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length - 1) {
            double d2 = this.getMinPerpendicularDistance(point, this.wcp[n], this.wcp[n + 1]);
            if (d2 < d) {
                d = d2;
                this.min_i = n;
            }
            ++n;
        }
        return d;
    }

    public double getMinPerpendicularDistance(Point point, Point point2, Point point3) {
        double d = Double.MAX_VALUE;
        double d2 = point3.x - point2.x;
        double d3 = point3.y - point2.y;
        double d4 = point.x - point2.x;
        double d5 = point.y - point2.y;
        double d6 = d2 * d2 + d3 * d3;
        if (d6 <= 0.0) {
            d = Math.sqrt(d4 * d4 + d5 * d5);
        } else {
            double d7 = (d4 * d2 + d5 * d3) / d6;
            double d8 = (d4 * d3 - d5 * d2) / d6;
            if (d7 >= 0.0 && d7 <= 1.0) {
                d = Math.abs(d8) * Math.sqrt(d6);
            } else if (d7 < 0.0) {
                d = Math.sqrt(d4 * d4 + d5 * d5);
            } else {
                d4 = point.x - point3.x;
                d5 = point.y - point3.y;
                d = Math.sqrt(d4 * d4 + d5 * d5);
            }
        }
        return d;
    }

    public int get_min_dist_index(Point point) {
        this.calc_dist(point);
        return this.min_i;
    }

    public Point getMinDistPoint1() {
        return this.wcp[this.min_i];
    }

    public Point getMinDistPoint2() {
        return this.wcp[this.min_i + 1];
    }

    public boolean isVisible(FigBbox figBbox) {
        return this.getBbox().isVisible(figBbox);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        this.painter = objectPainter;
    }

    public ObjectPainter getObjectPainter() {
        return this.painter;
    }

    public int getLayer() {
        return this.getAttributes().currentLayer;
    }

    public FigBbox getBbox() {
        if (this.bbox == null) {
            this.update_bbox();
        }
        return this.bbox;
    }

    public Point getPosition() {
        if (this.wcp != null && this.wcp.length > 0) {
            return this.wcp[0];
        }
        return new Point(0.0, 0.0);
    }

    public FigAttribs getAttributes() {
        return this.attribs;
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        this.needsRebuild = true;
    }

    public void updateAttributes(String string) {
        this.getAttributes().parse(string);
        this.needsRebuild = true;
    }

    public void set_debug() {
        this.debug = true;
    }

    public void reset_debug() {
        this.debug = false;
    }

    public void scale(Point point, double d, double d2) {
        Point[] pointArray = this.getPoints();
        if (pointArray != null) {
            Point[] pointArray2 = new Point[pointArray.length];
            int n = 0;
            while (n < pointArray2.length) {
                double d3 = point.x + (pointArray[n].x - point.x) * d;
                double d4 = point.y + (pointArray[n].y - point.y) * d2;
                pointArray2[n] = new Point(d3, d4);
                ++n;
            }
            this.setPoints(pointArray2);
        }
        double d5 = Math.abs(d);
        if (SetupManager.getBoolean("jfig.scaleLineWidth", true)) {
            if (d5 == 1.0 && d2 != 1.0) {
                d5 = Math.abs(d2);
            }
            this.attribs.lineWidth *= d5;
            this.attribs.dashLength *= d5;
            this.attribs.arrow_f_Width *= d5;
            this.attribs.arrow_f_Length *= d5;
            this.attribs.arrow_f_Thickness *= d5;
            this.attribs.arrow_b_Width *= d5;
            this.attribs.arrow_b_Length *= d5;
            this.attribs.arrow_b_Thickness *= d5;
        }
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void rotate(Point point, double d) throws Exception {
        Point[] pointArray;
        if (this.canRotate(d)) {
            Point[] pointArray2 = this.getPoints();
            pointArray = new Point[pointArray2.length];
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = 0;
            while (n < pointArray2.length) {
                double d4 = pointArray2[n].x - point.x;
                double d5 = pointArray2[n].y - point.y;
                double d6 = d4 * d2 - d5 * d3;
                double d7 = d4 * d3 + d5 * d2;
                pointArray[n] = new Point(d6 += point.x, d7 += point.y);
                ++n;
            }
        } else {
            throw new Exception("Rotation not supported on FigBaseObject!");
        }
        this.setPoints(pointArray);
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void showPoints() {
        this.showPoints = true;
        this.selected = false;
    }

    public void select() {
        this.selected = true;
        this.showPoints = false;
    }

    public void deselect() {
        this.selected = false;
        this.showPoints = false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public int numPoints() {
        return this.wcp.length;
    }

    public Point getNearestPoint(Point point) {
        Point point2 = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.wcp.length) {
            double d2 = this.manhattan(this.wcp[n], point);
            if (d2 < d) {
                d = d2;
                point2 = this.wcp[n];
            }
            ++n;
        }
        return point2;
    }

    public double manhattan(Point point, Point point2) {
        return Math.abs(point.x - point2.x) + Math.abs(point.y - point2.y);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public boolean getSyncRedrawFlag() {
        return this.syncRedrawFlag;
    }

    public void setSyncRedrawFlag(boolean bl) {
        this.syncRedrawFlag = bl;
    }

    public void message(String string) {
        System.err.println(string);
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.needsRebuild) {
            this.createRenderer();
        }
        this.renderer.paint(graphics, figTrafo2D);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.needsRebuild) {
            this.createRenderer();
        }
        Graphics graphics2 = graphics.create();
        this.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    public void msg(String string) {
        System.out.println(string);
    }

    private final /* synthetic */ void this() {
        this.min_num_points = 2;
        this.attribs = null;
        this.bbox = null;
        this.renderer = null;
        this.painter = null;
        this.comment = null;
        this.debug = false;
        this.syncRedrawFlag = false;
        this.selected = false;
        this.showPoints = false;
        this.visible = true;
        this.needsRebuild = true;
    }

    public FigPolyline() {
        this(0.0, 0.0, false, new FigAttribs());
    }

    public FigPolyline(double d, double d2, boolean bl, FigAttribs figAttribs) {
        this.this();
        this.wcp = new Point[]{new Point(d, d2)};
        this.attribs = figAttribs;
        this.is_closed = bl;
        if (this.is_closed && this.attribs.arrowMode != 0) {
            this.msg("-W- disabling arrows on closed polygon: " + this);
            this.attribs.arrowMode = 0;
        }
        this.visible = true;
        this.selected = false;
        this.showPoints = false;
        this.syncRedrawFlag = false;
        this.update_bbox();
        this.needsRebuild = true;
    }
}

