/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigRenderer;
import jfig.objects.Point;

public class FigEllipse
extends FigBaseobject {
    FigRenderer renderer;
    Point center;
    Point size;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createEllipseRenderer(this);
        this.needsRebuild = false;
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public Point getCenterPoint() {
        return this.center;
    }

    public Point getRadiusPoint() {
        return this.size;
    }

    public void setCenterAndRadius(Point point, Point point2) {
        this.center = new Point(point.x, point.y);
        this.size = new Point(Math.abs(point2.x), Math.abs(point2.y));
        this.update_bbox();
        this.needsRebuild = true;
    }

    public void rebuild() {
        this.createRenderer();
    }

    public void update_bbox() {
        if (this.attribs.fig_angle == 0.0) {
            this.bbox = new FigBbox(this.center.x - this.size.x, this.center.y - this.size.y, this.center.x + this.size.x, this.center.y + this.size.y);
        } else {
            double d = this.center.x;
            double d2 = this.center.x;
            double d3 = this.center.y;
            double d4 = this.center.y;
            Point[] pointArray = this.getRotatedPoints();
            int n = 0;
            while (n < pointArray.length) {
                double d5 = pointArray[n].x;
                double d6 = pointArray[n].y;
                if (d5 >= d2) {
                    d2 = d5;
                }
                if (d5 <= d) {
                    d = d5;
                }
                if (d6 >= d4) {
                    d4 = d6;
                }
                if (d6 <= d3) {
                    d3 = d6;
                }
                ++n;
            }
            this.bbox = new FigBbox(d, d3, d2, d4);
        }
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.center.x - this.size.x, this.center.y - this.size.y), new Point(this.center.x + this.size.x, this.center.y + this.size.y)};
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray == null || pointArray.length != 2) {
            this.message("-E- FigEllipse.setPoints: invalid argument:" + pointArray);
            return;
        }
        double d = Math.abs(pointArray[0].x - pointArray[1].x) / (double)2;
        double d2 = Math.abs(pointArray[0].y - pointArray[1].y) / (double)2;
        double d3 = (pointArray[0].x + pointArray[1].x) / (double)2;
        double d4 = (pointArray[0].y + pointArray[1].y) / (double)2;
        this.center = new Point(d3, d4);
        this.size = new Point(d, d2);
        this.update_bbox();
        this.needsRebuild = true;
    }

    public boolean supportsPointOps() {
        boolean bl = false;
        if (this.attribs.fig_angle == 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean isClosed() {
        return true;
    }

    public void appendPoint(Point point) {
    }

    public Point deletePoint(Point point) {
        return null;
    }

    public void insertPoint(Point point, Point point2) {
    }

    public Point[] getMovePointNeighbors(Point point) {
        double d = Math.abs(point.x - this.bbox.getXl()) < Math.abs(point.x - this.bbox.getXr()) ? this.bbox.getXr() : this.bbox.getXl();
        double d2 = Math.abs(point.y - this.bbox.getYt()) < Math.abs(point.y - this.bbox.getYb()) ? this.bbox.getYb() : this.bbox.getYt();
        Point point2 = new Point(d, d2);
        Point[] pointArray = new Point[]{point2};
        return pointArray;
    }

    public void movePoint(Point point, Point point2) {
        this.movePoint_UNROTATED_ONLY(point, point2);
    }

    private final void movePoint_UNROTATED_ONLY(Point point, Point point2) {
        double d = Math.abs(point.x - this.bbox.getXl());
        double d2 = Math.abs(point.x - this.bbox.getXr());
        double d3 = Math.abs(point.y - this.bbox.getYt());
        double d4 = Math.abs(point.y - this.bbox.getYb());
        double d5 = d < d2 ? this.bbox.getXr() : this.bbox.getXl();
        double d6 = d3 < d4 ? this.bbox.getYb() : this.bbox.getYt();
        Point point3 = new Point(d5, d6);
        this.bbox.set(point2.x, point2.y, point3.x, point3.y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        Point[] pointArray = new Point[]{point2, point3};
        this.setPoints(pointArray);
        this.needsRebuild = true;
    }

    public Point getNearestPoint(Point point) {
        Point[] pointArray = this.getRotatedPoints();
        int n = -1;
        double d = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < pointArray.length) {
            double d2 = Math.abs(pointArray[n2].x - point.x) + Math.abs(pointArray[n2].y - point.y);
            if (d2 < d) {
                d = d2;
                n = n2;
            }
            ++n2;
        }
        return new Point(pointArray[n]);
    }

    public Point getNearestPoint_OLD_NO_ROTATION(Point point) {
        double d = Math.abs(point.x - this.bbox.getXl());
        double d2 = Math.abs(point.x - this.bbox.getXr());
        double d3 = Math.abs(point.y - this.bbox.getYt());
        double d4 = Math.abs(point.y - this.bbox.getYb());
        double d5 = d > d2 ? this.bbox.getXr() : this.bbox.getXl();
        double d6 = d3 > d4 ? this.bbox.getYb() : this.bbox.getYt();
        return new Point(d5, d6);
    }

    public Point[] getNeighborPoints(Point point) {
        Point[] pointArray = new Point[]{point, point, point};
        return pointArray;
    }

    public void move(double d, double d2) {
        this.x += d;
        this.y += d2;
        this.center.x += d;
        this.center.y += d2;
        this.update_bbox();
        this.needsRebuild = true;
    }

    public FigObject copy() {
        FigEllipse figEllipse = new FigEllipse(new Point(this.center.x, this.center.y), new Point(this.center.x + this.size.x, this.center.y + this.size.y), this.attribs.getClone());
        return figEllipse;
    }

    public void mirrorX(double d, double d2) {
        Point point = this.getCenterPoint();
        Point point2 = this.getRadiusPoint();
        point.x = (double)2 * d - point.x;
        if (this.attribs.fig_angle != 0.0) {
            this.attribs.fig_angle = -this.attribs.fig_angle;
            if (this.attribs.fig_angle >= Math.PI * 2) {
                this.attribs.fig_angle -= Math.PI * 2;
            }
            if (this.attribs.fig_angle < 0.0) {
                this.attribs.fig_angle += Math.PI * 2;
            }
        }
        this.setCenterAndRadius(point, point2);
        this.needsRebuild = true;
    }

    public void mirrorY(double d, double d2) {
        Point point = this.getCenterPoint();
        Point point2 = this.getRadiusPoint();
        point.y = (double)2 * d2 - point.y;
        if (this.attribs.fig_angle != 0.0) {
            this.attribs.fig_angle = -this.attribs.fig_angle;
            if (this.attribs.fig_angle >= Math.PI * 2) {
                this.attribs.fig_angle -= Math.PI * 2;
            }
            if (this.attribs.fig_angle < 0.0) {
                this.attribs.fig_angle += Math.PI * 2;
            }
        }
        this.setCenterAndRadius(point, point2);
        this.needsRebuild = true;
    }

    public void update(FigAttribs figAttribs) {
        this.attribs.update(figAttribs);
        this.update_bbox();
        this.needsRebuild = true;
    }

    public boolean canRotate(double d) {
        return true;
    }

    public void rotate(Point point, double d) {
        try {
            Point point2 = this.getCenterPoint();
            Point point3 = this.getRadiusPoint();
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = point2.x - point.x;
            double d5 = point2.y - point.y;
            double d6 = d4 * d2 - d5 * d3 + point.x + 0.5;
            double d7 = d4 * d3 + d5 * d2 + point.y + 0.5;
            this.attribs.fig_angle -= d;
            this.setCenterAndRadius(new Point(d6, d7), point3);
            this.needsRebuild = true;
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            throwable.printStackTrace();
        }
    }

    public void setLayer(int n) {
        this.attribs.currentLayer = n;
        this.needsRebuild = true;
    }

    public void setLineColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
        this.needsRebuild = true;
    }

    public void setLineWidth(int n) {
        this.attribs.setFigLineWidth(n);
        this.needsRebuild = true;
    }

    public void setLineStyle(int n) {
        this.attribs.lineStyle = n;
        this.needsRebuild = true;
    }

    public void setFillColor(Color color) {
        int n;
        this.attribs.fig_fill_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.fillColor = color;
        this.needsRebuild = true;
    }

    public void setFillStyle(int n) {
        if (n < 0) {
            this.attribs.fillStyle = 1;
        } else if (n < 41) {
            this.attribs.fillStyle = 2;
            this.attribs.fig_area_fill = n;
        } else if (n <= 56) {
            this.attribs.fillStyle = 3;
            this.attribs.fig_area_fill = n;
        } else {
            this.message("setFillStyle: value out of range: " + n);
        }
        this.needsRebuild = true;
    }

    public Point[] getRotatedPoints() {
        double d = -this.attribs.fig_angle;
        if (d == 0.0) {
            return new Point[]{new Point(this.center.x - this.size.x, this.center.y - this.size.y), new Point(this.center.x + this.size.x, this.center.y - this.size.y), new Point(this.center.x + this.size.x, this.center.y + this.size.y), new Point(this.center.x - this.size.x, this.center.y + this.size.y)};
        }
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = new Point[]{new Point(-this.size.x, -this.size.y), new Point(this.size.x, -this.size.y), new Point(-this.size.x, this.size.y), new Point(this.size.x, this.size.y)};
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 0;
        while (n < pointArray2.length) {
            double d4 = pointArray2[n].x;
            double d5 = pointArray2[n].y;
            double d6 = d4 * d2 - d5 * d3;
            double d7 = d4 * d3 + d5 * d2;
            pointArray[n] = new Point(d6 += this.center.x, d7 += this.center.y);
            ++n;
        }
        return pointArray;
    }

    public Point getSizeFromMousePosition(Point point) {
        double d = point.x - this.center.x;
        double d2 = point.y - this.center.y;
        double d3 = this.attribs.fig_angle;
        double d4 = d * Math.cos(d3) - d2 * Math.sin(d3);
        double d5 = d * Math.sin(d3) + d2 * Math.cos(d3);
        return new Point(d4, d5);
    }

    public double minDistance(Point point, double d) {
        if (this.attribs.fig_angle == 0.0) {
            return this.bbox.minDistanceInside(point);
        }
        double d2 = Double.MAX_VALUE;
        Point[] pointArray = this.getRotatedPoints();
        int n = 0;
        while (n < pointArray.length) {
            double d3 = Math.abs(point.x - pointArray[n].x) + Math.abs(point.y - pointArray[n].y);
            if (d3 <= d2) {
                d2 = d3;
            }
            ++n;
        }
        return d2;
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.needsRebuild) {
            this.createRenderer();
        }
        this.renderer.paint(graphics, figTrafo2D);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.needsRebuild) {
            this.createRenderer();
        }
        Graphics graphics2 = graphics.create();
        this.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    public String toString() {
        String string = "FigEllipse  center " + this.x + ',' + this.y + " radii " + this.size.x + ',' + this.size.y + " layer " + this.attribs.currentLayer + " colors " + this.attribs.lineColor + ' ' + this.attribs.fillColor;
        return string;
    }

    public FigEllipse() {
        this(new Point(0.0, 0.0), new Point(2400.0, 2400.0), new FigAttribs());
    }

    public FigEllipse(Point point, Point point2, FigAttribs figAttribs) {
        this.center = new Point(point.x, point.y);
        this.size = new Point(Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
        this.x = this.center.x;
        this.y = this.center.y;
        this.attribs = figAttribs;
        this.update_bbox();
        this.needsRebuild = true;
    }
}

