/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Graphics;
import java.awt.Rectangle;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigObjectVisitor;
import jfig.objects.ListNode;
import jfig.objects.Point;

public class FigCompound
extends FigBaseobject {
    FigObjectList members = new FigObjectList();

    public void addMember(FigObject figObject) {
        this.members.insert(figObject);
        this.update_bbox();
    }

    public void fastAddMember(FigObject figObject) {
        this.members.insert(figObject);
    }

    public boolean deleteMember(FigObject figObject) {
        boolean bl = this.members.delete(figObject);
        if (bl) {
            this.update_bbox();
        }
        return bl;
    }

    public boolean deleteAllMembers() {
        boolean bl = this.members.elements().hasMoreElements();
        this.members = new FigObjectList();
        this.update_bbox();
        return bl;
    }

    public boolean isMember(FigObject figObject) {
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            if (listNode.obj == figObject) {
                return true;
            }
            listNode = this.members.get_next(listNode);
        }
        return false;
    }

    public void update_bbox() {
        ListNode listNode;
        if (this.members.get_first() == null) {
            this.bbox = new FigBbox(0.0, 0.0, 0.0, 0.0);
        } else {
            this.bbox = new FigBbox(this.members.get_first().obj.getBbox());
            listNode = this.members.get_first();
            while (listNode != null) {
                this.bbox = this.bbox.union(listNode.obj.getBbox());
                listNode = this.members.get_next(listNode);
            }
        }
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        listNode = this.members.get_last();
        if (listNode != null) {
            this.attribs.currentLayer = listNode.obj.getAttributes().currentLayer;
        }
    }

    public FigObjectList getMembers() {
        return this.members;
    }

    public void move(double d, double d2) {
        super.move(d, d2);
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.move(d, d2);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void mirrorX(double d, double d2) {
        double d3;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.mirrorX(d, d2);
            listNode = this.members.get_next(listNode);
        }
        this.x = d3 = (double)2 * d - this.x;
        this.update_bbox();
    }

    public void mirrorY(double d, double d2) {
        double d3;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.mirrorY(d, d2);
            listNode = this.members.get_next(listNode);
        }
        this.y = d3 = (double)2 * d2 - this.y;
        this.update_bbox();
    }

    public void scale(Point point, double d, double d2) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.scale(point, d, d2);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void update(FigAttribs figAttribs) {
        if (this.members == null) {
            return;
        }
        this.attribs.update(figAttribs);
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.update(figAttribs);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void rebuild() {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.rebuild();
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public void changeLayerRecursively(FigAttribs figAttribs) {
        ListNode listNode = this.members.get_last();
        int n = figAttribs.currentLayer;
        int n2 = 0;
        int n3 = 0;
        if (listNode != null) {
            n2 = listNode.obj.getAttributes().currentLayer;
        }
        n3 = n - n2;
        listNode = this.members.get_first();
        while (listNode != null) {
            FigObject figObject = listNode.obj;
            FigAttribs figAttribs2 = figObject.getAttributes();
            figAttribs2.currentLayer += n3;
            if (figObject instanceof FigCompound) {
                ((FigCompound)figObject).changeLayerRecursively(figAttribs);
            }
            listNode = this.members.get_next(listNode);
        }
    }

    public FigObject copy() {
        if (this.members == null) {
            return null;
        }
        FigCompound figCompound = new FigCompound();
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            figCompound.fastAddMember(listNode.obj.copy());
            listNode = this.members.get_next(listNode);
        }
        figCompound.update_bbox();
        return figCompound;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.setVisible(bl);
            listNode = this.members.get_next(listNode);
        }
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.setObjectPainter(objectPainter);
            listNode = this.members.get_next(listNode);
        }
        this.painter = objectPainter;
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.visible) {
            return;
        }
        if (this.members == null) {
            return;
        }
        FigBbox figBbox = null;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            figBbox = new FigBbox(figTrafo2D.getWorldCoords(rectangle.x, rectangle.y), figTrafo2D.getWorldCoords(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (rectangle == null) {
            bl = true;
        }
        boolean bl2 = bl;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            ++n;
            if (listNode.obj.isVisible() && (bl2 || listNode.obj.isVisible(figBbox))) {
                listNode.obj.paint(graphics, figTrafo2D);
                ++n2;
            }
            listNode = this.members.get_next(listNode);
        }
        if (this.showPoints || this.selected) {
            super.paintMarkers(graphics, figTrafo2D);
        }
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.members == null) {
            return;
        }
        Object object = this.members.get_first();
        while (object != null) {
            Graphics graphics2 = graphics.create();
            ((ListNode)object).obj.paintSave(graphics2, figTrafo2D);
            graphics2.dispose();
            object = this.members.get_next((ListNode)object);
        }
        object = graphics.create();
        super.paintMarkers((Graphics)object, figTrafo2D);
        ((Graphics)object).dispose();
    }

    public void paintInverse(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_last();
        while (listNode != null) {
            listNode.obj.paint(graphics, figTrafo2D);
            listNode = this.members.get_prev(listNode);
        }
        if (this.showPoints || this.selected) {
            super.paintMarkers(graphics, figTrafo2D);
        }
    }

    public boolean canRotate(double d) {
        if (this.members == null) {
            return false;
        }
        boolean bl = true;
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            boolean bl2 = false;
            if (bl && listNode.obj.canRotate(d)) {
                bl2 = true;
            }
            bl = bl2;
            listNode = this.members.get_next(listNode);
        }
        return bl;
    }

    public void rotate(Point point, double d) throws Exception {
        if (this.members == null) {
            return;
        }
        ListNode listNode = this.members.get_first();
        while (listNode != null) {
            listNode.obj.rotate(point, d);
            listNode = this.members.get_next(listNode);
        }
        this.update_bbox();
    }

    public double minDistanceEuclid(Point point, double d) {
        double d2 = this.bbox.minDistance(point);
        if (d > 0.0 && this.bbox.isInside(point)) {
            d2 = Math.min(d2, 0.4 * d);
        }
        return d2;
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
        if (this.members != null) {
            ListNode listNode = this.members.get_first();
            while (listNode != null) {
                figObjectVisitor.visit(listNode.obj);
                listNode = this.members.get_next(listNode);
            }
        }
    }

    public String toString() {
        String string = "FigCompound at (" + this.x + ", " + this.y + ") on layer " + this.getLayer();
        if (this.members != null) {
            ListNode listNode = this.members.get_first();
            while (listNode != null) {
                string = string + "\n..." + listNode.obj.toString();
                listNode = this.members.get_next(listNode);
            }
        }
        return string;
    }

    public FigCompound() {
        this.update_bbox();
    }
}

