/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Rectangle;
import jfig.canvas.FigTrafo2D;
import jfig.objects.Point;

public final class FigBbox {
    private double xl;
    private double yt;
    private double xr;
    private double yb;

    public final void set(double d, double d2, double d3, double d4) {
        this.xl = Math.min(d, d3);
        this.xr = Math.max(d, d3);
        this.yt = Math.min(d2, d4);
        this.yb = Math.max(d2, d4);
    }

    public final void set(FigBbox figBbox) {
        this.xl = figBbox.xl;
        this.yt = figBbox.yt;
        this.xr = figBbox.xr;
        this.yb = figBbox.yb;
    }

    public final FigBbox get() {
        return this;
    }

    public final double getXl() {
        return this.xl;
    }

    public final double getYt() {
        return this.yt;
    }

    public final double getXr() {
        return this.xr;
    }

    public final double getYb() {
        return this.yb;
    }

    public final void move(double d, double d2) {
        this.xl += d;
        this.xr += d;
        this.yt += d2;
        this.yb += d2;
    }

    public final boolean isInside(Point point) {
        double d = point.getX();
        double d2 = point.getY();
        boolean bl = false;
        if (d >= this.xl && d <= this.xr && d2 >= this.yt && d2 <= this.yb) {
            bl = true;
        }
        return bl;
    }

    public final boolean inside(double d, double d2) {
        boolean bl = false;
        if (this.xl <= d && d <= this.xr && this.yt <= d2 && d2 <= this.yb) {
            bl = true;
        }
        return bl;
    }

    public final boolean inside(FigBbox figBbox) {
        boolean bl = false;
        if (this.xl >= figBbox.xl && this.xr <= figBbox.xr && this.yt >= figBbox.yt && this.yb <= figBbox.yb) {
            bl = true;
        }
        return bl;
    }

    public final boolean isVisible(FigBbox figBbox) {
        boolean bl = false;
        if (this.xl < figBbox.xr && this.xr > figBbox.xl && this.yt < figBbox.yb && this.yb > figBbox.yt) {
            bl = true;
        }
        return bl;
    }

    public final boolean isOnBorder(Point point, double d) {
        if (Math.abs(point.getY() - this.yt) < d || Math.abs(point.getY() - this.yb) < d) {
            boolean bl = false;
            if (point.getX() > this.xl && point.getX() < this.xr) {
                bl = true;
            }
            return bl;
        }
        if (Math.abs(point.getX() - this.xl) < d || Math.abs(point.getX() - this.xr) < d) {
            boolean bl = false;
            if (point.getY() > this.yt && point.getY() < this.yb) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final FigBbox union(FigBbox figBbox) {
        FigBbox figBbox2 = new FigBbox(this.xl, this.yt, this.xr, this.yb);
        figBbox2.xl = Math.min(this.xl, figBbox.xl);
        figBbox2.xr = Math.max(this.xr, figBbox.xr);
        figBbox2.yt = Math.min(this.yt, figBbox.yt);
        figBbox2.yb = Math.max(this.yb, figBbox.yb);
        return figBbox2;
    }

    public static final FigBbox union(FigBbox figBbox, FigBbox figBbox2) {
        FigBbox figBbox3 = new FigBbox(0.0, 0.0, 0.0, 0.0);
        figBbox3.xl = Math.min(figBbox.xl, figBbox2.xl);
        figBbox3.xr = Math.max(figBbox.xr, figBbox2.xr);
        figBbox3.yt = Math.min(figBbox.yt, figBbox2.yt);
        figBbox3.yb = Math.max(figBbox.yb, figBbox2.yb);
        return figBbox3;
    }

    public final double minManhattanDistance(FigBbox figBbox) {
        double d = figBbox.getXl();
        double d2 = figBbox.getXr();
        double d3 = figBbox.getYt();
        double d4 = figBbox.getYb();
        double d5 = 0.0;
        double d6 = 0.0;
        d5 = d >= this.xr ? d - this.xr : (d2 <= this.xl ? this.xl - d2 : 0.0);
        d6 = d3 >= this.yb ? d3 - this.yb : (d4 <= this.yt ? this.yt - d4 : 0.0);
        return d5 + d6;
    }

    public final double minDistance(Point point) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = Math.min(Math.abs(this.xl - d), Math.abs(this.xr - d));
        double d4 = Math.min(Math.abs(this.yt - d2), Math.abs(this.yb - d2));
        return d3 + d4;
    }

    public final double minDistanceInsideZero(Point point) {
        if (this.isInside(point)) {
            return 0.0;
        }
        return this.minDistance(point);
    }

    public final double minDistanceInside(Point point) {
        double d = this.minDistance(point);
        if (this.isInside(point)) {
            return 0.9 * d;
        }
        return d;
    }

    public final Point getNearestCorner(Point point) {
        double d = Math.abs(point.getX() - this.xl);
        double d2 = Math.abs(point.getX() - this.xr);
        double d3 = Math.abs(point.getY() - this.yt);
        double d4 = Math.abs(point.getY() - this.yb);
        double d5 = d > d2 ? this.xr : this.xl;
        double d6 = d3 > d4 ? this.yb : this.yt;
        return new Point(d5, d6);
    }

    public final Point getOppositeCorner(Point point) {
        double d = Math.abs(point.getX() - this.xl);
        double d2 = Math.abs(point.getX() - this.xr);
        double d3 = Math.abs(point.getY() - this.yt);
        double d4 = Math.abs(point.getY() - this.yb);
        double d5 = d < d2 ? this.xr : this.xl;
        double d6 = d3 < d4 ? this.yb : this.yt;
        return new Point(d5, d6);
    }

    public final Point getCenterPoint() {
        return new Point(0.5 * (this.xl + this.xr), 0.5 * (this.yt + this.yb));
    }

    public final Rectangle getRectangle() {
        return new Rectangle((int)this.xl, (int)this.yt, (int)(this.xr - this.xl), (int)(this.yb - this.yt));
    }

    public final Rectangle getScreenCoordsRectangle(FigTrafo2D figTrafo2D) {
        int n = figTrafo2D.wc_to_screen_x(this.xl);
        int n2 = figTrafo2D.wc_to_screen_y(this.yt);
        int n3 = (int)figTrafo2D.wc_to_screen(this.xr - this.xl);
        int n4 = (int)figTrafo2D.wc_to_screen(this.yb - this.yt);
        return new Rectangle(n, n2, n3, n4);
    }

    public final String toString() {
        String string = "bbox: (" + this.xl + ", " + this.yt + ") (" + this.xr + ", " + this.yb + ") ";
        return string;
    }

    public FigBbox(double d, double d2, double d3, double d4) {
        this.xl = Math.min(d, d3);
        this.xr = Math.max(d, d3);
        this.yt = Math.min(d2, d4);
        this.yb = Math.max(d2, d4);
    }

    public FigBbox(Point point, Point point2) {
        this.xl = Math.min(point.getX(), point2.getX());
        this.xr = Math.max(point.getX(), point2.getX());
        this.yt = Math.min(point.getY(), point2.getY());
        this.yb = Math.max(point.getY(), point2.getY());
    }

    public FigBbox(FigBbox figBbox) {
        this.xl = figBbox.xl;
        this.xr = figBbox.xr;
        this.yt = figBbox.yt;
        this.yb = figBbox.yb;
    }
}

