/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.gui.ConsoleMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectVisitor;
import jfig.objects.Point;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigBaseobject
implements FigObject {
    protected static ConsoleMessage printer = null;
    protected FigAttribs attribs;
    protected String comment;
    protected FigBbox bbox;
    protected double x;
    protected double y;
    protected boolean debug;
    protected boolean selected;
    protected boolean showPoints;
    protected boolean syncRedrawFlag;
    protected boolean needsRebuild;
    protected boolean visible;
    protected ObjectPainter painter;

    public void createRenderer() {
        Thread.dumpStack();
    }

    public void setObjectPainter(ObjectPainter objectPainter) {
        this.painter = objectPainter;
    }

    public ObjectPainter getObjectPainter() {
        return this.painter;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public FigAttribs getAttributes() {
        return this.attribs;
    }

    public void setAttributes(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        this.needsRebuild = true;
    }

    public void updateAttributes(String string) {
        this.getAttributes().parse(string);
        this.needsRebuild = true;
    }

    public int getLayer() {
        return this.attribs.currentLayer;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public FigBbox getBbox() {
        return this.bbox;
    }

    public void move(double d, double d2) {
        this.x += d;
        this.y += d2;
        this.needsRebuild = true;
    }

    public void mirrorX(double d, double d2) {
        this.message("mirrorX() not supported by " + this.toString());
        this.needsRebuild = true;
    }

    public void mirrorY(double d, double d2) {
        this.message("mirrorY() not supported by " + this.toString());
        this.needsRebuild = true;
    }

    public void scale(Point point, double d, double d2) {
        Point[] pointArray = this.getPoints();
        if (pointArray != null) {
            Point[] pointArray2 = new Point[pointArray.length];
            int n = 0;
            while (n < pointArray2.length) {
                double d3 = point.x + (pointArray[n].x - point.x) * d;
                double d4 = point.y + (pointArray[n].y - point.y) * d2;
                pointArray2[n] = new Point(d3, d4);
                ++n;
            }
            this.setPoints(pointArray2);
        }
        if (SetupManager.getBoolean("jfig.scaleLineWidth", true)) {
            d = Math.abs(d);
            this.attribs.lineWidth *= d;
            this.attribs.dashLength *= d;
            this.attribs.arrow_f_Width *= d;
            this.attribs.arrow_f_Length *= d;
            this.attribs.arrow_f_Thickness *= d;
            this.attribs.arrow_b_Width *= d;
            this.attribs.arrow_b_Length *= d;
            this.attribs.arrow_b_Thickness *= d;
        }
        this.needsRebuild = true;
    }

    public void rotate(Point point, double d) throws Exception {
        Point[] pointArray;
        if (this.canRotate(d)) {
            Point[] pointArray2 = this.getPoints();
            pointArray = new Point[pointArray2.length];
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = 0;
            while (n < pointArray2.length) {
                double d4 = pointArray2[n].x - point.x;
                double d5 = pointArray2[n].y - point.y;
                double d6 = d4 * d2 - d5 * d3;
                double d7 = d4 * d3 + d5 * d2;
                pointArray[n] = new Point(d6 += point.x, d7 += point.y);
                ++n;
            }
        } else {
            throw new Exception("Rotation not supported on FigBaseObject!");
        }
        this.setPoints(pointArray);
        this.needsRebuild = true;
    }

    public boolean canRotate(double d) {
        return false;
    }

    public void update(FigAttribs figAttribs) {
        this.message("update() not supported by " + this.toString());
        this.needsRebuild = true;
    }

    public void rebuild() {
        this.message("-W- rebuild() not implemented by " + this.toString());
        this.createRenderer();
    }

    public FigObject copy() {
        return null;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void showPoints() {
        this.showPoints = true;
        this.selected = false;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public void select() {
        this.showPoints = false;
        this.selected = true;
    }

    public void deselect() {
        this.showPoints = false;
        this.selected = false;
    }

    public boolean getSyncRedrawFlag() {
        return this.syncRedrawFlag;
    }

    public void setSyncRedrawFlag(boolean bl) {
        this.syncRedrawFlag = bl;
    }

    public boolean supportsPointOps() {
        return false;
    }

    public int numPoints() {
        if (this.getPoints() != null) {
            return this.getPoints().length;
        }
        return 0;
    }

    public boolean isClosed() {
        return false;
    }

    public Point[] getPoints() {
        return null;
    }

    public void setPoints(Point[] pointArray) {
        this.message("FigBaseobject.setPoints(): You should not call this!");
        this.needsRebuild = true;
    }

    public static Point[] clonePoints(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            pointArray2[n2] = new Point(point.x, point.y);
            ++n2;
        }
        return pointArray2;
    }

    public void appendPoint(Point point) {
        this.message("FigBaseobject.appendPoint(): You should not call this!");
        this.needsRebuild = true;
    }

    public void movePoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigBaseobject.movePoint(): You should not call this!");
        }
        this.needsRebuild = true;
    }

    public void insertPoint(Point point, Point point2) {
        if (this.debug) {
            this.message("FigBaseobject.insertPoint(): You should not call this!");
        }
        this.needsRebuild = true;
    }

    public Point deletePoint(Point point) {
        this.needsRebuild = true;
        if (this.debug) {
            this.message("FigBaseobject.deletePoint(): You should not call this!");
        }
        return null;
    }

    public Point getNearestPoint(Point point) {
        Point[] pointArray = this.getPoints();
        if (pointArray == null) {
            return null;
        }
        Point point2 = null;
        double d = 1.0E10;
        int n = 0;
        while (n < pointArray.length) {
            double d2 = this.manhattan(pointArray[n], point);
            if (d2 < d) {
                d = d2;
                point2 = pointArray[n];
            }
            ++n;
        }
        return new Point(point2);
    }

    public double manhattan(Point point, Point point2) {
        return Math.abs(point.x - point2.x) + Math.abs(point.y - point2.y);
    }

    public Point[] getNeighborPoints(Point point) {
        if (this.debug) {
            this.message("FigBaseobject.getNeighborPoints(): You should not call this!");
        }
        return null;
    }

    public Point[] getMovePointNeighbors(Point point) {
        if (this.debug) {
            this.message("FigBaseobject.getMovePointNeighbors(): You should not call this!");
        }
        return null;
    }

    public double minDistance(Point point, double d) {
        return this.bbox.minDistanceInside(point);
    }

    public double minDistanceEuclid(Point point, double d) {
        return this.minDistance(point, d);
    }

    public String getText() {
        return "";
    }

    public void setText(String string) {
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.visible) {
            return;
        }
        if (this.showPoints || this.selected) {
            this.paintMarkers(graphics, figTrafo2D);
        }
    }

    public void paintMarkers(Graphics graphics, FigTrafo2D figTrafo2D) {
        Rectangle rectangle = this.getBbox().getScreenCoordsRectangle(figTrafo2D);
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        if (this.showPoints) {
            graphics.setColor(Color.black);
            graphics.fillRect(n - 2, n3 - 2, 5, 5);
            graphics.fillRect(n2 - 2, n3 - 2, 5, 5);
            graphics.fillRect(n - 2, n4 - 2, 5, 5);
            graphics.fillRect(n2 - 2, n4 - 2, 5, 5);
            graphics.setColor(Color.white);
            graphics.fillRect(n - 1, n3 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            graphics.fillRect(n - 1, n4 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n4 - 1, 3, 3);
            graphics.setColor(Color.black);
        } else if (this.selected) {
            graphics.setColor(Color.white);
            graphics.fillRect(n - 2, n3 - 2, 5, 5);
            graphics.fillRect(n2 - 2, n3 - 2, 5, 5);
            graphics.fillRect(n - 2, n4 - 2, 5, 5);
            graphics.fillRect(n2 - 2, n4 - 2, 5, 5);
            graphics.setColor(Color.black);
            graphics.fillRect(n - 1, n3 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            graphics.fillRect(n - 1, n4 - 1, 3, 3);
            graphics.fillRect(n2 - 1, n4 - 1, 3, 3);
        }
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        Graphics graphics2 = graphics.create();
        this.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public boolean isVisible(FigBbox figBbox) {
        return this.bbox.isVisible(figBbox);
    }

    public void message(String string) {
        if (printer != null) {
            printer.consoleMessage(string);
        } else {
            System.err.println(string);
        }
    }

    public void setConsole(ConsoleMessage consoleMessage) {
        printer = consoleMessage;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    public String toString() {
        String string = "FigBaseobject at (" + this.x + ", " + this.y + ") on layer " + this.attribs.currentLayer;
        return string;
    }

    private final /* synthetic */ void this() {
        this.syncRedrawFlag = false;
        this.needsRebuild = true;
        this.painter = null;
    }

    public FigBaseobject() {
        this.this();
        this.x = 0.0;
        this.y = 0.0;
        this.debug = false;
        this.attribs = new FigAttribs();
        this.bbox = new FigBbox(this.x, this.y, this.x, this.y);
        this.debug = false;
        this.selected = false;
        this.showPoints = false;
        this.visible = true;
        this.needsRebuild = true;
    }
}

