/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigPolyline;
import jfig.objects.Point;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigArc
extends FigPolyline {
    public static final double r = Math.PI / 180;
    public static final int ccw = 0;
    public static final int cw = 1;
    public static final int PIE_WEDGE = 2;
    public static final int OPEN_ARC = 1;
    protected Point[] wcp_arc;
    protected double radius;
    protected int direction;
    protected int type;
    private double alpha0;
    private double alpha1;
    private double alpha2;
    private double dalpha21;
    private double dalpha10;
    private double center_x;
    private double center_y;
    private boolean singular;
    Point[] pp;

    public void createRenderer() {
        if (this.wcp_arc == null) {
            this.create_wcp_arc();
        }
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createArcRenderer(this);
        this.needsRebuild = false;
    }

    private final void create_wcp_arc() {
        if (this.wcp.length == 3) {
            if (this.singular) {
                this.wcp_arc = new Point[3];
                this.wcp_arc[0] = this.wcp[0];
                this.wcp_arc[1] = this.wcp[1];
                this.wcp_arc[2] = this.wcp[2];
            } else {
                this.build_PP();
            }
        } else {
            Thread.dumpStack();
        }
    }

    public FigBbox getBbox() {
        if (this.wcp_arc == null || this.needsRebuild) {
            this.rebuild();
        }
        return this.bbox;
    }

    private final void calculatePreciseBoundingBox() {
        if (this.wcp_arc == null) {
            this.rebuild();
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        int n = 0;
        while (n < this.wcp_arc.length) {
            if (this.wcp_arc[n].x > d2) {
                d2 = this.wcp_arc[n].x;
            }
            if (this.wcp_arc[n].x < d) {
                d = this.wcp_arc[n].x;
            }
            if (this.wcp_arc[n].y > d4) {
                d4 = this.wcp_arc[n].y;
            }
            if (this.wcp_arc[n].y < d3) {
                d3 = this.wcp_arc[n].y;
            }
            ++n;
        }
        this.bbox = new FigBbox(d, d3, d2, d4);
    }

    public void update_bbox() {
        if (this.wcp == null || this.wcp.length != 3) {
            this.bbox = new FigBbox(0.0, 0.0, 0.0, 0.0);
        } else {
            this.build_arc();
            this.create_wcp_arc();
            this.calculatePreciseBoundingBox();
        }
    }

    public Point getCenter() {
        return new Point(this.center_x, this.center_y);
    }

    public double getRadius() {
        return this.radius;
    }

    public int getDirection() {
        return this.direction;
    }

    public Point[] getInterpolatedArcPoints() {
        return this.wcp_arc;
    }

    public void setPoints(Point[] pointArray) {
        this.wcp[0] = new Point(pointArray[0].x, pointArray[0].y);
        this.wcp[1] = new Point(pointArray[1].x, pointArray[1].y);
        this.wcp[2] = new Point(pointArray[2].x, pointArray[2].y);
        this.update_bbox();
        this.needsRebuild = true;
    }

    protected boolean build_arc() {
        double d = this.wcp[2].x - this.wcp[1].x;
        double d2 = this.wcp[2].y - this.wcp[1].y;
        double d3 = this.wcp[1].x - this.wcp[0].x;
        double d4 = this.wcp[1].y - this.wcp[0].y;
        if (this.debug) {
            this.message("build_arc: d21=(" + d + ',' + d2 + ") d10=(" + d3 + ',' + d4 + ") ");
        }
        double d5 = this.wcp[1].x + 0.5 * d;
        double d6 = this.wcp[1].y + 0.5 * d2;
        double d7 = this.wcp[0].x + 0.5 * d3;
        double d8 = this.wcp[0].y + 0.5 * d4;
        double d9 = d * d4 - d2 * d3;
        if (d9 == 0.0) {
            this.singular = true;
            return false;
        }
        double d10 = (d2 * (d8 - d6) - d * (d5 - d7)) / d9;
        double d11 = d7 - d10 * d4;
        double d12 = d8 + d10 * d3;
        this.center_x = d11;
        this.center_y = d12;
        this.radius = Math.sqrt((this.wcp[0].y - this.center_y) * (this.wcp[0].y - this.center_y) + (this.wcp[0].x - this.center_x) * (this.wcp[0].x - this.center_x));
        this.alpha0 = Math.atan2(this.wcp[0].y - this.center_y, this.wcp[0].x - this.center_x);
        this.alpha1 = Math.atan2(this.wcp[1].y - this.center_y, this.wcp[1].x - this.center_x);
        this.alpha2 = Math.atan2(this.wcp[2].y - this.center_y, this.wcp[2].x - this.center_x);
        double d13 = this.alpha0;
        double d14 = this.alpha1;
        double d15 = this.alpha2;
        if (d13 < 0.0) {
            d13 += Math.PI * 2;
        }
        if (d14 < 0.0) {
            d14 += Math.PI * 2;
        }
        if (d15 < 0.0) {
            d15 += Math.PI * 2;
        }
        if ((d14 -= d13) < 0.0) {
            d14 += Math.PI * 2;
        }
        if ((d15 -= d13) < 0.0) {
            d15 += Math.PI * 2;
        }
        this.direction = d15 > d14 ? 0 : 1;
        if (this.debug) {
            this.message("build_arc: alpha0, alpha1, alpha2, direction: " + this.alpha0 * (Math.PI / 180) + ", " + this.alpha1 * (Math.PI / 180) + ", " + this.alpha2 * (Math.PI / 180) + this.direction);
        }
        if (this.debug) {
            this.message("FigArc center=(" + this.center_x + ", " + this.center_y + ") radius= " + this.radius);
        }
        this.singular = false;
        return true;
    }

    private final void build_PP() {
        double d = this.alpha0;
        double d2 = this.alpha2;
        if (this.direction == 0 && d2 < d) {
            d2 += Math.PI * 2;
        }
        if (this.direction == 1 && d2 > d) {
            d2 -= Math.PI * 2;
        }
        double d3 = d2 - d;
        double d4 = SetupManager.getDouble("jfig.objects.FigArc.nlines", 100.0);
        int n = (int)(d4 * this.radius / 2400.0 * Math.abs(d3) / (Math.PI * 2));
        n = Math.max(10, n);
        n = Math.min(n, 500);
        this.pp = new Point[n + 2];
        int n2 = 0;
        while (n2 <= n) {
            this.pp[n2] = new Point(this.center_x + this.radius * Math.cos(d) + 0.5, this.center_y + this.radius * Math.sin(d) + 0.5);
            d += d3 / (double)n;
            if (this.debug) {
                this.message("FigArc.build_PP() alpha=" + d + " pp[" + n2 + "]= (" + this.pp[n2].x + ", " + this.pp[n2].y + ") ");
            }
            ++n2;
        }
        if (this.attribs.fillStyle != 1) {
            this.wcp_arc = new Point[n + 2];
            n2 = 0;
            while (n2 <= n) {
                this.wcp_arc[n2] = this.pp[n2];
                ++n2;
            }
            this.wcp_arc[n + 1] = this.getCenter();
        } else {
            this.wcp_arc = new Point[n + 1];
            n2 = 0;
            while (n2 <= n) {
                this.wcp_arc[n2] = this.pp[n2];
                ++n2;
            }
        }
    }

    public String toString() {
        String string = "FigArc with " + this.wcp.length + " control points: ";
        int n = 0;
        while (n < this.wcp.length) {
            string = string + "( " + this.wcp[n].x + ", " + this.wcp[n].y + "), ";
            ++n;
        }
        string = string + " center at (" + this.center_x + ", " + this.center_y + ") ";
        return string;
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigArc.copy()...");
        }
        FigArc figArc = new FigArc(this.wcp[0], this.wcp[1], this.wcp[2], this.attribs.getClone());
        return figArc;
    }

    public void appendPoint(Point point) {
    }

    public void insertPoint(Point point, Point point2) {
    }

    public Point deletePoint(Point point) {
        return null;
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    private final /* synthetic */ void this() {
        this.direction = 0;
        this.type = 1;
        this.singular = false;
    }

    public FigArc() {
        this(new Point(0.0, 0.0), new Point(0.0, 0.0), new Point(0.0, 0.0), new FigAttribs());
    }

    public FigArc(Point point, Point point2, Point point3, FigAttribs figAttribs) {
        super(point.x, point.y, false, figAttribs);
        this.this();
        this.min_num_points = 3;
        this.wcp = new Point[3];
        this.wcp[0] = new Point(point.x, point.y);
        this.wcp[1] = new Point(point2.x, point2.y);
        this.wcp[2] = new Point(point3.x, point3.y);
        this.center_x = point.x;
        this.center_y = point.y;
        this.update_bbox();
        this.needsRebuild = true;
    }
}

