/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jfig.canvas.FigTrafo2D;
import jfig.gui.FontCache;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.FigText;
import jfig.objects.Point;
import jfig.utils.SetupManager;

public class FigTextRenderer
implements FigRenderer {
    FigText textObject;
    boolean showBoundingBoxes;
    double[] lrwad;

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (SetupManager.getBoolean("jfig.java2d.FigTextRenderer.new", false)) {
            this.paintInWorldCoords(graphics, figTrafo2D);
        } else {
            this.paintInScreenCoords(graphics, figTrafo2D);
        }
    }

    private static final double[] toLRWAD(Rectangle2D rectangle2D, FigAttribs figAttribs) {
        double[] dArray = new double[5];
        dArray[2] = rectangle2D.getWidth();
        dArray[3] = rectangle2D.getY();
        dArray[4] = rectangle2D.getHeight() + rectangle2D.getY();
        if (figAttribs.textAlign == 1) {
            dArray[0] = 0.0;
            dArray[1] = rectangle2D.getWidth();
        } else if (figAttribs.textAlign == 3) {
            dArray[0] = -rectangle2D.getWidth();
            dArray[1] = 0.0;
        } else if (figAttribs.textAlign == 2) {
            dArray[0] = -rectangle2D.getWidth() / (double)2;
            dArray[1] = rectangle2D.getWidth() / (double)2;
        }
        return dArray;
    }

    private static final Font getScaledFont(FigAttribs figAttribs) {
        int n = (int)((double)figAttribs.fontSize * 33.333333333333336 + 0.1);
        Font font = FontCache.getFontCache().getFont(figAttribs.fig_font, n);
        return font;
    }

    private static final FontRenderContext getFontRenderContext(Graphics2D graphics2D) {
        if (graphics2D != null) {
            return graphics2D.getFontRenderContext();
        }
        return new FontRenderContext(new AffineTransform(), false, false);
    }

    public static double[] getLRWAD(String string, FigAttribs figAttribs) {
        if (SetupManager.getBoolean("jfig.java2d.FigTextRenderer.new", false)) {
            Font font = FigTextRenderer.getScaledFont(figAttribs);
            FontRenderContext fontRenderContext = FigTextRenderer.getFontRenderContext(null);
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            return FigTextRenderer.toLRWAD(rectangle2D, figAttribs);
        }
        FontMetrics fontMetrics = FontCache.getFontCache().getFontMetrics(figAttribs.fig_font, figAttribs.fontSize);
        double d = 33.333333333333336;
        double d2 = d * (double)fontMetrics.stringWidth(string);
        double d3 = -d * (double)fontMetrics.getAscent();
        double d4 = d * (double)fontMetrics.getDescent();
        double d5 = 0.0;
        double d6 = 0.0;
        if (figAttribs.textAlign == 1) {
            d5 = 0.0;
            d6 = d2;
        } else if (figAttribs.textAlign == 3) {
            d5 = -d2;
            d6 = 0.0;
        } else if (figAttribs.textAlign == 2) {
            d5 = -d2 / (double)2;
            d6 = d2 / (double)2;
        }
        return new double[]{d5, d6, d2, d3, d4};
    }

    public static double getStringWidth(String string, FigAttribs figAttribs) {
        if (SetupManager.getBoolean("jfig.java2d.FigTextRenderer.new", false)) {
            Font font = FigTextRenderer.getScaledFont(figAttribs);
            FontRenderContext fontRenderContext = FigTextRenderer.getFontRenderContext(null);
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            return rectangle2D.getWidth();
        }
        FontMetrics fontMetrics = FontCache.getFontCache().getFontMetrics(figAttribs.fig_font, figAttribs.fontSize);
        return (double)fontMetrics.stringWidth(string) * 33.333333333333336;
    }

    private final void paintInWorldCoords(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.textObject.isVisible()) {
            return;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            String string = this.textObject.getSymbolRecodedString();
            Point point = this.textObject.getPosition();
            FigAttribs figAttribs = this.textObject.getAttributes();
            Font font = FigTextRenderer.getScaledFont(figAttribs);
            FontRenderContext fontRenderContext = FigTextRenderer.getFontRenderContext(graphics2D);
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            double[] dArray = FigTextRenderer.toLRWAD(rectangle2D, figAttribs);
            double d = dArray[0];
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            AffineTransform affineTransform2 = FigTools2D.createCompoundTransform(affineTransform, figTrafo2D);
            affineTransform2.translate(point.x, point.y);
            affineTransform2.rotate(-figAttribs.fig_angle);
            affineTransform2.translate(d, 0.0);
            graphics2D.setTransform(affineTransform2);
            if (this.showBoundingBoxes) {
                graphics2D.setColor(Color.orange);
                graphics2D.drawRect(0, (int)(-Math.abs(dArray[3])), (int)dArray[2], (int)Math.abs(dArray[3]));
                graphics2D.drawLine(0, 0, (int)dArray[2], 0);
            }
            if (string.length() > 0) {
                graphics2D.setColor(figAttribs.lineColor);
                graphics2D.setFont(font);
                graphics2D.drawString(string, 0, 0);
            }
            if (string != null && this.textObject.isShowCursor()) {
                String string2 = string.substring(0, this.textObject.getTextCursorIndex());
                Rectangle2D rectangle2D2 = font.getStringBounds(string2, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                if (this.showBoundingBoxes) {
                    graphics2D.setColor(Color.red);
                    graphics2D.draw(rectangle2D2);
                }
                int n = (int)rectangle2D2.getWidth();
                int n2 = (int)lineMetrics.getAscent();
                graphics2D.setColor(Color.blue);
                graphics2D.drawLine(n, 0, n, -n2);
            }
            if (this.textObject.isShowPoints() || this.textObject.isSelected()) {
                affineTransform2 = new AffineTransform();
                affineTransform2.translate(figTrafo2D.wc_to_screen_x(point.x), figTrafo2D.wc_to_screen_y(point.y));
                affineTransform2.rotate(-figAttribs.fig_angle);
                affineTransform2.preConcatenate(affineTransform);
                graphics2D.setTransform(affineTransform2);
                if (this.textObject.isShowPoints()) {
                    int n = (int)figTrafo2D.wc_to_screen(dArray[3]);
                    this.showOnePoint(graphics, 0, 0, false);
                    this.showOnePoint(graphics, 0, n, false);
                }
                if (this.textObject.isSelected()) {
                    int n = (int)figTrafo2D.wc_to_screen(dArray[3]);
                    this.showOnePoint(graphics, 0, 0, true);
                    this.showOnePoint(graphics, 0, n, true);
                }
            }
            graphics2D.setTransform(affineTransform);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void paintInScreenCoords(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.textObject.isVisible()) {
            return;
        }
        try {
            String string = this.textObject.getSymbolRecodedString();
            Point point = this.textObject.getPosition();
            FigAttribs figAttribs = this.textObject.getAttributes();
            int n = (int)((double)figAttribs.fontSize * figTrafo2D.getZoom() + 0.1);
            Font font = FontCache.getFontCache().getFont(figAttribs.fig_font, n);
            FontMetrics fontMetrics = FontCache.getFontCache().getFontMetrics(figAttribs.fig_font, n);
            int n2 = -fontMetrics.getAscent();
            int n3 = fontMetrics.getDescent();
            int n4 = fontMetrics.stringWidth(string);
            int n5 = 0;
            int n6 = 0;
            if (figAttribs.textAlign == 1) {
                n5 = 0;
                n6 = n4;
            } else if (figAttribs.textAlign == 3) {
                n5 = -n4;
                n6 = 0;
            } else if (figAttribs.textAlign == 2) {
                n5 = -n4 / 2;
                n6 = n4 / 2;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(figTrafo2D.wc_to_screen_x(point.x), figTrafo2D.wc_to_screen_y(point.y));
            affineTransform2.rotate(-figAttribs.fig_angle);
            affineTransform2.preConcatenate(affineTransform);
            graphics2D.setTransform(affineTransform2);
            if (this.showBoundingBoxes) {
                graphics2D.setColor(Color.orange);
                graphics2D.drawRect(n5, n2, n4, -n2 + n3);
                graphics2D.setColor(Color.blue);
                graphics2D.drawLine(n5, 0, n6, 0);
            }
            if (string.length() > 0) {
                graphics2D.setColor(figAttribs.lineColor);
                graphics2D.setFont(font);
                graphics2D.drawString(string, n5, 0);
            }
            if (string != null && this.textObject.isShowCursor()) {
                String string2 = string.substring(0, this.textObject.getTextCursorIndex());
                int n7 = fontMetrics.stringWidth(string2);
                int n8 = fontMetrics.getAscent();
                if (this.showBoundingBoxes) {
                    graphics2D.setColor(Color.red);
                    graphics2D.drawRect(n5, n2, n7, -n2 + n3);
                }
                graphics2D.setColor(Color.blue);
                graphics2D.drawLine(n5 + n7, 0, n5 + n7, -n8);
            }
            if (this.textObject.isShowPoints()) {
                int n9 = n2;
                this.showOnePoint(graphics, 0, 0, false);
                this.showOnePoint(graphics, 0, n9, false);
            }
            if (this.textObject.isSelected()) {
                int n10 = n2;
                this.showOnePoint(graphics, 0, 0, true);
                this.showOnePoint(graphics, 0, n10, true);
            }
            graphics2D.setTransform(affineTransform);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void showOnePoint(Graphics graphics, int n, int n2, boolean bl) {
        Color color = bl ? Color.white : Color.black;
        Color color2 = bl ? Color.black : Color.white;
        graphics.setColor(color);
        graphics.fillRect(n - 2, n2 - 2, 5, 5);
        graphics.setColor(color2);
        graphics.fillRect(n - 1, n2 - 1, 3, 3);
    }

    private final void showTexPoint(Graphics graphics, int n, int n2, boolean bl) {
        Color color = bl ? Color.yellow : Color.black;
        Color color2 = bl ? Color.black : Color.yellow;
        graphics.setColor(color);
        graphics.drawRect(n - 3, n2 - 3, 5, 5);
        graphics.setColor(color2);
        graphics.fillRect(n - 2, n2 - 2, 4, 4);
    }

    public FigTextRenderer(FigText figText) {
        this.textObject = figText;
        this.showBoundingBoxes = SetupManager.getBoolean("jfig.objects.FigText.showBoundingBoxes", false);
        if (figText.isTeXMode()) {
            System.out.println("-### FigTextRenderer: '" + figText.getText() + '\'');
            Thread.dumpStack();
        }
    }
}

