/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigArrow2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigRenderer;
import jfig.objects.FigSpline;
import jfig.objects.Point;

public class FigSplineRenderer
implements FigRenderer {
    FigSpline spline;
    GeneralPath path2D;
    GeneralPath fill2D;
    BasicStroke stroke;
    Color color;
    Paint paint;
    FigArrow2D frontArrow;
    FigArrow2D backArrow;

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.spline.isVisible()) {
            return;
        }
        if (!this.spline.isVisible()) {
            return;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setTransform(FigTools2D.createCompoundTransform(affineTransform, figTrafo2D));
            if (this.paint != null) {
                graphics2D.setPaint(this.paint);
                graphics2D.fill(this.fill2D);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.path2D);
            }
            if (this.frontArrow != null) {
                this.frontArrow.paint(graphics2D);
            }
            if (this.backArrow != null) {
                this.backArrow.paint(graphics2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.spline.isShowPoints()) {
                FigTools2D.showPoints((Graphics)graphics2D, figTrafo2D, this.spline.getPoints());
            }
            if (this.spline.isSelected()) {
                FigTools2D.showSelected((Graphics)graphics2D, figTrafo2D, this.spline.getPoints());
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- FigSplineRenderer(2D).paint: " + throwable);
            throwable.printStackTrace();
        }
    }

    public FigSplineRenderer(FigSpline figSpline) {
        boolean bl;
        this.spline = figSpline;
        FigAttribs figAttribs = this.spline.getAttributes();
        Point[] pointArray = this.spline.getSplinePoints();
        this.color = figAttribs.lineColor;
        this.paint = FigTools2D.createPaint(figAttribs);
        this.stroke = FigTools2D.createStroke(figAttribs, 1, FigTools2D.getStrokeCapStyle(figAttribs));
        this.frontArrow = FigTools2D.createFrontArrow(this.spline, pointArray, 5);
        this.backArrow = FigTools2D.createBackArrow(this.spline, pointArray, 5);
        boolean bl2 = this.spline.isClosed();
        boolean bl3 = false;
        if (figAttribs.arrowMode == 0) {
            bl3 = bl = true;
        }
        if (bl2 || bl) {
            this.fill2D = this.path2D = FigTools2D.createPath(pointArray, bl2);
        } else {
            this.path2D = FigTools2D.createArrowCorrectedLine(pointArray, figAttribs);
            this.fill2D = FigTools2D.createPath(pointArray, bl2);
        }
    }
}

