/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jfig.canvas.DelayedRepaintHandler;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ObjectPainter;
import jfig.java2d.FigTools2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigImage;
import jfig.objects.FigRenderer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigImageRenderer
implements FigRenderer {
    public static final int MAX_FAILED_REPAINTS = 10;
    public static final int REPAINT_RETRY_MILLIS = 50;
    FigImage imageObject;
    Shape rect2D;
    BasicStroke stroke;
    Color color;
    int n_failed_repaints;

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.imageObject.isVisible()) {
            return;
        }
        try {
            FigBbox figBbox;
            Stroke stroke;
            AffineTransform affineTransform;
            Graphics2D graphics2D;
            block13: {
                graphics2D = (Graphics2D)graphics;
                affineTransform = graphics2D.getTransform();
                stroke = graphics2D.getStroke();
                graphics2D.setTransform(FigTools2D.createCompoundTransform(affineTransform, figTrafo2D));
                figBbox = this.imageObject.getBbox();
                Image image = this.imageObject.getImage();
                FigImage figImage = this.imageObject;
                if (image != null) {
                    try {
                        int n = image.getWidth(figImage);
                        int n2 = image.getHeight(figImage);
                        boolean bl = graphics2D.drawImage(image, (int)figBbox.getXl(), (int)figBbox.getYt(), (int)figBbox.getXr() + 1, (int)figBbox.getYb() + 1, 0, 0, n, n2, figImage);
                        if (bl) break block13;
                        ++this.n_failed_repaints;
                        if (this.n_failed_repaints < 10) {
                            ObjectPainter objectPainter = this.imageObject.getObjectPainter();
                            FigCanvas figCanvas = (FigCanvas)objectPainter;
                            new DelayedRepaintHandler(figCanvas, 200).start();
                            new DelayedRepaintHandler(figCanvas, 2000).start();
                        } else if (this.n_failed_repaints == 10) {
                            System.err.println("-E- FigImageRenderer: drawing failed.  Giving up now (after " + this.n_failed_repaints + " attempts).");
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("-E- internal in FigImageRenderer: " + runtimeException);
                    }
                } else {
                    graphics2D.setColor(Color.black);
                    graphics2D.setFont(FigAttribs.defaultFont);
                    graphics2D.drawString("image not found", (int)figBbox.getXl() + 10, (int)(figBbox.getYt() + (figBbox.getYt() + figBbox.getYb()) / (double)2));
                }
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.rect2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.imageObject.isShowPoints()) {
                FigTools2D.showPoints(graphics, figTrafo2D, figBbox);
            }
            if (this.imageObject.isSelected()) {
                FigTools2D.showSelected(graphics, figTrafo2D, figBbox);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.n_failed_repaints = 0;
    }

    public FigImageRenderer(FigImage figImage) {
        this.this();
        this.imageObject = figImage;
        this.color = figImage.getAttributes().lineColor;
        this.stroke = FigTools2D.createStroke(figImage.getAttributes());
        FigBbox figBbox = figImage.getBbox();
        this.rect2D = new Rectangle2D.Double(figBbox.getXl(), figBbox.getYt(), figBbox.getXr() - figBbox.getXl(), figBbox.getYb() - figBbox.getYt());
    }
}

