/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigTools2D;
import jfig.objects.FigEllipse;
import jfig.objects.FigRenderer;
import jfig.objects.Point;

public class FigEllipseRenderer
implements FigRenderer {
    FigEllipse ellipse;
    Shape ellipse2D;
    BasicStroke stroke;
    Color color;
    Paint paint;

    public AffineTransform createCompoundTransform(AffineTransform affineTransform, FigTrafo2D figTrafo2D) {
        double d = -this.ellipse.getAttributes().fig_angle;
        double d2 = figTrafo2D.getZoomFactor() / 33.333333333333336;
        double d3 = this.ellipse.getCenterPoint().x;
        double d4 = this.ellipse.getCenterPoint().y;
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d2, d2);
        affineTransform2.translate(-figTrafo2D.getAnchor().x, -figTrafo2D.getAnchor().y);
        affineTransform2.rotate(d, d3, d4);
        affineTransform2.preConcatenate(affineTransform);
        return affineTransform2;
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (!this.ellipse.isVisible()) {
            return;
        }
        try {
            Point[] pointArray;
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setTransform(this.createCompoundTransform(affineTransform, figTrafo2D));
            if (this.paint != null) {
                graphics2D.setPaint(this.paint);
                graphics2D.fill(this.ellipse2D);
            }
            if ((double)this.stroke.getLineWidth() > 0.0) {
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.ellipse2D);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
            if (this.ellipse.isSelected()) {
                pointArray = this.ellipse.getRotatedPoints();
                FigTools2D.showSelected(graphics, figTrafo2D, pointArray);
            }
            if (this.ellipse.isShowPoints()) {
                pointArray = this.ellipse.getRotatedPoints();
                FigTools2D.showPoints(graphics, figTrafo2D, pointArray);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public FigEllipseRenderer(FigEllipse figEllipse) {
        this.ellipse = figEllipse;
        this.color = figEllipse.getAttributes().lineColor;
        this.stroke = FigTools2D.createStroke(figEllipse.getAttributes());
        this.paint = FigTools2D.createPaint(figEllipse.getAttributes());
        Point point = figEllipse.getCenterPoint();
        Point point2 = figEllipse.getRadiusPoint();
        this.ellipse2D = new Ellipse2D.Double(point.x - point2.x, point.y - point2.y, (double)2 * point2.x, (double)2 * point2.y);
    }
}

