/*
 * Decompiled with CFR 0.152.
 */
package jfig.canvas;

import jfig.objects.Point;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigTrafo2D
implements Cloneable {
    public static final int DPI = 2400;
    public static final int DOTS_PER_MM = 96;
    public static final int DOTS_PER_INCH = 75;
    public static final int DOTS_PER_XMM = 80;
    public static final int UNITS_MM = 1;
    public static final int UNITS_INCHES = 2;
    public static final int UNITS_XMM = 3;
    public static String[] UNITS_STRING = new String[]{"??", "cm", "in", "xmm"};
    public static final int NO_GRID = 0;
    public static final int FINE_GRID = 240;
    public static final int MEDIUM_GRID = 480;
    public static final int COARSE_GRID = 960;
    public static final int TEN_GRID = 961;
    public static final int NO_SNAP = 1;
    public static final int COARSE_SNAP = 2;
    public static final int MEDIUM_SNAP = 3;
    public static final int FINE_SNAP = 4;
    public static final int TEN_SNAP = 10;
    public static final int USER_DEFINED_SNAP = 13;
    public static final double MIN_ZOOM_FACTOR = 0.03125;
    public static final double MAX_ZOOM_FACTOR = 32.0;
    public static final double DOTS_PER_SCREEN_DOT = 33.333333333333336;
    static final double[] offsets;
    static final double[] factors;
    static final double FACTOR = 2.0;
    boolean debug;
    public int units;
    protected double zoom_factor;
    protected int zoom_factor75;
    protected double d_zoom_factor;
    protected double snapDeltaX;
    protected double snapDeltaY;
    public int snapMode;
    public int gridMode;
    public long timestamp;
    protected Point anchor;
    protected Point p;

    public void setAnchor(Point point) {
        this.anchor.x = point.x;
        this.anchor.y = point.y;
        this.timestamp = System.currentTimeMillis();
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void set_zoom(double d) {
        if (d >= 32.0) {
            d = 32.0;
        }
        if (d <= 0.03125) {
            d = 0.03125;
        }
        this.zoom_factor = d;
        this.zoom_factor75 = (int)(75.0 * this.zoom_factor);
        if (this.zoom_factor75 < 1) {
            this.zoom_factor75 = 1;
        }
        this.d_zoom_factor = this.zoom_factor * 75.0 / 2400.0;
        this.setSnapRelative(this.snapMode);
        this.timestamp = System.currentTimeMillis();
    }

    public void set_zoom_region(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.debug) {
            System.out.println("Trafo2D.set_zoom_region: " + n + ' ' + n2 + ' ' + n3 + ' ' + n4 + ' ' + n5 + ' ' + n6);
        }
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 == n) {
            n3 = n + 1;
        }
        if (n4 == n2) {
            n4 = n2 + 1;
        }
        this.anchor.x = n;
        this.anchor.y = n2;
        double d = 33.333333333333336 * (double)n5 / (double)(n3 - n);
        double d2 = 33.333333333333336 * (double)n6 / (double)(n4 - n2);
        double d3 = Math.min(d, d2);
        if (this.debug) {
            System.out.println("New factor: " + d3);
        }
        int n8 = 0;
        while (n8 < factors.length) {
            if (this.debug) {
                System.out.println("i= " + n8 + " factors[i]= " + factors[n8] + " factor " + d3);
            }
            if (1.1 * d3 > factors[n8]) {
                d3 = factors[n8];
                break;
            }
            ++n8;
        }
        if (this.debug) {
            System.out.println("i=" + n8 + " factor=" + d3);
        }
        d3 = Math.max(0.013333333333333334, d3);
        if (this.debug) {
            System.out.println("New factor: " + d3);
        }
        this.set_zoom(d3);
    }

    public void set_zoom_region_ooooolllllldddd(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.debug) {
            System.out.println("set_zoom_region: " + n + ' ' + n2 + ' ' + n3 + ' ' + n4 + ' ' + n5 + ' ' + n6);
        }
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 == n) {
            n3 = n + 1;
        }
        if (n4 == n2) {
            n4 = n2 + 1;
        }
        this.anchor.x = n;
        this.anchor.y = n2;
        double d = 33.333333333333336 * (double)n5 / (double)(n3 - n);
        double d2 = 33.333333333333336 * (double)n6 / (double)(n4 - n2);
        double d3 = Math.min(d, d2);
        if (this.debug) {
            System.out.println("New factor: " + d3);
        }
        double d4 = 1.52587890625E-5;
        while (d4 < d3) {
            d4 *= (double)2;
        }
        d3 = d4;
        d3 = Math.max(0.013333333333333334, d3);
        if (this.debug) {
            System.out.println("New factor: " + d3);
        }
        this.set_zoom(d3);
    }

    public double getZoomFactor() {
        return this.zoom_factor;
    }

    public double getZoom() {
        return this.zoom_factor;
    }

    public double getMinZoomFactor() {
        return 0.03125;
    }

    public double getMaxZoomFactor() {
        return 32.0;
    }

    /*
     * Unable to fully structure code
     */
    public double getZoomFactor_MultipleOfTwo() {
        block3: {
            var1_1 = 1.0;
            if (!(this.zoom_factor >= 1.0)) ** GOTO lbl8
            while (var1_1 < this.zoom_factor) {
                var1_1 = (double)2 * var1_1;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var1_1 = 0.5 * var1_1;
lbl8:
                // 2 sources

                ** while (var1_1 >= this.zoom_factor)
            }
lbl9:
            // 1 sources

            var1_1 = (double)2 * var1_1;
        }
        if (this.debug) {
            System.out.println("gZFM: factor=" + this.zoom_factor + " m=" + var1_1);
        }
        return var1_1;
    }

    public int get_units() {
        return this.units;
    }

    public int getUnits() {
        return this.get_units();
    }

    public String get_units_string() {
        return UNITS_STRING[this.units];
    }

    public double getValueInUnits(double d) {
        if (this.units == 1) {
            return d / 960.0;
        }
        if (this.units == 2) {
            return d / 2400.0;
        }
        if (this.units == 3) {
            return d / 80.0;
        }
        System.err.println("-E- FigTrafo2D: units not set?");
        return d;
    }

    public void setSnapAbsolute(double d) {
        this.snapDeltaX = d;
        this.snapDeltaY = d;
    }

    public void setSnapAbsolute(double d, double d2) {
        this.snapDeltaX = d;
        this.snapDeltaY = d2;
    }

    public void setSnapRelative(int n) {
        this.snapMode = n;
        if (n == 13) {
            String string = "jfig.userDefinedMagneticGridSpacing";
            this.snapDeltaX = SetupManager.getDouble(string + 'X', 300.0);
            this.snapDeltaY = SetupManager.getDouble(string + 'Y', 300.0);
            if (SetupManager.getBoolean(string + "Zoom", true)) {
                if (this.snapDeltaX != 1.0) {
                    this.snapDeltaX /= this.getZoomFactor_MultipleOfTwo();
                }
                if (this.snapDeltaY != 1.0) {
                    this.snapDeltaY /= this.getZoomFactor_MultipleOfTwo();
                }
            }
        } else {
            int n2 = 1;
            double d = 1.0;
            if (n == 1) {
                this.snapDeltaX = 1.0;
                this.snapDeltaY = 1.0;
                return;
            }
            if (n == 2) {
                n2 = 2;
            } else if (n == 3) {
                n2 = 4;
            } else if (n == 4) {
                n2 = 8;
            } else if (n == 10) {
                n2 = 10;
            } else {
                this.message("-E- FigTrafo2D.setSnapRelative: illegal snap mode " + n);
                this.snapMode = 1;
                return;
            }
            if (this.units == 1) {
                d = 1920.0;
            } else if (this.units == 2) {
                d = 2400.0;
            } else if (this.units == 3) {
                d = 1800.0;
            } else {
                this.message("-E- FigTrafo2D.setSnapRelative: illegal units:" + this.units);
                this.snapDeltaX = 1.0;
                this.snapDeltaY = 1.0;
                return;
            }
            this.snapDeltaY = this.snapDeltaX = d / ((double)n2 * this.getZoomFactor_MultipleOfTwo());
        }
    }

    public double getSnap() {
        return Math.max(1.0, Math.min(this.snapDeltaX, this.snapDeltaY));
    }

    public int getSnapRelative() {
        return (int)this.getMagneticGridOrDefaultSpacing();
    }

    public double getMagneticGridOrDefaultSpacing() {
        double d = Math.min(this.snapDeltaX, this.snapDeltaY);
        if (d > 1.0) {
            return (int)d;
        }
        return this.screen_to_wc(8);
    }

    public boolean insideSnap(int n, int n2) {
        boolean bl = false;
        if (Math.abs(n - n2) <= this.getSnapRelative()) {
            bl = true;
        }
        return bl;
    }

    public double getGridSpacingValue() {
        double d = 1.0;
        if (this.units == 1) {
            d = 1920.0 / this.zoom_factor;
        } else if (this.units == 2) {
            d = 2400.0 / this.zoom_factor;
        } else if (this.units == 3) {
            d = 1800.0 / this.zoom_factor;
        } else {
            System.out.println("FigTrafo2D.getGridSpacing: illegal units!");
            d = 1.0;
        }
        return d;
    }

    public int screen_to_wc(int n) {
        return (int)((double)n * 33.333333333333336 / this.zoom_factor);
    }

    public int screen_to_wc_x(int n) {
        return (int)this.anchor.x + (int)((double)n * 33.333333333333336 / this.zoom_factor);
    }

    public int screen_to_wc_y(int n) {
        return (int)this.anchor.y + (int)((double)n * 33.333333333333336 / this.zoom_factor);
    }

    public Point screen_to_wc(Point point, Point point2) {
        point2.x = this.anchor.x + (double)((int)(point.x * 33.333333333333336 / this.zoom_factor));
        point2.y = this.anchor.y + (double)((int)(point.y * 33.333333333333336 / this.zoom_factor));
        return point2;
    }

    public int wc_to_screen(int n) {
        return (int)((double)n * this.zoom_factor / 33.333333333333336);
    }

    public double wc_to_screen(double d) {
        return d * this.zoom_factor / 33.333333333333336;
    }

    public int wc_to_screen_x(double d) {
        return (int)((d - this.anchor.x) * this.zoom_factor / 33.333333333333336);
    }

    public int wc_to_screen_y(double d) {
        return (int)((d - this.anchor.y) * this.zoom_factor / 33.333333333333336);
    }

    public Point wc_to_screen(Point point, Point point2) {
        if (point == null) {
            this.message("-F- FigTrafo2D.wc_to_screen: wp is null!");
            return new Point(0.0, 0.0);
        }
        if (point2 == null) {
            this.message("-F- FigTrafo2D.wc_to_screen: sp is null!");
            return new Point(0.0, 0.0);
        }
        point2.x = (int)((point.x - this.anchor.x) * this.zoom_factor / 33.333333333333336);
        point2.y = (int)((point.y - this.anchor.y) * this.zoom_factor / 33.333333333333336);
        return point2;
    }

    public Point wc_to_screen(double d, double d2, Point point) {
        point.x = (int)((d - this.anchor.x) * this.zoom_factor / 33.333333333333336);
        point.y = (int)((d2 - this.anchor.y) * this.zoom_factor / 33.333333333333336);
        return point;
    }

    public Point screen_to_wc_snapped(Point point, Point point2) {
        return this.screen_to_wc_snapped(point.x, point.y, point2);
    }

    public Point screen_to_wc_snapped(double d, double d2, Point point) {
        double d3 = this.anchor.x + d * 33.333333333333336 / this.zoom_factor + 0.5 * this.snapDeltaX;
        double d4 = this.anchor.y + d2 * 33.333333333333336 / this.zoom_factor + 0.5 * this.snapDeltaY;
        point.x = (int)(Math.floor(d3 / this.snapDeltaX) * this.snapDeltaX);
        point.y = (int)(Math.floor(d4 / this.snapDeltaY) * this.snapDeltaY);
        return point;
    }

    public Point getWorldCoords(double d, double d2) {
        Point point = new Point(0.0, 0.0);
        point.x = this.anchor.x + (double)((int)(d * 33.333333333333336 / this.zoom_factor));
        point.y = this.anchor.y + (double)((int)(d2 * 33.333333333333336 / this.zoom_factor));
        return point;
    }

    public Point getWorldCoords(Point point) {
        return this.getWorldCoords(point.getX(), point.getY());
    }

    public Point getWorldCoordsSnapped(double d, double d2) {
        Point point = new Point(0.0, 0.0);
        return this.screen_to_wc_snapped(d, d2, point);
    }

    public Point getWorldCoordsSnapped(Point point) {
        return this.getWorldCoordsSnapped(point.x, point.y);
    }

    public Point getScreenCoords(Point point) {
        Point point2 = new Point(0.0, 0.0);
        return this.wc_to_screen(point.x, point.y, point2);
    }

    public double getScreenCoordsX(double d) {
        return (d - this.anchor.x) * this.zoom_factor / 33.333333333333336;
    }

    public double getScreenCoordsY(double d) {
        return (d - this.anchor.y) * this.zoom_factor / 33.333333333333336;
    }

    public double getScreenCoordsDX(double d) {
        return d * this.zoom_factor / 33.333333333333336;
    }

    public void setGridMode(int n) {
        this.gridMode = n;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void doChangeUnits() {
        ++this.units;
        if (this.units > 3) {
            this.units = 1;
        }
        this.setSnapRelative(this.snapMode);
    }

    public void setUnits(int n) {
        if (n == 1) {
            this.units = 1;
        } else if (n == 2) {
            this.units = 2;
        } else if (n == 3) {
            this.units = 3;
        } else {
            throw new IllegalArgumentException("setUnits: unknown units value: " + n);
        }
        this.setSnapRelative(this.snapMode);
    }

    public FigTrafo2D getClone() {
        try {
            FigTrafo2D figTrafo2D = (FigTrafo2D)this.clone();
            figTrafo2D.anchor = new Point(this.anchor.x, this.anchor.y);
            return figTrafo2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void message(String string) {
        ExceptionTracer.message(string);
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.units = 2;
        this.snapMode = 3;
        this.gridMode = 960;
    }

    public FigTrafo2D() {
        this.this();
        this.zoom_factor = 1.0;
        this.zoom_factor75 = (int)(75.0 * this.zoom_factor);
        this.d_zoom_factor = this.zoom_factor * 75.0 / 2400.0;
        this.snapDeltaX = 48.0;
        this.snapDeltaY = 48.0;
        this.gridMode = 960;
        this.anchor = new Point(0.0, 0.0);
        this.p = new Point(0.0, 0.0);
        this.units = 2;
        this.timestamp = System.currentTimeMillis();
    }

    static {
        double[] dArray = new double[21];
        dArray[0] = -15.5;
        dArray[1] = -10.814;
        dArray[2] = -7.5;
        dArray[3] = -5.157;
        dArray[4] = -3.5;
        dArray[5] = -2.3284;
        dArray[6] = -1.5;
        dArray[7] = -0.9142;
        dArray[8] = -0.5;
        dArray[9] = -0.2071;
        dArray[11] = 0.14644;
        dArray[12] = 0.25;
        dArray[13] = 0.32322;
        dArray[14] = 0.375;
        dArray[15] = 0.4116;
        dArray[16] = 0.4375;
        dArray[17] = 0.4558;
        dArray[18] = 0.46875;
        dArray[19] = 0.4779;
        dArray[20] = 0.484375;
        offsets = dArray;
        factors = new double[]{32.0, 22.627, 16.0, 11.3137, 8.0, 5.6569, 4, 2.82843, 2, 1.41421, 1.0, 0.70711, 0.5, 0.35355, 0.25, 0.1767, 0.125, 0.08839, 0.0625, 0.04419, 0.03125};
    }
}

