/*
 * Decompiled with CFR 0.152.
 */
package jfig.canvas;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.Point;
import jfig.utils.Format;
import jfig.utils.GeometryManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FigCanvasRubberband {
    public static final int NO_RUBBER = 0;
    public static final int POINT_RUBBER = 1;
    public static final int LINE_RUBBER = 2;
    public static final int LINE2_RUBBER = 3;
    public static final int RECT_RUBBER = 4;
    public static final int BBOX_RUBBER = 5;
    public static final int CIRCLE_RUBBER = 6;
    public static final int ELLIPSE_RUBBER = 7;
    public static final int POLYLINE_RUBBER = 8;
    public static final int SCALE_RUBBER = 11;
    public static final int ARC_RUBBER = 12;
    public static final int RESTRICTED_BBOX_RUBBER = 13;
    public static final int RESTRICTED_SCALE_RUBBER = 14;
    public static final int RESTRICTED_LINE_RUBBER = 15;
    public static final int RESTRICTED_LINE2_RUBBER = 16;
    public static final int RESTRICTED_RECT_RUBBER = 17;
    public static final int CIRCLE2_RUBBER = 20;
    public static final int OBJECT_RUBBER = 21;
    public static final int GEOMETRY_MANAGED_RUBBER = 25;
    public static final int RC = 0;
    public static final int LC = 1;
    public static final int CC = 2;
    public static final int CT = 3;
    public static final int CB = 5;
    public static final int RT = 6;
    public static final int RB = 7;
    public static final int LB = 8;
    public static final int LT = 9;
    int mode;
    Object obj;
    FigBbox bbox;
    FigTrafo2D trafo;
    Polygon pg;
    FigObject tmpObject;
    Point tmpOffset;
    int _old_bbox_x;
    int _old_bbox_y;
    int _old_bbox_w;
    int _old_bbox_h;
    int base_x;
    int base_y;
    int base2_x;
    int base2_y;
    int target_x;
    int target_y;
    int old_x;
    int old_y;
    int x;
    int y;
    int dx;
    int dy;
    int offset_x;
    int offset_y;
    double aspect;
    boolean debug;
    boolean showLineLengthsEnable;
    Font mfont;
    GeometryManager geometryManager;

    public boolean setDebug(boolean bl) {
        this.debug = bl;
        return bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
    }

    public void setShowLineLengths(boolean bl) {
        this.showLineLengthsEnable = bl;
    }

    public void setBasePoint(Point point) {
        this.base_x = (int)point.x;
        this.base_y = (int)point.y;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.setBasePoint at (" + point.x + ", " + point.y + ") ");
        }
    }

    public void setBasePoint(int n, int n2) {
        this.base_x = n;
        this.base_y = n2;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.setBasePoint at (" + n + ", " + n2 + ") ");
        }
    }

    public void setGeometryManager(GeometryManager geometryManager) {
        this.geometryManager = geometryManager;
    }

    public void setBasePoint2(Point point) {
        this.base2_x = (int)point.x;
        this.base2_y = (int)point.y;
    }

    public void setTargetPoint(Point point) {
        this.target_x = (int)point.x;
        this.target_y = (int)point.y;
    }

    public void setAspect(double d) {
        this.aspect = d;
    }

    public int getMode() {
        return this.mode;
    }

    public void changeMode(int n) {
        this.mode = n;
        this.obj = null;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.changeMode: " + n);
        }
    }

    public void changeMode(int n, GeometryManager geometryManager) {
        this.changeMode(n);
        this.setGeometryManager(geometryManager);
    }

    public Point getBasePoint() {
        return new Point(this.base_x, this.base_y);
    }

    public void changeMode(int n, FigTrafo2D figTrafo2D, Object object) {
        this.mode = n;
        this.trafo = figTrafo2D;
        this.obj = object;
        if (n == 5) {
            FigBbox figBbox = (FigBbox)object;
            if (figBbox != null) {
                Point point = new Point(figBbox.getXl(), figBbox.getYt());
                Point point2 = new Point(figBbox.getXr(), figBbox.getYb());
                Point point3 = new Point(0.0, 0.0);
                Point point4 = new Point(0.0, 0.0);
                point3 = figTrafo2D.wc_to_screen(point, point3);
                point4 = figTrafo2D.wc_to_screen(point2, point4);
                this.offset_x = (int)(point3.x - (double)this.base_x);
                this.offset_y = (int)(point3.y - (double)this.base_y);
                this.dx = (int)(point4.x - point3.x);
                this.dy = (int)(point4.y - point3.y);
                if (this.dx <= 0) {
                    this.dx = 1;
                }
                if (this.dy <= 0) {
                    this.dy = 1;
                }
            } else {
                System.out.println("FigCanvasRubberband.changeMode: wrong object for BBOX_RUBBER mode! ");
                this.dx = 1;
                this.dy = 1;
            }
        } else {
            if (n == 8) {
                throw new RuntimeException("polyline rubberband not implemented!");
            }
            if (n == 21) {
                if (object == null) {
                    return;
                }
                this.tmpObject = (FigObject)object;
                double d = this.tmpObject.getPosition().x - (double)figTrafo2D.screen_to_wc_x(this.base_x);
                double d2 = this.tmpObject.getPosition().y - (double)figTrafo2D.screen_to_wc_y(this.base_y);
                this.tmpOffset = new Point(-d, -d2);
                FigBbox figBbox = this.tmpObject.getBbox();
                Point point = new Point(figBbox.getXl(), figBbox.getYt());
                Point point5 = new Point(figBbox.getXr(), figBbox.getYb());
                Point point6 = new Point(0.0, 0.0);
                Point point7 = new Point(0.0, 0.0);
                point6 = figTrafo2D.wc_to_screen(point, point6);
                point7 = figTrafo2D.wc_to_screen(point5, point7);
                this.offset_x = (int)(point6.x - (double)this.base_x);
                this.offset_y = (int)(point6.y - (double)this.base_y);
                this.dx = (int)(point7.x - point6.x);
                this.dy = (int)(point7.y - point6.y);
                if (this.dx <= 0) {
                    this.dx = 1;
                }
                if (this.dy <= 0) {
                    this.dy = 1;
                }
                this._old_bbox_x = this.offset_x;
                this._old_bbox_y = this.offset_y;
                this._old_bbox_w = this.dx;
                this._old_bbox_h = this.dy;
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        if (this.mode == 0) {
            return;
        }
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        if (bl) {
            this.paintOnce(graphics, this.old_x, this.old_y);
        }
        this.paintOnce(graphics, n, n2);
        bl = true;
        this.old_x = n;
        this.old_y = n2;
    }

    public void paintOnce(Graphics graphics, int n, int n2) {
        if (this.mode == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("FigCanvasRubberband.paintOnce(): mode: " + this.mode + " at (" + n + ", " + n2 + ")  from base at (" + this.base_x + ", " + this.base_y + ") ");
        }
        switch (this.mode) {
            case 1: {
                graphics.drawLine(n - 3, n2, n + 3, n2);
                graphics.drawLine(n, n2 - 3, n, n2 + 3);
                break;
            }
            case 2: {
                graphics.drawLine(this.base_x, this.base_y, n, n2);
                if (!this.showLineLengthsEnable) break;
                graphics.drawLine(this.base_x, this.base_y, n, n2);
                int n3 = n - this.base_x;
                int n4 = n2 - this.base_y;
                int n5 = (int)(0.5 + Math.sqrt(n3 * n3 + n4 * n4));
                Color color = graphics.getColor();
                graphics.setColor(Color.red);
                graphics.setFont(this.mfont);
                if (n3 > 0) {
                    if (n4 > 0) {
                        graphics.drawLine(this.base_x, n2, n, n2);
                        graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                        this.measure(graphics, n3, (n + this.base_x) / 2, n2, 5);
                        this.measure(graphics, n4, this.base_x, (n2 + this.base_y) / 2, 1);
                        this.measure(graphics, n5, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 6);
                    } else if (n4 < 0) {
                        graphics.drawLine(this.base_x, n2, n, n2);
                        graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                        this.measure(graphics, n3, (n + this.base_x) / 2, n2, 3);
                        this.measure(graphics, n4, this.base_x, (n2 + this.base_y) / 2, 1);
                        this.measure(graphics, n5, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 7);
                    } else {
                        this.measure(graphics, n5, (n + this.base_x) / 2, this.base_y, 6);
                    }
                } else if (n3 < 0) {
                    if (n4 > 0) {
                        graphics.drawLine(this.base_x, n2, n, n2);
                        graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                        this.measure(graphics, n3, (n + this.base_x) / 2, n2, 5);
                        this.measure(graphics, n4, this.base_x, (n2 + this.base_y) / 2, 0);
                        this.measure(graphics, n5, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 9);
                    } else if (n4 < 0) {
                        graphics.drawLine(this.base_x, n2, n, n2);
                        graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                        this.measure(graphics, n4, this.base_x, (n2 + this.base_y) / 2, 0);
                        this.measure(graphics, n3, (n + this.base_x) / 2, n2, 3);
                        this.measure(graphics, n5, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 8);
                    } else {
                        this.measure(graphics, n5, this.base_x, (n2 + this.base_y) / 2, 9);
                    }
                } else {
                    this.measure(graphics, n5, this.base_x, (n2 + this.base_y) / 2, 0);
                }
                graphics.setColor(color);
                break;
            }
            case 15: {
                int n6 = n - this.target_x;
                int n7 = n2 - this.target_y;
                int n8 = n;
                int n9 = n2;
                if (Math.abs(n6) > Math.abs(n7)) {
                    n9 = this.target_y;
                } else {
                    n8 = this.target_x;
                }
                graphics.drawLine(this.base_x, this.base_y, n8, n9);
                break;
            }
            case 3: {
                graphics.drawLine(this.base_x, this.base_y, n, n2);
                graphics.drawLine(this.base2_x, this.base2_y, n, n2);
                break;
            }
            case 16: {
                int n10 = n - this.target_x;
                int n11 = n2 - this.target_y;
                int n12 = n;
                int n13 = n2;
                if (Math.abs(n10) > Math.abs(n11)) {
                    n13 = this.target_y;
                } else {
                    n12 = this.target_x;
                }
                graphics.drawLine(this.base_x, this.base_y, n12, n13);
                graphics.drawLine(this.base2_x, this.base2_y, n12, n13);
                break;
            }
            case 4: {
                int n14 = n - this.base_x;
                int n15 = n2 - this.base_y;
                graphics.drawLine(this.base_x, this.base_y, n, this.base_y);
                graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                if (n15 != 0) {
                    graphics.drawLine(this.base_x, n2, n, n2);
                }
                if (n14 != 0) {
                    graphics.drawLine(n, this.base_y, n, n2);
                }
                if (!this.showLineLengthsEnable) break;
                Color color = graphics.getColor();
                graphics.setFont(this.mfont);
                if (n14 > 0) {
                    this.measure(graphics, n14, n, (n2 + this.base_y) / 2, 0);
                } else if (n14 < 0) {
                    this.measure(graphics, n14, n, (n2 + this.base_y) / 2, 1);
                }
                if (n15 > 0) {
                    this.measure(graphics, n15, (n + this.base_x) / 2, n2, 5);
                } else if (n15 < 0) {
                    this.measure(graphics, n15, (n + this.base_x) / 2, n2, 3);
                }
                graphics.setColor(color);
                break;
            }
            case 17: {
                int n16 = n - this.target_x;
                int n17 = n2 - this.target_y;
                int n18 = n;
                int n19 = n2;
                if (Math.abs(n16) > Math.abs(n17)) {
                    n19 = this.target_y;
                } else {
                    n18 = this.target_x;
                }
                graphics.drawLine(this.base_x, this.base_y, this.base_x, n19);
                graphics.drawLine(this.base_x, this.base_y, n18, this.base_y);
                if (n18 != this.base_x) {
                    graphics.drawLine(this.base_x, n19, n18, n19);
                }
                if (n19 == this.base_y) break;
                graphics.drawLine(n18, this.base_y, n18, n19);
                break;
            }
            case 5: {
                graphics.drawRect(this.offset_x + n, this.offset_y + n2, this.dx, this.dy);
                break;
            }
            case 13: {
                int n20 = n;
                int n21 = n2;
                if (Math.abs(n20 - this.base_x) > Math.abs(n21 - this.base_y)) {
                    n21 = this.base_y;
                } else {
                    n20 = this.base_x;
                }
                graphics.drawRect(this.offset_x + n20, this.offset_y + n21, this.dx, this.dy);
                break;
            }
            case 6: {
                int n22 = Math.max(Math.abs(n - this.base_x), Math.abs(n2 - this.base_y));
                graphics.drawOval(this.base_x - n22, this.base_y - n22, 2 * n22, 2 * n22);
                break;
            }
            case 20: {
                int n23 = n - this.base_x;
                int n24 = n2 - this.base_y;
                int n25 = (int)Math.sqrt(n23 * n23 + n24 * n24);
                graphics.drawOval(this.base_x - n25, this.base_y - n25, 2 * n25, 2 * n25);
                break;
            }
            case 7: {
                int n26 = n < this.base_x ? n : 2 * this.base_x - n;
                int n27 = n2 < this.base_y ? n2 : 2 * this.base_y - n2;
                graphics.drawOval(n26, n27, Math.abs(2 * (n - this.base_x)), Math.abs(2 * (n2 - this.base_y)));
                break;
            }
            case 8: {
                graphics.drawPolygon(this.pg);
                break;
            }
            case 11: {
                int n28 = n < this.base_x ? n : 2 * this.base_x - n;
                int n29 = n2 < this.base_y ? n2 : 2 * this.base_y - n2;
                graphics.drawRect(n28, n29, Math.abs(2 * (n - this.base_x)), Math.abs(2 * (n2 - this.base_y)));
                break;
            }
            case 14: {
                n2 = this.base_y + (int)(this.aspect * (double)(n - this.base_x) + 0.5);
                int n30 = n < this.base_x ? n : 2 * this.base_x - n;
                int n31 = n2 < this.base_y ? n2 : 2 * this.base_y - n2;
                graphics.drawRect(n30, n31, Math.abs(2 * (n - this.base_x)), Math.abs(2 * (n2 - this.base_y)));
                break;
            }
            case 12: {
                graphics.drawLine(this.base2_x, this.base2_y, this.base_x, this.base_y);
                graphics.drawLine(this.base2_x, this.base2_y, n, n2);
                break;
            }
            case 25: {
                Point point = this.geometryManager.getNearestAllowedPoint(this.getBasePoint(), new Point(n, n2));
                graphics.drawLine(this.base_x, this.base_y, (int)point.x, (int)point.y);
                break;
            }
            case 21: {
                if (this.tmpObject == null) {
                    return;
                }
                Point point = this.tmpObject.getPosition();
                double d = this.trafo.screen_to_wc_x(n);
                double d2 = this.trafo.screen_to_wc_y(n2);
                double d3 = this.tmpOffset.x;
                double d4 = this.tmpOffset.y;
                this.tmpObject.move(d - point.x - d3, d2 - point.y - d4);
                this.tmpObject.paint(graphics, this.trafo);
                FigBbox figBbox = this.tmpObject.getBbox();
                Rectangle rectangle = figBbox.getScreenCoordsRectangle(this.trafo);
                this._old_bbox_x = rectangle.x;
                this._old_bbox_y = rectangle.y;
                this._old_bbox_w = rectangle.width;
                this._old_bbox_h = rectangle.height;
                break;
            }
            default: {
                System.out.println("FigCanvasRubberband.paintOnce(): mode not supported " + this.mode);
            }
        }
    }

    public Rectangle getRubberbandBoundingBox(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (this.mode) {
            case 0: 
            case 1: {
                n5 = Math.min(n, n3) - 3;
                n6 = Math.min(n2, n4) - 3;
                n7 = Math.max(n, n3) - n5 + 7;
                n8 = Math.max(n2, n4) - n6 + 7;
                break;
            }
            case 2: {
                if (this.showLineLengthsEnable) {
                    n5 = this.min(n, n3, this.base_x) - 60;
                    n6 = this.min(n2, n4, this.base_y) - 20;
                    n7 = this.max(n, n3, this.base_x) - n5 + 121;
                    n8 = this.max(n2, n4, this.base_y) - n6 + 41;
                    break;
                }
                n5 = this.min(n, n3, this.base_x);
                n6 = this.min(n2, n4, this.base_y);
                n7 = this.max(n, n3, this.base_x) - n5 + 1;
                n8 = this.max(n2, n4, this.base_y) - n6 + 1;
                break;
            }
            case 15: {
                int n9 = n3;
                int n10 = n4;
                if (Math.abs(n9 - this.target_x) > Math.abs(n10 - this.target_y)) {
                    n10 = this.target_y;
                } else {
                    n9 = this.target_x;
                }
                int n11 = n;
                int n12 = n2;
                if (Math.abs(n11 - this.target_x) > Math.abs(n12 - this.target_y)) {
                    n12 = this.target_y;
                } else {
                    n11 = this.target_x;
                }
                n5 = this.min(this.base_x, n11, n9);
                n6 = this.min(this.base_y, n12, n10);
                n7 = this.max(this.base_x, n11, n9) + 1 - n5;
                n8 = this.max(this.base_y, n12, n10) + 1 - n6;
                break;
            }
            case 3: {
                n5 = this.min(n, n3, this.base_x, this.base2_x);
                n6 = this.min(n2, n4, this.base_y, this.base2_y);
                n7 = this.max(n, n3, this.base_x, this.base2_x) - n5 + 1;
                n8 = this.max(n2, n4, this.base_y, this.base2_y) - n6 + 1;
                break;
            }
            case 16: {
                int n9 = n3;
                int n13 = n4;
                if (Math.abs(n9 - this.target_x) > Math.abs(n13 - this.target_y)) {
                    n13 = this.target_y;
                } else {
                    n9 = this.target_x;
                }
                int n14 = n;
                int n15 = n2;
                if (Math.abs(n14 - this.target_x) > Math.abs(n15 - this.target_y)) {
                    n15 = this.target_y;
                } else {
                    n14 = this.target_x;
                }
                n5 = this.min(this.base_x, this.base2_x, n14, n9);
                n6 = this.min(this.base_y, this.base2_y, n15, n13);
                n7 = this.max(this.base_x, this.base2_x, n14, n9) + 1 - n5;
                n8 = this.max(this.base_y, this.base2_y, n15, n13) + 1 - n6;
                break;
            }
            case 4: {
                if (this.showLineLengthsEnable) {
                    n5 = this.min(n, n3, this.base_x) - 60;
                    n6 = this.min(n2, n4, this.base_y) - 20;
                    n7 = this.max(n, n3, this.base_x) - n5 + 121;
                    n8 = this.max(n2, n4, this.base_y) - n6 + 41;
                    break;
                }
                n5 = this.min(n, n3, this.base_x);
                n6 = this.min(n2, n4, this.base_y);
                n7 = this.max(n, n3, this.base_x) - n5 + 1;
                n8 = this.max(n2, n4, this.base_y) - n6 + 1;
                break;
            }
            case 17: {
                int n9 = n3;
                int n16 = n4;
                if (Math.abs(n9 - this.target_x) > Math.abs(n16 - this.target_y)) {
                    n16 = this.target_y;
                } else {
                    n9 = this.target_x;
                }
                int n17 = n;
                int n18 = n2;
                if (Math.abs(n17 - this.target_x) > Math.abs(n18 - this.target_y)) {
                    n18 = this.target_y;
                } else {
                    n17 = this.target_x;
                }
                n5 = this.min(this.base_x, n17, n9);
                n6 = this.min(this.base_y, n18, n16);
                n7 = this.max(this.base_x, n17, n9) + 1 - n5;
                n8 = this.max(this.base_y, n18, n16) + 1 - n6;
                break;
            }
            case 5: {
                n5 = Math.min(n, n3) - Math.abs(this.offset_x);
                n6 = Math.min(n2, n4) - Math.abs(this.offset_y);
                n7 = this.dx + 2 * Math.abs(this.offset_x) + Math.abs(n - n3) + 1;
                n8 = this.dy + 2 * Math.abs(this.offset_y) + Math.abs(n2 - n4) + 1;
                break;
            }
            case 13: {
                int n9 = n3;
                int n19 = n4;
                if (Math.abs(n9 - this.base_x) > Math.abs(n19 - this.base_y)) {
                    n19 = this.base_y;
                } else {
                    n9 = this.base_x;
                }
                int n20 = n;
                int n21 = n2;
                if (Math.abs(n20 - this.base_x) > Math.abs(n21 - this.base_y)) {
                    n21 = this.base_y;
                } else {
                    n20 = this.base_x;
                }
                int n22 = this.min(n3, n, n20, n9) - Math.abs(this.offset_x);
                int n23 = this.min(n4, n2, n21, n19) - Math.abs(this.offset_y);
                int n24 = this.max(n3, n, n20, n9) + Math.abs(this.offset_x);
                int n25 = this.max(n4, n2, n21, n19) + Math.abs(this.offset_y);
                n5 = n22;
                n6 = n23;
                n7 = n24 - n22 + this.dx + 1;
                n8 = n25 - n23 + this.dy + 1;
                break;
            }
            case 20: {
                int n26 = n3 - this.base_x;
                int n27 = n4 - this.base_y;
                int n28 = (int)Math.sqrt(n26 * n26 + n27 * n27);
                int n29 = n - this.base_x;
                int n30 = n2 - this.base_y;
                int n31 = (int)Math.sqrt(n29 * n29 + n30 * n30);
                int n32 = Math.max(n28, n31);
                n5 = this.base_x - n32;
                n6 = this.base_y - n32;
                n7 = 2 * n32 + 1;
                n8 = 2 * n32 + 1;
                break;
            }
            case 6: {
                int n33 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n4 - this.base_y));
                int n34 = Math.max(Math.abs(n - this.base_x), Math.abs(n2 - this.base_y));
                int n35 = Math.max(n33, n34);
                n5 = this.base_x - n35;
                n6 = this.base_y - n35;
                n7 = 2 * n35 + 1;
                n8 = 2 * n35 + 1;
                break;
            }
            case 7: {
                int n36 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n - this.base_x));
                int n37 = Math.max(Math.abs(n4 - this.base_y), Math.abs(n2 - this.base_y));
                n5 = this.base_x - n36;
                n6 = this.base_y - n37;
                n7 = 2 * n36 + 1;
                n8 = 2 * n37 + 1;
                break;
            }
            case 8: {
                Rectangle rectangle = this.pg.getBounds();
                n5 = rectangle.x;
                n6 = rectangle.y;
                n7 = rectangle.width;
                n8 = rectangle.height;
                break;
            }
            case 11: {
                int n38 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n - this.base_x));
                int n39 = Math.max(Math.abs(n4 - this.base_y), Math.abs(n2 - this.base_y));
                n5 = this.base_x - n38;
                n6 = this.base_y - n39;
                n7 = 2 * n38 + 1;
                n8 = 2 * n39 + 1;
                break;
            }
            case 14: {
                n2 = this.base_y + (int)(this.aspect * (double)(n - this.base_x) + 0.5);
                n4 = this.base_y + (int)(this.aspect * (double)(n3 - this.base_x) + 0.5);
                int n40 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n - this.base_x));
                int n41 = Math.max(Math.abs(n4 - this.base_y), Math.abs(n2 - this.base_y));
                n5 = this.base_x - n40 - 5;
                n6 = this.base_y - n41 - 5;
                n7 = 2 * n40 + 1 + 10;
                n8 = 2 * n41 + 1 + 10;
                break;
            }
            case 12: {
                n5 = this.min(n, n3, this.base_x, this.base2_x);
                n6 = this.min(n2, n4, this.base_y, this.base2_y);
                n7 = this.max(n, n3, this.base_x, this.base2_x) - n5 + 1;
                n8 = this.max(n2, n4, this.base_y, this.base2_y) - n6 + 1;
                break;
            }
            case 25: {
                Point point = new Point(this.base_x, this.base_y);
                Point point2 = new Point(n, n2);
                Point point3 = this.geometryManager.getNearestAllowedPoint(point, point2);
                Point point4 = new Point(n3, n4);
                Point point5 = this.geometryManager.getNearestAllowedPoint(point, point4);
                n5 = this.min(point2.x, point4.x, point3.x, point5.x, point.x);
                n6 = this.min(point2.y, point4.y, point3.y, point5.y, point.y);
                n7 = this.max(point2.x, point4.x, point3.x, point5.x, point.x) - n5 + 1;
                n8 = this.max(point2.y, point4.y, point3.y, point5.y, point.y) - n6 + 1;
                break;
            }
            case 21: 
            case 4711: {
                FigBbox figBbox = this.tmpObject.getBbox();
                Rectangle rectangle = figBbox.getScreenCoordsRectangle(this.trafo);
                n5 = this.min(this._old_bbox_x, rectangle.x, n3 - Math.abs(this.offset_x)) - 40;
                n6 = this.min(this._old_bbox_y, rectangle.y, n4 - Math.abs(this.offset_y)) - 50;
                n7 = this.max(this._old_bbox_x + this._old_bbox_w, rectangle.x + rectangle.width, n3 + Math.abs(this.offset_x)) - n5 + 100;
                n8 = this.max(this._old_bbox_y + this._old_bbox_h, rectangle.y + rectangle.height, n4 + Math.abs(this.offset_y)) - n6 + 100;
                break;
            }
            case 4712: {
                n5 = Math.min(n, n3) - Math.abs(this.offset_x);
                n6 = Math.min(n2, n4) - Math.abs(this.offset_y);
                n7 = this.dx + 2 * Math.abs(this.offset_x) + Math.abs(n - n3) + 1;
                n8 = this.dy + 2 * Math.abs(this.offset_y) + Math.abs(n2 - n4) + 1;
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
        return rectangle;
    }

    void measure(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = 33.333333333333336;
        double d2 = d * (double)n / this.trafo.getZoomFactor();
        double d3 = this.trafo.getValueInUnits(d2);
        String string = new Format("%4.3f").form(d3);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getMaxAscent();
        int n7 = fontMetrics.getMaxDescent();
        graphics.setColor(Color.red);
        switch (n4) {
            case 0: {
                graphics.drawString(string, n2 + 5, n3);
                break;
            }
            case 1: {
                graphics.drawString(string, n2 - 5 - n5, n3);
                break;
            }
            case 2: {
                graphics.drawString(string, n2 - n5 / 2, n3);
                break;
            }
            case 3: {
                graphics.drawString(string, n2 - n5 / 2, n3 - 5);
                break;
            }
            case 5: {
                graphics.drawString(string, n2 - n5 / 2, n3 + 5 + n6);
                break;
            }
            case 6: {
                graphics.drawString(string, n2 + 5, n3 - 5);
                break;
            }
            case 7: {
                graphics.drawString(string, n2 + 5, n3 + 5 + n6);
                break;
            }
            case 9: {
                graphics.drawString(string, n2 - 5 - n5, n3 - 5);
                break;
            }
            case 8: {
                graphics.drawString(string, n2 - 5 - n5, n3 + 5 + n6);
                break;
            }
            default: {
                throw new RuntimeException("unknown alignment" + n4);
            }
        }
    }

    public int min(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }

    public int min(double d, double d2, double d3) {
        return (int)Math.min(d, Math.min(d2, d3));
    }

    public int min(int n, int n2, int n3, int n4) {
        return Math.min(Math.min(n, n2), Math.min(n3, n4));
    }

    public int min(double d, double d2, double d3, double d4) {
        return (int)Math.min(Math.min(d, d2), Math.min(d3, d4));
    }

    public int min(int n, int n2, int n3, int n4, int n5) {
        return this.min(n, n2, this.min(n3, n4, n5));
    }

    public int min(double d, double d2, double d3, double d4, double d5) {
        return this.min(d, d2, (double)this.min(d3, d4, d5));
    }

    public int max(int n, int n2, int n3) {
        return Math.max(n, Math.max(n2, n3));
    }

    public int max(double d, double d2, double d3) {
        return (int)Math.max(d, Math.max(d2, d3));
    }

    public int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    public int max(double d, double d2, double d3, double d4) {
        return (int)Math.max(Math.max(d, d2), Math.max(d3, d4));
    }

    public int max(int n, int n2, int n3, int n4, int n5) {
        return this.max(n, n2, this.max(n3, n4, n5));
    }

    public int max(double d, double d2, double d3, double d4, double d5) {
        return this.max(d, d2, (double)this.max(d3, d4, d5));
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.showLineLengthsEnable = false;
        this.mfont = new Font("Monospaced", 0, 10);
        this.geometryManager = null;
    }

    public FigCanvasRubberband(FigTrafo2D figTrafo2D) {
        this.this();
        this.mode = 1;
        this.trafo = figTrafo2D;
    }
}

