/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.runner.info.MissingVepException;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataParser;
import org.springframework.stereotype.Component;

@Component
public class VepMetadataParserImpl
implements VepMetadataParser {
    private final VepMetadataMapper mapper;

    public VepMetadataParserImpl(VepMetadataMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public NestedHeaderLine map(VCFHeader header) {
        for (VCFInfoHeaderLine headerLine : header.getInfoHeaderLines()) {
            if (!this.mapper.canMap(headerLine)) continue;
            return this.mapper.map(headerLine);
        }
        throw new MissingVepException();
    }
}

