/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataMapper;
import org.springframework.stereotype.Component;

@Component
public class VepInfoMetadataMapper
implements VepMetadataMapper {
    public static final String ALLELE_NUM = "ALLELE_NUM";
    private static final String INFO_DESCRIPTION_PREFIX = "Consequence annotations from Ensembl VEP. Format: ";

    @Override
    public boolean canMap(VCFInfoHeaderLine vcfInfoHeaderLine) {
        String description = vcfInfoHeaderLine.getDescription();
        return description.startsWith(INFO_DESCRIPTION_PREFIX);
    }

    @Override
    public NestedHeaderLine map(VCFInfoHeaderLine vcfInfoHeaderLine) {
        HashMap<String, NestedField> nestedFields = new HashMap<String, NestedField>();
        int index = 0;
        FieldImpl vepField = FieldImpl.builder().id(vcfInfoHeaderLine.getID()).fieldType(FieldType.INFO).valueType(ValueType.STRING).valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).separator(Character.valueOf('|')).build();
        for (String id : this.getNestedInfoIds(vcfInfoHeaderLine)) {
            nestedFields.put(id, this.mapNestedMetadataToField(id, index, vepField));
            ++index;
        }
        return NestedHeaderLine.builder().parentField(vepField).nestedFields(nestedFields).build();
    }

    protected List<String> getNestedInfoIds(VCFInfoHeaderLine vcfInfoHeaderLine) {
        String description = vcfInfoHeaderLine.getDescription();
        String[] infoIds = description.substring(INFO_DESCRIPTION_PREFIX.length()).split("\\|", -1);
        return Arrays.asList(infoIds);
    }

    protected NestedField mapNestedMetadataToField(String id, int index, FieldImpl vepField) {
        NestedField.NestedFieldBuilder fieldBuilder = NestedField.nestedBuilder().id(id).index(index).parent(vepField).fieldType(FieldType.INFO_VEP);
        switch (id) {
            case "PICK": 
            case "ALLELE_NUM": {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.INTEGER);
                break;
            }
            case "Consequence": 
            case "Existing_variation": 
            case "CLIN_SIG": 
            case "FLAGS": 
            case "clinVar_CLNSIGINCL": 
            case "clinVar_CLNREVSTAT": 
            case "HPO": {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).valueType(ValueType.STRING).separator(Character.valueOf('&'));
                break;
            }
            case "clinVar_CLNSIG": {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).valueType(ValueType.STRING).separator(Character.valueOf('/'));
                break;
            }
            case "PHENO": 
            case "PUBMED": 
            case "SOMATIC": 
            case "clinVar": {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).valueType(ValueType.INTEGER).separator(Character.valueOf('&'));
                break;
            }
            case "STRAND": 
            case "HGNC_ID": 
            case "cDNA_position": 
            case "CDS_position": 
            case "Protein_position": 
            case "gnomAD_HN": {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.INTEGER);
                break;
            }
            case "gnomAD_AF": 
            case "gnomAD_AFR_AF": 
            case "gnomAD_AMR_AF": 
            case "gnomAD_ASJ_AF": 
            case "gnomAD_EAS_AF": 
            case "gnomAD_FIN_AF": 
            case "gnomAD_NFE_AF": 
            case "gnomAD_OTH_AF": 
            case "gnomAD_SAS_AF": 
            case "SpliceAI_pred_DS_AG": 
            case "SpliceAI_pred_DS_AL": 
            case "SpliceAI_pred_DS_DG": 
            case "SpliceAI_pred_DS_DL": 
            case "SIFT": 
            case "PolyPhen": 
            case "CAPICE_CL": 
            case "CAPICE_SC": {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.FLOAT);
                break;
            }
            default: {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.STRING);
            }
        }
        return fieldBuilder.build();
    }
}

