/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner.info;

import java.util.HashMap;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.model.FieldImpl;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.GenotypeFieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.runner.info.GenotypeMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;
import org.springframework.stereotype.Component;

@Component
public class GenotypeMetadataMapperImpl
implements GenotypeMetadataMapper {
    public static final String GENOTYPE = "GENOTYPE";

    @Override
    public NestedHeaderLine map() {
        HashMap<String, NestedField> nestedFields = new HashMap<String, NestedField>();
        int index = 0;
        FieldImpl genotypeParentField = FieldImpl.builder().id(GENOTYPE).fieldType(FieldType.FORMAT).valueType(ValueType.STRING).valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).build();
        for (GenotypeFieldType genotypeFieldType : GenotypeFieldType.values()) {
            nestedFields.put(genotypeFieldType.name(), this.mapNestedMetadataToField(genotypeFieldType, index, genotypeParentField));
            ++index;
        }
        return NestedHeaderLine.builder().parentField(genotypeParentField).nestedFields(nestedFields).build();
    }

    protected NestedField mapNestedMetadataToField(GenotypeFieldType genotypeFieldType, int index, FieldImpl vepField) {
        NestedField.NestedFieldBuilder fieldBuilder = NestedField.nestedBuilder().id(genotypeFieldType.name()).index(index).parent(vepField).fieldType(FieldType.GENOTYPE);
        switch (genotypeFieldType) {
            case ALLELES: {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).valueType(ValueType.STRING);
                break;
            }
            case ALLELE_NUM: {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.VARIABLE).build()).valueType(ValueType.INTEGER);
                break;
            }
            case PLOIDY: {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.INTEGER);
                break;
            }
            case PHASED: 
            case CALLED: 
            case MIXED: 
            case NON_INFORMATIVE: {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.FLAG);
                break;
            }
            case TYPE: {
                fieldBuilder.valueCount(ValueCount.builder().type(ValueCount.Type.FIXED).count(1).build()).valueType(ValueType.STRING);
                break;
            }
            default: {
                throw new UnexpectedEnumException(genotypeFieldType);
            }
        }
        return fieldBuilder.build();
    }
}

