/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.molgenis.vcf.decisiontree.filter.UnknownFieldException;
import org.molgenis.vcf.decisiontree.filter.VcfRecord;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.NestedField;
import org.molgenis.vcf.decisiontree.runner.info.NestedHeaderLine;

public class VepHelper {
    public Map<Integer, List<VcfRecord>> getRecordPerConsequence(VcfRecord vcfRecord, NestedHeaderLine nestedHeaderLine) {
        List<String> consequences = vcfRecord.getVepValues(nestedHeaderLine.getParentField());
        HashMap<Integer, List<VcfRecord>> records = new HashMap<Integer, List<VcfRecord>>();
        for (String consequence : consequences) {
            Field field = nestedHeaderLine.getField("ALLELE_NUM");
            if (!(field instanceof NestedField)) {
                throw new UnknownFieldException("ALLELE_NUM", FieldType.INFO_VEP);
            }
            NestedField alleleField = (NestedField)field;
            int alleleNumIndex = alleleField.getIndex();
            int index = Integer.parseInt(consequence.split("\\|")[alleleNumIndex]);
            List<VcfRecord> singleCsqRecord = records.containsKey(index) ? (List)records.get(index) : new ArrayList<VcfRecord>();
            singleCsqRecord.add(vcfRecord.getFilteredCopy(consequence, nestedHeaderLine.getParentField()));
            records.put(index, singleCsqRecord);
        }
        return records;
    }

    public VcfRecord createEmptyCsqRecord(VcfRecord vcfRecord, Integer alleleIndex, NestedHeaderLine nestedHeaderLine) {
        Map<String, NestedField> fields = nestedHeaderLine.getNestedFields();
        ArrayList<String> values = new ArrayList<String>();
        for (int index = 0; index < fields.size(); ++index) {
            values.add("");
        }
        values.set(fields.get("ALLELE_NUM").getIndex(), alleleIndex.toString());
        VariantContext variantContext = vcfRecord.getVariantContext();
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(variantContext);
        variantContextBuilder.attribute(nestedHeaderLine.getParentField().getId(), Collections.singletonList(Strings.join(values, '|')));
        return new VcfRecord(variantContextBuilder.make());
    }
}

