/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.vcf.VCFFileReader;
import java.nio.file.Path;
import java.util.Objects;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.VcfReader;
import org.molgenis.vcf.decisiontree.runner.VcfReaderFactory;
import org.molgenis.vcf.decisiontree.runner.info.GenotypeMetadataMapper;
import org.molgenis.vcf.decisiontree.runner.info.VepMetadataParser;
import org.springframework.stereotype.Component;

@Component
class VcfReaderFactoryImpl
implements VcfReaderFactory {
    private final GenotypeMetadataMapper genotypeMetadataMapper;
    private VepMetadataParser vepMetadataParser;

    VcfReaderFactoryImpl(VepMetadataParser vepMetadataParser, GenotypeMetadataMapper genotypeMetadataMapper) {
        this.vepMetadataParser = Objects.requireNonNull(vepMetadataParser);
        this.genotypeMetadataMapper = Objects.requireNonNull(genotypeMetadataMapper);
    }

    @Override
    public VcfReader create(Settings settings) {
        Path inputVcfPath = settings.getInputVcfPath();
        boolean strict = settings.isStrict();
        return new VcfReader(new VCFFileReader(inputVcfPath.toFile(), false), this.vepMetadataParser, this.genotypeMetadataMapper, strict);
    }
}

