/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import htsjdk.variant.variantcontext.GenotypeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.SampleFieldType;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidationException;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigOperator;
import org.molgenis.vcf.decisiontree.ped.model.AffectedStatus;
import org.molgenis.vcf.decisiontree.ped.model.Sex;

public class ValueValidator {
    public static final String MESSAGE = "Query value '%s' is of type '%s' while INFO field is of type '%s' for node '%s'.";
    public static final String INVALID_ENUM_MESSAGE = "Value '%s' is not a valid value for '%s', valid values: %s.";

    private ValueValidator() {
    }

    public static void validate(ConfigDecisionTree configDecisionTree, VcfMetadata vcfMetadata) {
        Map<String, ConfigNode> nodes = configDecisionTree.getNodes();
        nodes.forEach((key, value) -> ValueValidator.validateValue(key, value, vcfMetadata));
    }

    private static void validateValue(String nodeId, ConfigNode node, VcfMetadata vcfMetadata) {
        switch (node.getType()) {
            case BOOL: {
                ConfigBoolNode boolNode = (ConfigBoolNode)node;
                ValueValidator.validateQueryValue(nodeId, boolNode.getQuery(), vcfMetadata);
                break;
            }
            case BOOL_MULTI: {
                ConfigBoolMultiNode boolMultiNode = (ConfigBoolMultiNode)node;
                boolMultiNode.getOutcomes().forEach(configBoolMultiQuery -> configBoolMultiQuery.getQueries().forEach(query -> ValueValidator.validateQueryValue(nodeId, query, vcfMetadata)));
                break;
            }
            case CATEGORICAL: 
            case EXISTS: 
            case LEAF: {
                break;
            }
            default: {
                throw new UnexpectedEnumException(node.getType());
            }
        }
    }

    private static void validateQueryValue(String nodeId, ConfigBoolQuery query, VcfMetadata vcfMetadata) {
        Field field = vcfMetadata.getField(query.getField());
        if (!(field instanceof MissingField)) {
            Object value = query.getValue();
            ValueValidator.validateEnumFields(field, value);
            ValueValidator.validateQueryValue(nodeId, field, query);
        }
    }

    private static void validateEnumFields(Field field, Object value) {
        String genotypeTypeField = "TYPE";
        String sexField = SampleFieldType.SEX.name();
        String affectedField = SampleFieldType.AFFECTED_STATUS.name();
        if (field.getId().equals(genotypeTypeField) && field.getFieldType() == FieldType.GENOTYPE) {
            if (Arrays.stream(GenotypeType.values()).map(Enum::name).noneMatch(enumValue -> enumValue.equals(value))) {
                throw new ConfigDecisionTreeValidationException(String.format(INVALID_ENUM_MESSAGE, value, sexField, Arrays.stream(GenotypeType.values()).map(Enum::name).toList()));
            }
        } else if (field.getFieldType() == FieldType.SAMPLE) {
            ValueValidator.validateSampleEnums(field, value, sexField, affectedField);
        }
    }

    private static void validateSampleEnums(Field field, Object value, String sexField, String affectedField) {
        if (field.getId().equals(sexField)) {
            if (Arrays.stream(Sex.values()).map(Enum::name).noneMatch(enumValue -> enumValue.equals(value))) {
                throw new ConfigDecisionTreeValidationException(String.format(INVALID_ENUM_MESSAGE, value, sexField, Arrays.stream(Sex.values()).map(Enum::name).toList()));
            }
        } else if (field.getId().equals(affectedField) && Arrays.stream(AffectedStatus.values()).map(Enum::name).noneMatch(enumValue -> enumValue.equals(value))) {
            throw new ConfigDecisionTreeValidationException(String.format(INVALID_ENUM_MESSAGE, value, affectedField, Arrays.stream(AffectedStatus.values()).map(Enum::name).toList()));
        }
    }

    private static void validateQueryValue(String nodeId, Field field, ConfigBoolQuery query) {
        Object value = query.getValue();
        ConfigOperator operator = query.getOperator();
        if (value instanceof Collection) {
            ((Collection)value).forEach(singleValue -> ValueValidator.validateSingleValue(nodeId, singleValue, field.getValueType()));
        } else {
            if (!VcfMetadata.isSingleValueField(field) && List.of(ConfigOperator.EQUALS, ConfigOperator.NOT_EQUALS).contains((Object)operator)) {
                throw new ConfigDecisionTreeValidationException(String.format("Field '%s' in node '%s' contains a collection of values, therefor the '%s' query value should also have a collection as value.", new Object[]{field.getId(), nodeId, operator}));
            }
            ValueValidator.validateSingleValue(nodeId, value, field.getValueType());
        }
    }

    private static void validateSingleValue(String nodeId, Object singleValue, ValueType valueType) {
        if (!singleValue.toString().startsWith("file:") && !singleValue.toString().startsWith("field:")) {
            ValueValidator.validateValueTypes(nodeId, singleValue, valueType);
        }
    }

    private static void validateValueTypes(String nodeId, Object singleValue, ValueType valueType) {
        switch (valueType) {
            case INTEGER: 
            case FLOAT: {
                if (Number.class.isAssignableFrom(singleValue.getClass())) break;
                throw new ConfigDecisionTreeValidationException(String.format(MESSAGE, new Object[]{singleValue, singleValue.getClass().getSimpleName(), valueType, nodeId}));
            }
            case FLAG: {
                if (Boolean.class.isAssignableFrom(singleValue.getClass())) break;
                throw new ConfigDecisionTreeValidationException(String.format(MESSAGE, new Object[]{singleValue, singleValue.getClass().getSimpleName(), valueType, nodeId}));
            }
            case STRING: {
                if (String.class.isAssignableFrom(singleValue.getClass())) break;
                throw new ConfigDecisionTreeValidationException(String.format(MESSAGE, new Object[]{singleValue, singleValue.getClass().getSimpleName(), valueType, nodeId}));
            }
            case CHARACTER: {
                if (!String.class.isAssignableFrom(singleValue.getClass())) {
                    throw new ConfigDecisionTreeValidationException(String.format(MESSAGE, new Object[]{singleValue, singleValue.getClass().getSimpleName(), valueType, nodeId}));
                }
                if (singleValue.toString().length() <= 1) break;
                throw new ConfigDecisionTreeValidationException(String.format("Value '%s' is more than one character long while the fieldtype of the field is 'CHARACTER' for node '%s'.", singleValue, nodeId));
            }
            default: {
                throw new UnexpectedEnumException(valueType);
            }
        }
    }
}

