/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.vcf.decisiontree.SampleSettings;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.SampleContext;
import org.molgenis.vcf.decisiontree.filter.model.SamplesContext;
import org.molgenis.vcf.decisiontree.ped.InvalidSamplePhenotypesException;
import org.molgenis.vcf.decisiontree.ped.MixedPhenotypesException;
import org.molgenis.vcf.decisiontree.ped.PedIndividual;
import org.molgenis.vcf.decisiontree.ped.PedReader;
import org.molgenis.vcf.decisiontree.ped.model.AffectedStatus;
import org.molgenis.vcf.decisiontree.ped.model.Sex;
import org.molgenis.vcf.decisiontree.runner.MissingProbandsException;

public class SamplesContextFactory {
    public static final String SAMPLE_PHENOTYPE_SEPARATOR = "/";
    public static final String PHENOTYPE_SEPARATOR = ";";

    private SamplesContextFactory() {
    }

    public static SamplesContext create(Settings settings, VcfMetadata vcfMetadata) {
        SampleSettings sampleSettings = settings.getSampleSettings();
        Map<String, Integer> vcfSampleNames = vcfMetadata.getSampleNameToOffset();
        List<String> probands = sampleSettings.getProbandNames();
        String phenotypesString = sampleSettings.getPhenotypeString();
        HashMap<String, List<String>> phenotypesPerSample = new HashMap<String, List<String>>();
        ArrayList<String> defaultPhenotypes = new ArrayList<String>();
        if (phenotypesString.contains(SAMPLE_PHENOTYPE_SEPARATOR)) {
            phenotypesPerSample.putAll(SamplesContextFactory.parseSamplePhenotypes(phenotypesString));
        } else {
            defaultPhenotypes.addAll(Arrays.asList(phenotypesString.split(PHENOTYPE_SEPARATOR)));
        }
        ArrayList<SampleContext> sampleContexts = new ArrayList<SampleContext>();
        LinkedHashSet<String> processedSamples = new LinkedHashSet<String>();
        for (Path pedigreePath : sampleSettings.getPedigreePaths()) {
            try (PedReader reader = new PedReader(new FileReader(pedigreePath.toFile()));){
                Map<String, SampleContext> sampleContextMap = SamplesContextFactory.parse(reader, probands, phenotypesPerSample, defaultPhenotypes, vcfSampleNames);
                sampleContexts.addAll(sampleContextMap.values());
                processedSamples.addAll(sampleContextMap.keySet());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (!vcfSampleNames.keySet().containsAll(probands)) {
            List<String> unmatchedProbands = probands.stream().filter(proband -> !vcfSampleNames.containsKey(proband)).toList();
            throw new MissingProbandsException(unmatchedProbands);
        }
        vcfSampleNames.keySet().stream().filter(sampleId -> !processedSamples.contains(sampleId)).forEach(sampleId -> sampleContexts.add(SamplesContextFactory.createDefaultSampleContext(sampleId, (Integer)vcfSampleNames.get(sampleId), defaultPhenotypes, phenotypesPerSample, probands)));
        return SamplesContext.builder().sampleContexts(sampleContexts.stream().filter(sampleContext -> sampleContext.getIndex() != -1).collect(Collectors.toSet())).build();
    }

    private static Map<String, List<String>> parseSamplePhenotypes(String phenotypesString) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String samplePhenotypes : phenotypesString.split(",")) {
            String[] split;
            if (samplePhenotypes.contains(SAMPLE_PHENOTYPE_SEPARATOR)) {
                split = samplePhenotypes.split(SAMPLE_PHENOTYPE_SEPARATOR);
                if (split.length != 2) {
                    throw new InvalidSamplePhenotypesException(samplePhenotypes);
                }
            } else {
                throw new MixedPhenotypesException();
            }
            String sampleId = split[0];
            String[] phenotypes = split[1].split(PHENOTYPE_SEPARATOR);
            result.put(sampleId, Arrays.asList(phenotypes));
        }
        return result;
    }

    public static SampleContext createDefaultSampleContext(String sampleId, Integer sampleIndex, List<String> defaultPhenotypes, Map<String, List<String>> phenotypesPerSample, List<String> probands) {
        return SampleContext.builder().id(sampleId).index(sampleIndex).affectedStatus(AffectedStatus.MISSING).sex(Sex.UNKNOWN).familyId(null).fatherId(null).motherId(null).proband(SamplesContextFactory.isProband(probands, sampleId)).phenotypes(SamplesContextFactory.getSamplePhenotypes(sampleId, AffectedStatus.MISSING, phenotypesPerSample, defaultPhenotypes)).build();
    }

    private static List<String> getSamplePhenotypes(String sampleId, AffectedStatus affectedStatus, Map<String, List<String>> phenotypesPerSample, List<String> defaultPhenotypes) {
        if (phenotypesPerSample.containsKey(sampleId)) {
            return phenotypesPerSample.get(sampleId);
        }
        if (affectedStatus != AffectedStatus.UNAFFECTED) {
            return defaultPhenotypes;
        }
        return Collections.emptyList();
    }

    private static Map<String, SampleContext> parse(PedReader reader, List<String> probands, Map<String, List<String>> phenotypesPerSample, List<String> defaultPhenotypes, Map<String, Integer> vcfSampleNames) {
        HashMap<String, SampleContext> samplesContextMap = new HashMap<String, SampleContext>();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(reader.iterator(), 0), false).filter(pedIndividual -> vcfSampleNames.containsKey(pedIndividual.getId())).map(individual -> SamplesContextFactory.map(individual, probands, SamplesContextFactory.getSamplePhenotypes(individual.getId(), SamplesContextFactory.map(individual.getAffectionStatus()), phenotypesPerSample, defaultPhenotypes), (Integer)vcfSampleNames.get(individual.getId()))).filter(person -> person.getIndex() != -1).forEach(person -> samplesContextMap.put(person.getId(), (SampleContext)person));
        return samplesContextMap;
    }

    private static SampleContext map(PedIndividual pedIndividual, List<String> probands, List<String> phenotypes, int index) {
        return SampleContext.builder().id(pedIndividual.getId()).index(index).affectedStatus(SamplesContextFactory.map(pedIndividual.getAffectionStatus())).sex(SamplesContextFactory.map(pedIndividual.getSex())).familyId(pedIndividual.getFamilyId()).fatherId(pedIndividual.getPaternalId()).motherId(pedIndividual.getMaternalId()).proband(SamplesContextFactory.isProband(probands, pedIndividual.getId())).phenotypes(phenotypes).build();
    }

    private static Sex map(PedIndividual.Sex sex) {
        switch (sex) {
            case MALE: {
                return Sex.MALE;
            }
            case FEMALE: {
                return Sex.FEMALE;
            }
        }
        return Sex.UNKNOWN;
    }

    private static AffectedStatus map(PedIndividual.AffectionStatus affectionStatus) {
        switch (affectionStatus) {
            case AFFECTED: {
                return AffectedStatus.AFFECTED;
            }
            case UNAFFECTED: {
                return AffectedStatus.UNAFFECTED;
            }
        }
        return AffectedStatus.MISSING;
    }

    private static boolean isProband(List<String> probands, String sampleId) {
        return probands.isEmpty() || probands.contains(sampleId);
    }
}

