/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.util.Collection;
import java.util.Set;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.model.DecisionType;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.MissingField;
import org.molgenis.vcf.decisiontree.filter.model.ValueCount;
import org.molgenis.vcf.decisiontree.filter.model.ValueType;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigOperator;
import org.molgenis.vcf.decisiontree.runner.CountMismatchException;
import org.molgenis.vcf.decisiontree.runner.FileValueNotAllowedException;
import org.molgenis.vcf.decisiontree.runner.QueryValidator;
import org.molgenis.vcf.decisiontree.runner.UnsupportedValueCountException;
import org.molgenis.vcf.decisiontree.runner.UnsupportedValueCountTypeException;
import org.molgenis.vcf.decisiontree.runner.UnsupportedValueTypeException;
import org.springframework.stereotype.Component;

@Component
public class QueryValidatorImpl
implements QueryValidator {
    public static final Set<ConfigOperator> ALLOWED_FILE_OPERATORS = Set.of(ConfigOperator.IN, ConfigOperator.NOT_IN);

    @Override
    public void validateBooleanNode(ConfigBoolQuery configBoolQuery, Field field) {
        if (!(field instanceof MissingField)) {
            switch (configBoolQuery.getOperator()) {
                case GREATER: 
                case LESS: 
                case LESS_OR_EQUAL: 
                case GREATER_OR_EQUAL: {
                    this.validateLesserGreater(field, configBoolQuery);
                    break;
                }
                case IN: 
                case NOT_IN: {
                    this.validateIn(field);
                    break;
                }
                case CONTAINS: 
                case NOT_CONTAINS: 
                case CONTAINS_ALL: 
                case CONTAINS_ANY: 
                case CONTAINS_NONE: {
                    this.validateContains(field, configBoolQuery);
                    break;
                }
                case EQUALS: 
                case NOT_EQUALS: {
                    this.validateEquals(field, configBoolQuery);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException(configBoolQuery.getOperator());
                }
            }
        }
    }

    private void validateFileValueAllowed(ConfigBoolQuery query, Field field) {
        ConfigOperator operator = query.getOperator();
        if (!ALLOWED_FILE_OPERATORS.contains((Object)operator) && query.getValue().toString().startsWith("file:")) {
            throw new FileValueNotAllowedException(operator, ALLOWED_FILE_OPERATORS.toString(), field.getId());
        }
    }

    private void validateLesserGreater(Field field, ConfigBoolQuery query) {
        this.validateFileValueAllowed(query, field);
        if (field.getValueType() != ValueType.FLOAT && field.getValueType() != ValueType.INTEGER) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        this.validateSingleOrPerAlleleCount(field, DecisionType.BOOL);
    }

    private void validateEquals(Field field, ConfigBoolQuery configBoolQuery) {
        this.validateFileValueAllowed(configBoolQuery, field);
        if (field.getSeparator() != null && !(configBoolQuery.getValue() instanceof Collection)) {
            throw new CountMismatchException(configBoolQuery);
        }
    }

    private void validateIn(Field field) {
        if (field.getValueType() == ValueType.FLAG || field.getValueType() == ValueType.FLOAT) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        this.validateSingleOrPerAlleleCount(field, DecisionType.BOOL);
    }

    private void validateContains(Field field, ConfigBoolQuery configBoolQuery) {
        this.validateFileValueAllowed(configBoolQuery, field);
        if (field.getValueType() == ValueType.FLAG || field.getValueType() == ValueType.FLOAT) {
            throw new UnsupportedValueTypeException(field, DecisionType.BOOL);
        }
        if (field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() == 1) {
            throw new UnsupportedValueCountException(field, DecisionType.BOOL);
        }
    }

    private void validateSingleOrPerAlleleCount(Field field, DecisionType decisionType) {
        if (field.getValueCount().getType() == ValueCount.Type.G || field.getValueCount().getType() == ValueCount.Type.VARIABLE) {
            throw new UnsupportedValueCountTypeException(field, decisionType);
        }
        if (field.getValueCount().getType() == ValueCount.Type.FIXED && field.getValueCount().getCount() != 1) {
            throw new UnsupportedValueCountException(field, decisionType);
        }
    }

    @Override
    public void validateCategoricalNode(Field field) {
        if (!(field instanceof MissingField)) {
            if (field.getValueType() == ValueType.FLAG || field.getValueType() == ValueType.FLOAT) {
                throw new UnsupportedValueTypeException(field, DecisionType.CATEGORICAL);
            }
            this.validateSingleOrPerAlleleCount(field, DecisionType.CATEGORICAL);
        }
    }
}

