/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolMultiQuery;
import org.molgenis.vcf.decisiontree.filter.model.BoolNode;
import org.molgenis.vcf.decisiontree.filter.model.BoolQuery;
import org.molgenis.vcf.decisiontree.filter.model.CategoricalNode;
import org.molgenis.vcf.decisiontree.filter.model.DecisionTree;
import org.molgenis.vcf.decisiontree.filter.model.ExistsNode;
import org.molgenis.vcf.decisiontree.filter.model.Field;
import org.molgenis.vcf.decisiontree.filter.model.Label;
import org.molgenis.vcf.decisiontree.filter.model.LeafNode;
import org.molgenis.vcf.decisiontree.filter.model.Node;
import org.molgenis.vcf.decisiontree.filter.model.NodeOutcome;
import org.molgenis.vcf.decisiontree.filter.model.NodeType;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigCategoricalNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigClauseOperator;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigExistsNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigLabel;
import org.molgenis.vcf.decisiontree.loader.model.ConfigLeafNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNodeOutcome;
import org.molgenis.vcf.decisiontree.loader.model.ConfigOperator;
import org.molgenis.vcf.decisiontree.runner.DecisionTreeFactory;
import org.molgenis.vcf.decisiontree.runner.QueryValidator;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
class DecisionTreeFactoryImpl
implements DecisionTreeFactory {
    public static final String FILE_COMMENT_CHARACTER = "#";
    private final QueryValidator queryValidator;

    DecisionTreeFactoryImpl(QueryValidator queryValidator) {
        this.queryValidator = Objects.requireNonNull(queryValidator);
    }

    @Override
    public DecisionTree map(VcfMetadata vcfMetadata, Settings settings) {
        ConfigDecisionTree configDecisionTree = settings.getConfigDecisionTree();
        Map<String, Label> labelMap = this.mapLabels(configDecisionTree.getLabels());
        Map<String, Set<String>> filesMap = this.mapFiles(configDecisionTree.getFiles());
        Map<String, Node> nodeMap = this.mapNodes(vcfMetadata, configDecisionTree.getNodes(), labelMap, filesMap);
        Node rootNode = nodeMap.get(configDecisionTree.getRootNode());
        return DecisionTree.builder().rootNode(rootNode).build();
    }

    private Map<String, Set<String>> mapFiles(Map<String, Path> files) {
        Map<String, Set<String>> filesMap;
        if (files == null) {
            filesMap = Collections.emptyMap();
        } else {
            filesMap = new HashMap();
            files.entrySet().forEach(entry -> filesMap.put((String)entry.getKey(), this.mapFile((Path)entry.getValue())));
        }
        return filesMap;
    }

    private Set<String> mapFile(Path path) {
        try {
            return Files.readAllLines(path).stream().filter(value -> !value.startsWith(FILE_COMMENT_CHARACTER) && !value.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<String, Label> mapLabels(@Nullable Map<String, ConfigLabel> configLabels) {
        Map<String, Label> labelMap = configLabels == null ? Collections.emptyMap() : configLabels.entrySet().stream().map(entry -> this.mapLabel((String)entry.getKey(), (ConfigLabel)entry.getValue())).collect(Collectors.toMap(Label::getId, Function.identity()));
        return labelMap;
    }

    private Label mapLabel(String id, ConfigLabel configLabel) {
        return Label.builder().id(id).description(configLabel.getDescription()).build();
    }

    private Map<String, Node> mapNodes(VcfMetadata vcfMetadata, Map<String, ConfigNode> configNodeMap, Map<String, Label> labelMap, Map<String, Set<String>> files) {
        Map<String, Node> nodeMap = configNodeMap.entrySet().stream().map(entry -> this.toNode(vcfMetadata, (String)entry.getKey(), (ConfigNode)entry.getValue(), files)).collect(Collectors.toMap(Node::getId, Function.identity()));
        nodeMap.values().forEach(node -> {
            ConfigNode configNode = (ConfigNode)configNodeMap.get(node.getId());
            this.updateNode((Node)node, configNode, nodeMap, labelMap);
        });
        return nodeMap;
    }

    private Node toNode(VcfMetadata vcfMetadata, String id, ConfigNode configNode, Map<String, Set<String>> files) {
        return switch (configNode.getType()) {
            case ConfigNode.Type.EXISTS -> this.toExistsNode(vcfMetadata, id, (ConfigExistsNode)configNode);
            case ConfigNode.Type.BOOL -> this.toBoolNode(vcfMetadata, id, (ConfigBoolNode)configNode, files);
            case ConfigNode.Type.BOOL_MULTI -> this.toBoolMultiNode(vcfMetadata, id, (ConfigBoolMultiNode)configNode, files);
            case ConfigNode.Type.CATEGORICAL -> this.toCategoricalNode(vcfMetadata, id, (ConfigCategoricalNode)configNode);
            case ConfigNode.Type.LEAF -> this.toLeafNode(id, (ConfigLeafNode)configNode);
            default -> throw new IllegalArgumentException(String.format("unexpected enum '%s'", configNode.getType().toString()));
        };
    }

    private Node toExistsNode(VcfMetadata vcfMetadata, String id, ConfigExistsNode configNode) {
        Field field = vcfMetadata.getField(configNode.getField());
        return ExistsNode.builder().id(id).field(field).description(configNode.getDescription()).build();
    }

    private BoolNode toBoolNode(VcfMetadata vcfMetadata, String id, ConfigBoolNode nodeConfig, Map<String, Set<String>> files) {
        BoolQuery boolQuery = this.toBoolQuery(vcfMetadata, nodeConfig.getQuery(), files);
        return BoolNode.builder().id(id).description(nodeConfig.getDescription()).query(boolQuery).build();
    }

    private BoolQuery toBoolQuery(VcfMetadata vcfMetadata, ConfigBoolQuery configBoolQuery, Map<String, Set<String>> files) {
        BoolQuery.Operator operator = this.toOperator(configBoolQuery.getOperator());
        Field field = vcfMetadata.getField(configBoolQuery.getField());
        this.queryValidator.validateBooleanNode(configBoolQuery, field);
        Set<String> value = configBoolQuery.getValue();
        if (value.toString().startsWith("file:")) {
            value = files.get(((String)((Object)value)).substring("file:".length()));
        }
        return BoolQuery.builder().field(field).operator(operator).value(value).build();
    }

    private BoolMultiNode toBoolMultiNode(VcfMetadata vcfMetadata, String id, ConfigBoolMultiNode nodeConfig, Map<String, Set<String>> files) {
        List<BoolMultiQuery> boolMultiQueries = nodeConfig.getOutcomes().stream().map(clause -> this.toBoolClause(vcfMetadata, (ConfigBoolMultiQuery)clause, files)).toList();
        List<Field> fields = nodeConfig.getFields().stream().map(vcfMetadata::getField).toList();
        return BoolMultiNode.builder().id(id).fields(fields).description(nodeConfig.getDescription()).clauses(boolMultiQueries).build();
    }

    private BoolMultiQuery toBoolClause(VcfMetadata vcfMetadata, ConfigBoolMultiQuery configBoolMultiQuery, Map<String, Set<String>> files) {
        List<BoolQuery> queries = configBoolMultiQuery.getQueries().stream().map(query -> this.toBoolQuery(vcfMetadata, (ConfigBoolQuery)query, files)).toList();
        return BoolMultiQuery.builder().id(configBoolMultiQuery.getId()).queryList(queries).operator(this.toMultiQueryOperator(configBoolMultiQuery.getOperator())).build();
    }

    private BoolMultiQuery.Operator toMultiQueryOperator(ConfigClauseOperator configOperator) {
        if (configOperator == null) {
            return null;
        }
        return switch (configOperator) {
            case ConfigClauseOperator.AND -> BoolMultiQuery.Operator.AND;
            case ConfigClauseOperator.OR -> BoolMultiQuery.Operator.OR;
            default -> throw new UnexpectedEnumException(configOperator);
        };
    }

    private BoolQuery.Operator toOperator(ConfigOperator configOperator) {
        return switch (configOperator) {
            case ConfigOperator.EQUALS -> BoolQuery.Operator.EQUALS;
            case ConfigOperator.NOT_EQUALS -> BoolQuery.Operator.NOT_EQUALS;
            case ConfigOperator.LESS -> BoolQuery.Operator.LESS;
            case ConfigOperator.LESS_OR_EQUAL -> BoolQuery.Operator.LESS_OR_EQUAL;
            case ConfigOperator.GREATER -> BoolQuery.Operator.GREATER;
            case ConfigOperator.GREATER_OR_EQUAL -> BoolQuery.Operator.GREATER_OR_EQUAL;
            case ConfigOperator.IN -> BoolQuery.Operator.IN;
            case ConfigOperator.NOT_IN -> BoolQuery.Operator.NOT_IN;
            case ConfigOperator.CONTAINS -> BoolQuery.Operator.CONTAINS;
            case ConfigOperator.NOT_CONTAINS -> BoolQuery.Operator.NOT_CONTAINS;
            case ConfigOperator.CONTAINS_ALL -> BoolQuery.Operator.CONTAINS_ALL;
            case ConfigOperator.CONTAINS_ANY -> BoolQuery.Operator.CONTAINS_ANY;
            case ConfigOperator.CONTAINS_NONE -> BoolQuery.Operator.CONTAINS_NONE;
            default -> throw new UnexpectedEnumException(configOperator);
        };
    }

    private CategoricalNode toCategoricalNode(VcfMetadata vcfMetadata, String id, ConfigCategoricalNode nodeConfig) {
        Field field = vcfMetadata.getField(nodeConfig.getField());
        this.queryValidator.validateCategoricalNode(field);
        return CategoricalNode.builder().id(id).description(nodeConfig.getDescription()).field(field).build();
    }

    private LeafNode toLeafNode(String id, ConfigLeafNode nodeConfig) {
        return LeafNode.builder().id(id).description(nodeConfig.getDescription()).clazz(nodeConfig.getClazz()).build();
    }

    private void updateNode(Node node, ConfigNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        if (node.getNodeType() == NodeType.LEAF) {
            return;
        }
        switch (configNode.getType()) {
            case EXISTS: {
                this.updateExistsNode((ExistsNode)node, (ConfigExistsNode)configNode, nodeMap, labelMap);
                break;
            }
            case BOOL: {
                this.updateBoolNode((BoolNode)node, (ConfigBoolNode)configNode, nodeMap, labelMap);
                break;
            }
            case BOOL_MULTI: {
                this.updateBoolMultiNode((BoolMultiNode)node, (ConfigBoolMultiNode)configNode, nodeMap, labelMap);
                break;
            }
            case CATEGORICAL: {
                this.updateEnumNode((CategoricalNode)node, (ConfigCategoricalNode)configNode, nodeMap, labelMap);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unexpected enum '%s'", configNode.getType().toString()));
            }
        }
    }

    private void updateExistsNode(ExistsNode node, ConfigExistsNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome outcomeTrue = this.toNodeOutcome(configNode.getOutcomeTrue(), nodeMap, labelMap);
        node.setOutcomeTrue(outcomeTrue);
        NodeOutcome outcomeFalse = this.toNodeOutcome(configNode.getOutcomeFalse(), nodeMap, labelMap);
        node.setOutcomeFalse(outcomeFalse);
    }

    private void updateBoolNode(BoolNode node, ConfigBoolNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome outcomeTrue = this.toNodeOutcome(configNode.getOutcomeTrue(), nodeMap, labelMap);
        node.setOutcomeTrue(outcomeTrue);
        NodeOutcome outcomeFalse = this.toNodeOutcome(configNode.getOutcomeFalse(), nodeMap, labelMap);
        node.setOutcomeFalse(outcomeFalse);
        NodeOutcome outcomeMissing = this.toNodeOutcome(configNode.getOutcomeMissing(), nodeMap, labelMap);
        node.setOutcomeMissing(outcomeMissing);
    }

    private void updateBoolMultiNode(BoolMultiNode node, ConfigBoolMultiNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        Map<String, ConfigBoolMultiQuery> clauses = configNode.getOutcomes().stream().collect(Collectors.toMap(ConfigBoolMultiQuery::getId, clause -> clause));
        node.setClauses(node.getClauses().stream().map(clause -> this.updateClause((BoolMultiQuery)clause, (ConfigBoolMultiQuery)clauses.get(clause.getId()), nodeMap, labelMap)).toList());
        NodeOutcome outcomeMissing = this.toNodeOutcome(configNode.getOutcomeMissing(), nodeMap, labelMap);
        node.setOutcomeMissing(outcomeMissing);
        NodeOutcome outcomeDefault = this.toNodeOutcome(configNode.getOutcomeDefault(), nodeMap, labelMap);
        node.setOutcomeDefault(outcomeDefault);
    }

    private BoolMultiQuery updateClause(BoolMultiQuery clause, ConfigBoolMultiQuery configBoolMultiQuery, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome outcomeDefault = this.toNodeOutcome(configBoolMultiQuery.getOutcomeTrue(), nodeMap, labelMap);
        clause.setOutcomeTrue(outcomeDefault);
        return clause;
    }

    private void updateEnumNode(CategoricalNode node, ConfigCategoricalNode configNode, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        HashMap<String, NodeOutcome> outcomeMap = new HashMap<String, NodeOutcome>();
        configNode.getOutcomeMap().forEach((key, configOutcome) -> {
            NodeOutcome outcome = this.toNodeOutcome((ConfigNodeOutcome)configOutcome, nodeMap, labelMap);
            outcomeMap.put((String)key, outcome);
        });
        node.setOutcomeMap(outcomeMap);
        NodeOutcome outcomeMissing = this.toNodeOutcome(configNode.getOutcomeMissing(), nodeMap, labelMap);
        node.setOutcomeMissing(outcomeMissing);
        NodeOutcome outcomeDefault = this.toNodeOutcome(configNode.getOutcomeDefault(), nodeMap, labelMap);
        node.setOutcomeDefault(outcomeDefault);
    }

    private NodeOutcome toNodeOutcome(@Nullable ConfigNodeOutcome configNodeOutcome, Map<String, Node> nodeMap, Map<String, Label> labelMap) {
        NodeOutcome nodeOutcome;
        if (configNodeOutcome != null) {
            Node nextNode = nodeMap.get(configNodeOutcome.getNextNode());
            Label label = labelMap.get(configNodeOutcome.getLabel());
            nodeOutcome = NodeOutcome.builder().nextNode(nextNode).label(label).build();
        } else {
            nodeOutcome = null;
        }
        return nodeOutcome;
    }
}

