/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.runner;

import java.util.Objects;
import org.molgenis.vcf.decisiontree.Settings;
import org.molgenis.vcf.decisiontree.filter.Classifier;
import org.molgenis.vcf.decisiontree.filter.ConsequenceAnnotator;
import org.molgenis.vcf.decisiontree.filter.RecordWriter;
import org.molgenis.vcf.decisiontree.filter.SampleAnnotator;
import org.molgenis.vcf.decisiontree.filter.VcfMetadata;
import org.molgenis.vcf.decisiontree.filter.VcfReader;
import org.molgenis.vcf.decisiontree.filter.model.DecisionTree;
import org.molgenis.vcf.decisiontree.filter.model.Mode;
import org.molgenis.vcf.decisiontree.filter.model.SamplesContext;
import org.molgenis.vcf.decisiontree.runner.AppRunner;
import org.molgenis.vcf.decisiontree.runner.AppRunnerFactory;
import org.molgenis.vcf.decisiontree.runner.AppRunnerImpl;
import org.molgenis.vcf.decisiontree.runner.ClassifierFactory;
import org.molgenis.vcf.decisiontree.runner.ConsequenceAnnotatorFactory;
import org.molgenis.vcf.decisiontree.runner.DecisionTreeFactory;
import org.molgenis.vcf.decisiontree.runner.RecordWriterFactory;
import org.molgenis.vcf.decisiontree.runner.SampleAnnotatorFactory;
import org.molgenis.vcf.decisiontree.runner.SamplesContextFactory;
import org.molgenis.vcf.decisiontree.runner.ValueValidator;
import org.molgenis.vcf.decisiontree.runner.VcfReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class AppRunnerFactoryImpl
implements AppRunnerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppRunnerFactoryImpl.class);
    private final VcfReaderFactory vcfReaderFactory;
    private final ClassifierFactory classifierFactory;
    private final RecordWriterFactory recordWriterFactory;
    private final DecisionTreeFactory decisionTreeFactory;

    AppRunnerFactoryImpl(VcfReaderFactory vcfReaderFactory, ClassifierFactory classifierFactory, RecordWriterFactory recordWriterFactory, DecisionTreeFactory decisionTreeFactory) {
        this.vcfReaderFactory = Objects.requireNonNull(vcfReaderFactory);
        this.classifierFactory = Objects.requireNonNull(classifierFactory);
        this.recordWriterFactory = Objects.requireNonNull(recordWriterFactory);
        this.decisionTreeFactory = Objects.requireNonNull(decisionTreeFactory);
    }

    @Override
    public AppRunner create(Settings settings) {
        VcfReader vcfReader = this.vcfReaderFactory.create(settings);
        try {
            Classifier classifier;
            VcfMetadata vcfMetadata = vcfReader.getMetadata();
            RecordWriter recordWriter = this.recordWriterFactory.create(vcfMetadata, settings);
            DecisionTree decisionTree = this.decisionTreeFactory.map(vcfMetadata, settings);
            ValueValidator.validate(settings.getConfigDecisionTree(), vcfMetadata);
            if (settings.getMode() == Mode.VARIANT) {
                ConsequenceAnnotator consequenceAnnotator = ConsequenceAnnotatorFactory.create(settings);
                classifier = this.classifierFactory.create(settings, decisionTree, consequenceAnnotator, recordWriter, vcfMetadata);
            } else {
                SampleAnnotator sampleAnnotator = SampleAnnotatorFactory.create(settings);
                SamplesContext samplesContext = SamplesContextFactory.create(settings, vcfMetadata);
                classifier = this.classifierFactory.create(settings, decisionTree, recordWriter, sampleAnnotator, samplesContext);
            }
            return new AppRunnerImpl(classifier, vcfReader, recordWriter);
        }
        catch (Exception e) {
            try {
                vcfReader.close();
            }
            catch (Exception closeException) {
                LOGGER.warn("error closing vcf reader", closeException);
            }
            throw e;
        }
    }
}

