/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.ped;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.molgenis.vcf.decisiontree.ped.PedIndividual;
import org.molgenis.vcf.decisiontree.ped.PedIndividualParser;

public class PedReader
implements AutoCloseable {
    private final BufferedReader bufferedReader;
    private final PedIndividualParser pedIndividualParser;

    public PedReader(Reader reader) {
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.pedIndividualParser = new PedIndividualParser();
    }

    public Iterator<PedIndividual> iterator() {
        return new Iterator<PedIndividual>(){
            PedIndividual nextPedIndividual = null;

            @Override
            public boolean hasNext() {
                if (this.nextPedIndividual == null) {
                    try {
                        this.readPedIndividual();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return this.nextPedIndividual != null;
            }

            @Override
            public PedIndividual next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PedIndividual pedIndividual = this.nextPedIndividual;
                this.nextPedIndividual = null;
                return pedIndividual;
            }

            private void readPedIndividual() throws IOException {
                String line;
                while ((line = PedReader.this.bufferedReader.readLine()) != null && line.startsWith("#")) {
                }
                if (line != null) {
                    this.nextPedIndividual = PedReader.this.pedIndividualParser.parse(line);
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.bufferedReader.close();
    }
}

