/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.ped;

import org.molgenis.vcf.decisiontree.UnsupportedPedException;
import org.molgenis.vcf.decisiontree.ped.InvalidPedException;
import org.molgenis.vcf.decisiontree.ped.PedIndividual;

class PedIndividualParser {
    PedIndividualParser() {
    }

    public PedIndividual parse(String line) {
        String[] tokens = line.split("\\s+");
        if (tokens.length != 6) {
            throw new InvalidPedException(line);
        }
        PedIndividual.Sex sex = this.parseSex(tokens[4]);
        PedIndividual.AffectionStatus affectionStatus = this.parseAffectionStatus(tokens[5]);
        return new PedIndividual(tokens[0], tokens[1], tokens[2], tokens[3], sex, affectionStatus);
    }

    private PedIndividual.Sex parseSex(String token) {
        return switch (token) {
            case "1" -> PedIndividual.Sex.MALE;
            case "2" -> PedIndividual.Sex.FEMALE;
            default -> PedIndividual.Sex.UNKNOWN;
        };
    }

    private PedIndividual.AffectionStatus parseAffectionStatus(String token) {
        return switch (token) {
            case "-9", "0" -> PedIndividual.AffectionStatus.UNKNOWN;
            case "1" -> PedIndividual.AffectionStatus.UNAFFECTED;
            case "2" -> PedIndividual.AffectionStatus.AFFECTED;
            default -> throw new UnsupportedPedException(token);
        };
    }
}

