/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.loader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeLoaderImpl;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidatorImpl;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigCategoricalNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigExistsNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNodeOutcome;
import org.molgenis.vcf.decisiontree.loader.model.Edge;
import org.molgenis.vcf.decisiontree.loader.model.Node;

public class Visualizer {
    static Map<String, AtomicInteger> paths = new HashMap<String, AtomicInteger>();

    public static void main(String[] args) {
        System.out.println("VIP decision-tree Visualizer");
        System.out.println("DISCLAIMER: this tool is in a development state and nowhere near production-grade.");
        if (args.length == 0) {
            System.out.println("Usage: Visualizer <input-json-file>");
            System.exit(1);
        }
        Path path = Path.of(args[0], new String[0]);
        String filename = path.getFileName().toString();
        paths.put("", new AtomicInteger(0));
        ConfigDecisionTreeValidatorImpl validator = new ConfigDecisionTreeValidatorImpl();
        ConfigDecisionTreeLoaderImpl loader = new ConfigDecisionTreeLoaderImpl(validator);
        ConfigDecisionTree tree = loader.load(path);
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashMap<String, Edge> edges = new HashMap<String, Edge>();
        for (Map.Entry<String, ConfigNode> entry : tree.getNodes().entrySet()) {
            HashMap<String, String> boolOutcomes;
            ConfigNode boolNode;
            nodes.add(new Node(entry.getKey(), entry.getValue().getDescription() != null ? entry.getValue().getDescription() : entry.getKey(), entry.getValue().getType() == ConfigNode.Type.LEAF));
            ConfigNode node = entry.getValue();
            if (node.getType() == ConfigNode.Type.BOOL) {
                boolNode = (ConfigBoolNode)node;
                boolOutcomes = new HashMap<String, String>();
                boolOutcomes.put("true", ((ConfigBoolNode)boolNode).getOutcomeTrue().getNextNode());
                boolOutcomes.put("false", ((ConfigBoolNode)boolNode).getOutcomeFalse().getNextNode());
                boolOutcomes.put("missing", ((ConfigBoolNode)boolNode).getOutcomeMissing().getNextNode());
                Visualizer.processOutcomes(edges, entry, boolOutcomes);
                continue;
            }
            if (node.getType() == ConfigNode.Type.EXISTS) {
                boolNode = (ConfigExistsNode)node;
                boolOutcomes = new HashMap();
                boolOutcomes.put("true", ((ConfigExistsNode)boolNode).getOutcomeTrue().getNextNode());
                boolOutcomes.put("false", ((ConfigExistsNode)boolNode).getOutcomeFalse().getNextNode());
                Visualizer.processOutcomes(edges, entry, boolOutcomes);
                continue;
            }
            if (node.getType() == ConfigNode.Type.BOOL_MULTI) {
                ConfigBoolMultiNode boolMultiNode = (ConfigBoolMultiNode)node;
                boolOutcomes = new HashMap();
                for (ConfigBoolMultiQuery configBoolMultiQuery : boolMultiNode.getOutcomes()) {
                    boolOutcomes.put(configBoolMultiQuery.getDescription(), configBoolMultiQuery.getOutcomeTrue().getNextNode());
                }
                boolOutcomes.put("default", boolMultiNode.getOutcomeDefault().getNextNode());
                boolOutcomes.put("missing", boolMultiNode.getOutcomeMissing().getNextNode());
                Visualizer.processOutcomes(edges, entry, boolOutcomes);
                continue;
            }
            if (node.getType() != ConfigNode.Type.CATEGORICAL) continue;
            ConfigCategoricalNode categoricalNode = (ConfigCategoricalNode)node;
            HashMap<String, String> categoricalOutcomes = new HashMap<String, String>();
            if (categoricalNode.getOutcomeDefault() != null) {
                categoricalOutcomes.put("default", categoricalNode.getOutcomeDefault().getNextNode());
            }
            for (Map.Entry entry2 : categoricalNode.getOutcomeMap().entrySet()) {
                categoricalOutcomes.put((String)entry2.getKey(), ((ConfigNodeOutcome)entry2.getValue()).getNextNode());
            }
            Visualizer.processOutcomes(edges, entry, categoricalOutcomes);
        }
        Visualizer.visualizeHtml(nodes, edges, filename, path.toString());
        Visualizer.visualizeMermaid(nodes, edges, filename, path.toString());
    }

    private static void visualizeHtml(List<Node> nodes, Map<String, Edge> edges, String filename, String inputPath) {
        StringBuilder html = new StringBuilder();
        for (Node node : nodes) {
            html.append(Visualizer.nodeToHtml(node));
            html.append("\n");
        }
        for (Edge edge : edges.values()) {
            html.append(Visualizer.edgeToHtml(edge));
            html.append("\n");
        }
        try {
            InputStream stream = Visualizer.class.getClassLoader().getResourceAsStream("template.html");
            String template = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            String output = template.replace("DAGRE_GOES_HERE", html.toString());
            Files.writeString(Path.of(inputPath + ".html", new String[0]), (CharSequence)output, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void visualizeMermaid(List<Node> nodes, Map<String, Edge> edges, String filename, String inputPath) {
        StringBuilder mmdContent = new StringBuilder();
        mmdContent.append("flowchart TD\n");
        for (Node node : nodes) {
            mmdContent.append(Visualizer.nodeToMmd(node));
            mmdContent.append("\n");
            if (!node.isLeaf()) continue;
            mmdContent.append(String.format("style %s_ fill:#00ff00\n", node.getId()));
        }
        for (Edge edge : edges.values()) {
            mmdContent.append(Visualizer.edgeToMmd(edge));
            mmdContent.append("\n");
        }
        try {
            Files.writeString(Path.of(inputPath + ".mmd", new String[0]), (CharSequence)mmdContent.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String edgeToHtml(Edge edge) {
        String label = edge.getLabel() != null ? edge.getLabel() : "Add description to visualize a label.";
        return String.format("g.setEdge(\"%s\", \"%s\", {label: \"%s\"});", edge.getNode1(), edge.getNode2(), label);
    }

    private static String nodeToHtml(Node node) {
        String htmlNode = node.isLeaf() ? String.format("g.setNode(\"%s\", {label: \"%s\", style: \"fill: #00ff00\"});", node.getId(), String.format("%s", node.getLabel())) : String.format("g.setNode(\"%s\", {label: \"%s\", style: \"fill: #33ccff\"});", node.getId(), String.format("%s", node.getLabel()));
        return htmlNode;
    }

    private static String edgeToMmd(Edge edge) {
        String label = edge.getLabel() != null ? edge.getLabel() : "Add description to visualize a label.";
        return String.format("%s_ -->|\"%s\"| %s_", edge.getNode1(), label, edge.getNode2());
    }

    private static String nodeToMmd(Node node) {
        return String.format("%s_(\"%s\")", node.getId(), node.getLabel());
    }

    private static void processOutcomes(Map<String, Edge> edges, Map.Entry<String, ConfigNode> entry, Map<String, String> outcomes) {
        for (Map.Entry<String, String> outcome : outcomes.entrySet()) {
            String id = String.format("%s_%s", entry.getKey(), outcome.getValue());
            Object label = outcome.getKey();
            if (edges.containsKey(id)) {
                Edge edge = edges.get(id);
                String oldLabel = edge.getLabel();
                label = oldLabel + "\\n" + outcome.getKey();
            }
            edges.put(id, new Edge(entry.getKey(), outcome.getValue(), (String)label));
        }
    }
}

