/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.loader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigCategoricalNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigExistsNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigLeafNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;

public class ConfigNodeDeserializer
extends JsonDeserializer<ConfigNode> {
    @Override
    public ConfigNode deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        ObjectCodec objectCodec = jp.getCodec();
        ObjectNode root = (ObjectNode)objectCodec.readTree(jp);
        if (!root.has("type")) {
            throw new JsonMappingException(jp, "missing 'type' property");
        }
        String type = root.get("type").asText();
        return switch (type.toUpperCase()) {
            case "BOOL" -> objectCodec.treeToValue(root, ConfigBoolNode.class);
            case "BOOL_MULTI" -> objectCodec.treeToValue(root, ConfigBoolMultiNode.class);
            case "CATEGORICAL" -> objectCodec.treeToValue(root, ConfigCategoricalNode.class);
            case "EXISTS" -> objectCodec.treeToValue(root, ConfigExistsNode.class);
            case "LEAF" -> objectCodec.treeToValue(root, ConfigLeafNode.class);
            default -> throw new JsonMappingException(jp, String.format("illegal 'type' value '%s' (allowed values: BOOL, BOOL_MULTI, CATEGORICAL, EXISTS, SAMPLE_PHENOTYPE, LEAF).", type));
        };
    }
}

