/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.decisiontree.loader;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.molgenis.vcf.decisiontree.UnexpectedEnumException;
import org.molgenis.vcf.decisiontree.filter.model.FieldType;
import org.molgenis.vcf.decisiontree.filter.model.GenotypeFieldType;
import org.molgenis.vcf.decisiontree.filter.model.SampleFieldType;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidationException;
import org.molgenis.vcf.decisiontree.loader.ConfigDecisionTreeValidator;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolMultiQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigBoolQuery;
import org.molgenis.vcf.decisiontree.loader.model.ConfigCategoricalNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigDecisionTree;
import org.molgenis.vcf.decisiontree.loader.model.ConfigExistsNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigLeafNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNode;
import org.molgenis.vcf.decisiontree.loader.model.ConfigNodeOutcome;
import org.molgenis.vcf.decisiontree.loader.model.ConfigOperator;
import org.molgenis.vcf.decisiontree.utils.VcfUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
class ConfigDecisionTreeValidatorImpl
implements ConfigDecisionTreeValidator {
    private static final Pattern PATTERN_ALPHANUMERIC_UNDERSCORE = Pattern.compile("[a-zA-Z0-9_]+");
    public static final String OUTCOME_TRUE = "outcomeTrue";
    public static final String OUTCOME_FALSE = "outcomeFalse";
    public static final String OUTCOME_MISSING = "outcomeMissing";
    public static final String OUTCOME_DEFAULT = "outcomeDefault";

    ConfigDecisionTreeValidatorImpl() {
    }

    @Override
    public void validate(ConfigDecisionTree configDecisionTree) {
        this.validateRootNode(configDecisionTree);
        this.validateNodes(configDecisionTree);
    }

    private void validateRootNode(ConfigDecisionTree configDecisionTree) {
        String rootNodeId = configDecisionTree.getRootNode();
        if (!configDecisionTree.getNodes().containsKey(rootNodeId)) {
            throw new ConfigDecisionTreeValidationException(String.format("'rootNode' value '%s' refers to unknown node", rootNodeId));
        }
    }

    private void validateNodes(ConfigDecisionTree configDecisionTree) {
        Map<String, ConfigNode> nodes = configDecisionTree.getNodes();
        Map<String, Path> files = configDecisionTree.getFiles();
        nodes.forEach((key, value) -> this.validateNode((String)key, (ConfigNode)value, nodes, files));
    }

    private void validateNode(String id, ConfigNode node, Map<String, ConfigNode> nodes, Map<String, Path> files) {
        this.validateAlphanumericValue("id", id);
        switch (node.getType()) {
            case EXISTS: {
                this.validateExistsNode(id, (ConfigExistsNode)node, nodes);
                break;
            }
            case BOOL: {
                this.validateBoolNode(id, (ConfigBoolNode)node, nodes, files);
                break;
            }
            case BOOL_MULTI: {
                this.validateBoolMultiNode(id, (ConfigBoolMultiNode)node, nodes, files);
                break;
            }
            case CATEGORICAL: {
                this.validateCategoricalNode(id, (ConfigCategoricalNode)node, nodes);
                break;
            }
            case LEAF: {
                this.validateLeafNode(id, (ConfigLeafNode)node);
                break;
            }
            default: {
                throw new UnexpectedEnumException(node.getType());
            }
        }
    }

    private void validateExistsNode(String id, ConfigExistsNode node, Map<String, ConfigNode> nodes) {
        this.validateOutcome(id, OUTCOME_TRUE, nodes, node.getOutcomeTrue());
        this.validateOutcome(id, OUTCOME_FALSE, nodes, node.getOutcomeFalse());
        this.validateField(node.getField(), id);
    }

    private void validateBoolNode(String id, ConfigBoolNode node, Map<String, ConfigNode> nodes, Map<String, Path> files) {
        this.validateValue(id, node.getQuery(), files);
        this.validateQueryValue(node.getQuery(), id);
        this.validateOutcome(id, OUTCOME_TRUE, nodes, node.getOutcomeTrue());
        this.validateOutcome(id, OUTCOME_FALSE, nodes, node.getOutcomeFalse());
        this.validateOutcome(id, OUTCOME_MISSING, nodes, node.getOutcomeMissing());
    }

    private void validateQueryValue(ConfigBoolQuery query, String nodeId) {
        Object value;
        this.validateField(query.getField(), nodeId);
        if (List.of(ConfigOperator.CONTAINS_NONE, ConfigOperator.CONTAINS_ALL, ConfigOperator.CONTAINS_ANY, ConfigOperator.IN).contains((Object)query.getOperator()) && !((value = query.getValue()) instanceof Collection) && !value.toString().startsWith("file:") && !value.toString().startsWith("field:")) {
            throw new ConfigDecisionTreeValidationException(String.format("The query for field '%s' with operator '%s' should have a collection as value", new Object[]{query.getField(), query.getOperator()}));
        }
    }

    private void validateBoolMultiNode(String id, ConfigBoolMultiNode node, Map<String, ConfigNode> nodes, Map<String, Path> files) {
        this.validateFields(node);
        this.validateOutcomes(id, node.getOutcomes(), nodes, files);
        this.validateOutcome(id, OUTCOME_MISSING, nodes, node.getOutcomeMissing());
        this.validateOutcome(id, OUTCOME_DEFAULT, nodes, node.getOutcomeDefault());
    }

    private void validateFields(ConfigBoolMultiNode node) {
        List<String> fields = node.getFields();
        for (ConfigBoolMultiQuery clause : node.getOutcomes()) {
            for (ConfigBoolQuery query : clause.getQueries()) {
                this.validateQueryValue(query, node.getId());
                if (fields.contains(query.getField())) continue;
                throw new ConfigDecisionTreeValidationException(String.format("Field '%s' refers to a field that is not present in the 'fields' list of node '%s'", query.getField(), node.getId()));
            }
        }
    }

    private void validateOutcomes(String id, List<ConfigBoolMultiQuery> outcomes, Map<String, ConfigNode> nodes, Map<String, Path> files) {
        for (ConfigBoolMultiQuery outcome : outcomes) {
            if (outcome.getQueries().size() == 1) {
                if (outcome.getOperator() != null) {
                    throw new ConfigDecisionTreeValidationException(String.format("MultiBool node '%s' contains an outcome with a single query but with an operator.", id));
                }
            } else if (outcome.getQueries().size() > 1) {
                if (outcome.getOperator() == null) {
                    throw new ConfigDecisionTreeValidationException(String.format("MultiBool node '%s' contains an outcome with multiple queries but without an operator.", id));
                }
            } else {
                throw new ConfigDecisionTreeValidationException(String.format("MultiBool node '%s' contains an outcome without any queries.", id));
            }
            for (ConfigBoolQuery query : outcome.getQueries()) {
                this.validateValue(id, query, files);
            }
            this.validateOutcome(id, OUTCOME_TRUE, nodes, outcome.getOutcomeTrue());
        }
    }

    private void validateValue(String id, ConfigBoolQuery query, Map<String, Path> files) {
        String file;
        Object value = query.getValue();
        if (value instanceof String && value.toString().startsWith("file:") && !files.containsKey(file = value.toString().substring("file:".length()))) {
            throw new ConfigDecisionTreeValidationException(String.format("Unknown file value '%s' for node %s", file, id));
        }
    }

    private void validateCategoricalNode(String id, ConfigCategoricalNode node, Map<String, ConfigNode> nodes) {
        node.getOutcomeMap().forEach((key, outcome) -> {
            if (outcome == null) {
                throw new ConfigDecisionTreeValidationException(String.format("node '%s.%s.%s' can't be null.", id, "outcomeMap", key));
            }
            this.validateOutcome(id, "outcomeMap." + key, nodes, (ConfigNodeOutcome)outcome);
        });
        this.validateOutcome(id, OUTCOME_DEFAULT, nodes, node.getOutcomeDefault());
        this.validateOutcome(id, OUTCOME_MISSING, nodes, node.getOutcomeMissing());
        this.validateField(node.getField(), id);
    }

    private void validateField(String field, String nodeId) {
        List<String> fieldTokens = Arrays.asList(field.split("/"));
        FieldType fieldType = VcfUtils.toFieldType(fieldTokens);
        if (fieldType == FieldType.SAMPLE) {
            String parentField = fieldTokens.get(0);
            String childField = fieldTokens.get(1);
            if (Arrays.stream(SampleFieldType.values()).map(Enum::name).noneMatch(enumValue -> enumValue.equals(childField))) {
                throw new ConfigDecisionTreeValidationException(String.format("Field '%s' is not a valid child of field '%s' in node '%s'.", childField, parentField, nodeId));
            }
        } else if (fieldType == FieldType.GENOTYPE) {
            String parentField = fieldTokens.get(1);
            String childField = fieldTokens.get(2);
            if (Arrays.stream(GenotypeFieldType.values()).map(Enum::name).noneMatch(enumValue -> enumValue.equals(childField))) {
                throw new ConfigDecisionTreeValidationException(String.format("Field '%s' is not a valid child of field '%s' in node '%s'.", childField, parentField, nodeId));
            }
        }
    }

    private void validateLeafNode(String id, ConfigLeafNode node) {
        this.validateAlphanumericValue(id + ".class", node.getClazz());
    }

    private void validateOutcome(String id, String field, Map<String, ConfigNode> nodes, @Nullable ConfigNodeOutcome nodeOutcome) {
        if (nodeOutcome == null) {
            return;
        }
        if (!nodes.containsKey(nodeOutcome.getNextNode())) {
            throw new ConfigDecisionTreeValidationException(String.format("node '%s.%s' refers to unknown node '%s'.", id, field, nodeOutcome));
        }
        this.validateAlphanumericValue(id + "." + field, nodeOutcome.getLabel());
    }

    private void validateAlphanumericValue(String field, @Nullable String value) {
        if (value == null) {
            return;
        }
        if (!PATTERN_ALPHANUMERIC_UNDERSCORE.matcher(value).matches()) {
            throw new ConfigDecisionTreeValidationException(String.format("node '%s' with value '%s' contains illegal characters (valid values are a-zA-Z0-9_).", field, value));
        }
    }
}

